/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.treeBrowser;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.JointProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.OfflineModeTreeInput;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class JointContentProvider
extends JointProvider
implements ITreeContentProvider {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$treeBrowser$JointContentProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$treeBrowser$JointContentProvider = JointContentProvider.class$("com.tssap.dtr.client.eclipse.ui.treeBrowser.JointContentProvider")) : class$com$tssap$dtr$client$eclipse$ui$treeBrowser$JointContentProvider));
    private Collection myInputChangeListeners = new HashSet();
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$treeBrowser$JointContentProvider;

    public Object[] getChildren(Object parentElement) {
        return this.getAllChildren(parentElement, false);
    }

    public Object getParent(final Object element) {
        if (element instanceof OfflineModeTreeInput) {
            return null;
        }
        final Object[] parent = new Object[]{null};
        this.forEachProvider(new JointProvider.ProviderVisitorAdapter(){

            public boolean visitTreeContentProvider(ITreeContentProvider provider) {
                try {
                    parent[0] = provider.getParent(element);
                    if (parent[0] != null) {
                        return false;
                    }
                }
                catch (Exception providerProblem) {
                    Logbook.getErrorChapter().println(providerProblem.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)providerProblem);
                }
                return true;
            }
        });
        return parent[0];
    }

    public boolean hasChildren(Object element) {
        if (element instanceof OfflineModeTreeInput) {
            return false;
        }
        Iterator providers = this.providers();
        while (providers.hasNext()) {
            Object provider = providers.next();
            if (!(provider instanceof ITreeContentProvider)) continue;
            try {
                if (!((ITreeContentProvider)provider).hasChildren(element)) continue;
                return true;
            }
            catch (Exception e) {
                Logbook.getErrorChapter().println(e.getMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)e);
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof OfflineModeTreeInput) {
            return new Object[]{inputElement};
        }
        return this.getAllChildren(inputElement, true);
    }

    public void dispose() {
        this.forEachProvider(JointProvider.getDisposeVisitor());
        Iterator it = this.myInputChangeListeners.iterator();
        while (it.hasNext()) {
            IContentProvider nextProvider = (IContentProvider)it.next();
            nextProvider.dispose();
        }
    }

    public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
        if (newInput instanceof OfflineModeTreeInput) {
            return;
        }
        this.forEachProvider(new JointProvider.ProviderVisitorAdapter(){

            public boolean visitTreeContentProvider(ITreeContentProvider provider) {
                try {
                    provider.inputChanged(viewer, oldInput, newInput);
                }
                catch (Exception providerProblem) {
                    Logbook.getErrorChapter().println(providerProblem.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)providerProblem);
                }
                return true;
            }
        });
        Iterator it = this.myInputChangeListeners.iterator();
        while (it.hasNext()) {
            IContentProvider nextProvider = (IContentProvider)it.next();
            nextProvider.inputChanged(viewer, oldInput, newInput);
        }
    }

    public void addInputChangeListener(IContentProvider listener) {
        if (listener != null) {
            this.myInputChangeListeners.add(listener);
        }
    }

    public void removeInputChangeListener(IContentProvider listener) {
        if (listener != null) {
            this.myInputChangeListeners.remove(listener);
        }
    }

    private Object[] getAllChildren(final Object parent, final boolean isTop) {
        final ArrayList allChildren = new ArrayList();
        this.forEachProvider(new JointProvider.ProviderVisitorAdapter(){

            protected boolean visitTreeContentProvider(ITreeContentProvider provider) {
                try {
                    Object[] elements = null;
                    elements = isTop ? provider.getElements(parent) : provider.getChildren(parent);
                    if (elements != null && elements.length > 0) {
                        allChildren.add(elements);
                    }
                }
                catch (Exception providerProblem) {
                    Logbook.getErrorChapter().println(providerProblem.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)providerProblem);
                }
                return true;
            }
        });
        int size = 0;
        Iterator it = allChildren.iterator();
        while (it.hasNext()) {
            size += ((Object[])it.next()).length;
        }
        Object[] result = new Object[size];
        int lastElement = 0;
        Iterator it2 = allChildren.iterator();
        while (it2.hasNext()) {
            Object[] nextArray = (Object[])it2.next();
            System.arraycopy(nextArray, 0, result, lastElement, nextArray.length);
            lastElement += nextArray.length;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

