/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.share;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.UncheckoutAction;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class UnmanageAction
extends TeamAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$share$UnmanageAction == null ? (class$com$tssap$dtr$client$eclipse$ui$share$UnmanageAction = UnmanageAction.class$("com.tssap.dtr.client.eclipse.ui.share.UnmanageAction")) : class$com$tssap$dtr$client$eclipse$ui$share$UnmanageAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$share$UnmanageAction;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem;

    public void run(IAction action) {
        IProject project = this.getSelectedProjects()[0];
        if (project == null) {
            return;
        }
        final HashSet folderItemSet = new HashSet();
        final DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)project);
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) {
                IVfsActivityRecordedFolderItem actFolderItem;
                IVfsFolderItem item = teamProvider.getFolderItem(resource);
                if (item != null && (actFolderItem = item.asActivityRecordedFolderItem()) != null && actFolderItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                    folderItemSet.add(actFolderItem);
                }
                return true;
            }
        };
        try {
            project.accept(visitor, 2, false);
        }
        catch (CoreException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
        }
        if (folderItemSet.size() > 0) {
            MessageDialog dialog = new MessageDialog(this.getShell(), "Checked-out Resources", null, "This project contains checked-out resources.\n\nBefore disconnecting all checked-out resources will be reverted. This will result in the loss of all changes of non-local files.\n\nProceed with revert?", 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
            if (dialog.open() != 0) {
                return;
            }
            IVfsActivityRecordedFolderItem[] items = (IVfsActivityRecordedFolderItem[])Util.getArrayFromIterator(folderItemSet.iterator(), class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem = UnmanageAction.class$("com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem")) : class$com$tssap$dtr$client$lib$vfs$IVfsActivityRecordedFolderItem);
            VfsActionManager.getInstance().doSynchronously((IVfsAction)new UncheckoutAction(items));
        }
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    RepositoryProvider.unmap((IProject)UnmanageAction.super.getSelectedProjects()[0]);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, Policy.bind((String)"DeconfigureProjectAction.deconfigureProject"), 2);
    }

    protected boolean isEnabled() {
        IProject[] selectedProjects = this.getSelectedProjects();
        if (selectedProjects.length != 1) {
            return false;
        }
        return RepositoryProvider.getProvider((IProject)selectedProjects[0]) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

