/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.share;

import com.tssap.dtr.client.eclipse.ui.share.DAVConnectionExpert;
import com.tssap.dtr.client.eclipse.ui.share.Messages;
import com.tssap.dtr.client.eclipse.ui.share.SelectProjectLocationPage;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.core.Team;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectResourcesPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = Messages.getString("SelectResourcesPage.message");
    private IProject m_project;
    private CheckboxTreeViewer m_treeViewer;
    private ITreeContentProvider m_treeContentProvider;
    protected boolean m_useDefaultAct;

    public SelectResourcesPage(IProject project) {
        super(Messages.getString("SelectResourcesPage.name"), Messages.getString("SelectResourcesPage.title"), DAVConnectionExpert.TITLE_IMAGE_CONNECTION_WIZARD.getImageDescriptor());
        this.setMessage(DEFAULT_MESSAGE);
        this.m_project = project;
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        panel.setLayoutData((Object)new GridData(1808));
        this.m_treeViewer = new CheckboxTreeViewer(panel, 2816);
        this.m_treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.m_treeViewer.setContentProvider((IContentProvider)this.getResourceProvider());
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.m_treeViewer.setInput((Object)new Object[]{this.m_project});
        this.m_treeViewer.expandToLevel(2);
        this.m_treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IVfsWorkspace workspace;
                SelectResourcesPage.this.setMessage(DEFAULT_MESSAGE);
                IWizardPage page = SelectResourcesPage.this.getWizard().getPage(SelectProjectLocationPage.NAME);
                if (page instanceof SelectProjectLocationPage && (workspace = ((SelectProjectLocationPage)page).getDestinationWorkspace()) != null && WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
                    SelectResourcesPage.this.m_useDefaultAct = true;
                }
                SelectResourcesPage.this.handleCheckStateChanged(event.getElement(), true);
                SelectResourcesPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.setControl((Control)panel);
    }

    private void handleCheckStateChanged(Object element, boolean firstTime) {
        Object parent;
        if (!(element instanceof IResource)) {
            return;
        }
        boolean checked = this.m_treeViewer.getChecked(element);
        if (firstTime && element instanceof IContainer) {
            this.m_treeViewer.setSubtreeChecked(element, checked);
            String elementPath = ((IContainer)element).getLocation().toOSString();
            Object[] grayedElements = this.m_treeViewer.getGrayedElements();
            int i = 0;
            while (i < grayedElements.length) {
                String path;
                if (grayedElements[i] instanceof IResource && (path = ((IResource)grayedElements[i]).getLocation().toOSString()) != null && path.startsWith(elementPath)) {
                    this.m_treeViewer.setGrayed(grayedElements[i], false);
                }
                ++i;
            }
        }
        if ((parent = this.getResourceProvider().getParent(element)) instanceof IContainer) {
            Object[] children = this.getResourceProvider().getChildren(parent);
            ArrayList<Object> checkedItems = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                if (this.m_treeViewer.getChecked(children[i])) {
                    checkedItems.add(children[i]);
                }
                ++i;
            }
            if (checkedItems.size() == 0) {
                this.m_treeViewer.setChecked(parent, false);
                this.m_treeViewer.setGrayed(parent, false);
                this.handleCheckStateChanged(parent, false);
            } else if (children.length == checkedItems.size()) {
                this.m_treeViewer.setChecked(parent, true);
                this.m_treeViewer.setGrayed(parent, false);
                this.handleCheckStateChanged(parent, false);
            } else if (children.length > checkedItems.size()) {
                this.m_treeViewer.setGrayChecked(parent, true);
                this.handleCheckStateChanged(parent, false);
            }
        }
    }

    private ITreeContentProvider getResourceProvider() {
        if (this.m_treeContentProvider == null) {
            int resourceType = 7;
            this.m_treeContentProvider = new WorkbenchContentProvider(){

                public Object[] getChildren(Object o) {
                    if (o instanceof IContainer) {
                        if (Team.isIgnoredHint((IResource)((IContainer)o))) {
                            return new Object[0];
                        }
                        IResource[] members = null;
                        try {
                            members = ((IContainer)o).members();
                        }
                        catch (CoreException e) {
                            return new Object[0];
                        }
                        ArrayList<IResource> results = new ArrayList<IResource>();
                        int i = 0;
                        while (i < members.length) {
                            if ((members[i].getType() & 7) > 0 && !Team.isIgnoredHint((IResource)members[i])) {
                                results.add(members[i]);
                            }
                            ++i;
                        }
                        return results.toArray();
                    }
                    if (o instanceof Object[]) {
                        return (Object[])o;
                    }
                    return new Object[0];
                }
            };
        }
        return this.m_treeContentProvider;
    }

    public boolean canFlipToNextPage() {
        IResource[] resources;
        return !this.m_useDefaultAct && (resources = this.getSelectedResources()) != null && resources.length > 0;
    }

    protected IResource[] getSelectedResources() {
        Object[] elements = this.m_treeViewer.getCheckedElements();
        if (elements == null || elements.length == 0) {
            return new IResource[0];
        }
        ArrayList<Object> resourcesToAdd = new ArrayList<Object>();
        int i = 0;
        while (i < elements.length) {
            if (!this.m_treeViewer.getGrayed(elements[i]) && elements[i] instanceof IResource) {
                resourcesToAdd.add(elements[i]);
            }
            ++i;
        }
        return resourcesToAdd.toArray(new IResource[resourcesToAdd.size()]);
    }
}

