/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.share;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.share.DAVConnectionExpert;
import com.tssap.dtr.client.eclipse.ui.share.Messages;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.OfflineModeTreeInput;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.OneElementAutoExpander;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryTreeViewer;
import com.tssap.dtr.client.eclipse.ui.util.RefreshLogic;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.LocalFileService;
import java.io.File;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectProjectLocationPage
extends WizardPage {
    protected static final String NAME = Messages.getString("SelectProjectLocationPage.name");
    private static final String TITLE = Messages.getString("SelectProjectLocationPage.title");
    private static final String MESSAGE_DEFAULT = Messages.getString("SelectProjectLocationPage.message");
    private static final String MESSAGE_DESTINATION = Messages.getString("SelectProjectLocationPage.infoMessage.errorDestination");
    private static final String MESSAGE_NOT_MOUNTED = Messages.getString("SelectProjectLocationPage.infoMessage.errorNotMounted");
    private static final String MESSAGE_LOCAL_NOT_EMPTY = Messages.getString("SelectProjectLocationPage.message.warning.local_not_empty");
    private static final String MESSAGE_SERVER_NOT_EMPTY = Messages.getString("SelectProjectLocationPage.message.warning.server_folder_has_local_childrens");
    private static final String MESSAGE_FOLDER_NOT_EMPTY = Messages.getString("SelectProjectLocationPage.message.error.server_folder_not_empty");
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$share$SelectProjectLocationPage == null ? (class$com$tssap$dtr$client$eclipse$ui$share$SelectProjectLocationPage = SelectProjectLocationPage.class$("com.tssap.dtr.client.eclipse.ui.share.SelectProjectLocationPage")) : class$com$tssap$dtr$client$eclipse$ui$share$SelectProjectLocationPage));
    private IProject m_project;
    private String m_viewId;
    private DisabledRepositoryTreeViewer m_repositoryTreeViewer;
    private Combo m_cbClients;
    private Button m_cxEnableRepository;
    private Button m_cxAddIntoActivity;
    private Button m_bnCreateFolder;
    private Text m_txDestination;
    private boolean m_firstTimeSeletionChanged = true;
    private IAction m_actCreateFolder;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$share$SelectProjectLocationPage;
    static /* synthetic */ Class class$java$lang$String;

    public SelectProjectLocationPage(IProject project, String viewId) {
        super(NAME, TITLE, DAVConnectionExpert.TITLE_IMAGE_CONNECTION_WIZARD.getImageDescriptor());
        if (project == null) {
            String errorMsg = "Null pointer was specified instead of project in the connection wizard.";
            this.setMessage(errorMsg, 3);
            throw new RuntimeException(errorMsg);
        }
        if (!project.exists() || !project.isOpen()) {
            String errorMsg = "Unable to perform sharing - project has incorrect state.";
            this.setMessage(errorMsg, 3);
            throw new RuntimeException(errorMsg);
        }
        this.m_project = project;
        this.m_viewId = viewId;
    }

    public void createControl(Composite parent) {
        Composite baseArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        baseArea.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        baseArea.setLayoutData((Object)gridData);
        try {
            this.createSelectionArea(baseArea);
        }
        catch (Exception e) {
            baseArea.dispose();
            Label label = new Label(parent, 0);
            label.setText(e.getMessage());
            this.setControl((Control)label);
            return;
        }
        this.setControl((Control)baseArea);
    }

    private void createSelectionArea(Composite parent) {
        Label label;
        this.checkPrecondition();
        Composite out = new Composite(parent, 0);
        out.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        out.setLayoutData((Object)gridData);
        IConfigurationElement cfgElement = BluebirdPlugin.getViewConfigurationRegistry().getViewConfiguration(this.m_viewId);
        this.m_repositoryTreeViewer = new DisabledRepositoryTreeViewer(this.m_viewId, cfgElement);
        int numberOfInputs = this.m_repositoryTreeViewer.getInputProvider().getNumberOfObjects();
        if (numberOfInputs > 1) {
            label = new Label(out, 0);
            label.setText(Messages.getString("SelectProjectLocationPage.Client.label"));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            this.m_cbClients = new Combo(out, 12);
            Iterator iter = Configuration.getConfiguration().clients();
            TreeMap<String, IClient> clients = new TreeMap<String, IClient>();
            while (iter.hasNext()) {
                IClient client = (IClient)iter.next();
                clients.put(client.getName(), client);
            }
            this.m_cbClients.setItems((String[])Util.getArrayFromIterator(clients.keySet().iterator(), class$java$lang$String == null ? (class$java$lang$String = SelectProjectLocationPage.class$("java.lang.String")) : class$java$lang$String));
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.m_cbClients.setLayoutData((Object)gridData);
        }
        label = new Label(out, 0);
        label.setText(Messages.getString("SelectProjectLocationPage.Remote_Location.label"));
        label.setLayoutData((Object)new GridData(32));
        this.m_cxEnableRepository = new Button(out, 32);
        this.m_cxEnableRepository.setText(Messages.getString("SelectProjectLocationPage.checkBox.Enable_Repository"));
        this.m_cxEnableRepository.setLayoutData((Object)new GridData(640));
        Composite treeArea = new Composite(out, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        treeArea.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        treeArea.setLayoutData((Object)gridData);
        this.m_repositoryTreeViewer.createControl(treeArea);
        this.m_repositoryTreeViewer.getTreeViewer().addTreeListener((ITreeViewerListener)new OneElementAutoExpander(this.m_repositoryTreeViewer.getTreeViewer()));
        this.createContextMenus();
        if (this.m_actCreateFolder != null) {
            this.m_bnCreateFolder = new Button(out, 8);
            this.m_bnCreateFolder.setText(this.m_actCreateFolder.getText());
            this.m_bnCreateFolder.setEnabled(this.m_actCreateFolder.isEnabled());
            this.m_bnCreateFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectProjectLocationPage.this.m_actCreateFolder.run();
                }
            });
            gridData = new GridData(128);
            gridData.horizontalSpan = 2;
            this.m_bnCreateFolder.setLayoutData((Object)gridData);
        }
        IClient activeClient = Configuration.getConfiguration().getActiveClient();
        Object input = this.m_repositoryTreeViewer.getTreeViewer().getInput();
        if (this.m_cbClients != null) {
            String name = null;
            if (input instanceof IVersionedFileSystemManager) {
                name = ((IVersionedFileSystemManager)input).getClientName();
            } else if (activeClient != null) {
                name = activeClient.getName();
            }
            String[] comboItems = this.m_cbClients.getItems();
            int i = 0;
            while (i < comboItems.length) {
                if (comboItems[i].equals(name)) {
                    this.m_cbClients.select(i);
                    break;
                }
                ++i;
            }
        }
        label = new Label(out, 16384);
        label.setText(Messages.getString("SelectProjectLocationPage.labels.new_location"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.m_txDestination = new Text(out, 2056);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.m_txDestination.setLayoutData((Object)gridData);
        label = new Label(out, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.m_cxAddIntoActivity = new Button(out, 32);
        this.m_cxAddIntoActivity.setText(Messages.getString("SelectProjectLocationPage.addIntoActivity.label"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.m_cxAddIntoActivity.setLayoutData((Object)gridData);
        this.updateSeletionArea();
        if (numberOfInputs > 1) {
            this.m_cbClients.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            String clientName = SelectProjectLocationPage.access$200(2.access$100(this.this$1)).getItem(SelectProjectLocationPage.access$200(2.access$100(this.this$1)).getSelectionIndex());
                            IClient client = Configuration.getConfiguration().getClient(clientName);
                            IVersionedFileSystemManager input = null;
                            try {
                                input = VfsManagerProvider.getInstance().getVersionedFileSystemManager(client.getContext());
                            }
                            catch (VfsException ex) {
                                2.access$100(this.this$1).setMessage(ex.getMessage(), 3);
                                LogUtil.logCaughtException((Location)SelectProjectLocationPage.access$300(), (Throwable)ex);
                            }
                            if (input instanceof IVersionedFileSystemManager) {
                                SelectProjectLocationPage.access$400(2.access$100(this.this$1)).setInput(input);
                            } else {
                                SelectProjectLocationPage.access$400(2.access$100(this.this$1)).getTreeViewer().setInput((Object)new OfflineModeTreeInput());
                            }
                            SelectProjectLocationPage.access$502(2.access$100(this.this$1), true);
                            SelectProjectLocationPage.access$600(2.access$100(this.this$1)).setText("");
                            SelectProjectLocationPage.access$600(2.access$100(this.this$1)).setData(null);
                            SelectProjectLocationPage.access$700(2.access$100(this.this$1));
                            Configuration.getConfiguration().setActiveClient(client);
                        }
                    });
                }

                static /* synthetic */ SelectProjectLocationPage access$100(2 x0) {
                    return x0.SelectProjectLocationPage.this;
                }
            });
        }
        this.m_cxEnableRepository.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectLocationPage.this.m_repositoryTreeViewer.setEnabled(SelectProjectLocationPage.this.m_cxEnableRepository.getSelection());
                if (SelectProjectLocationPage.this.m_cxEnableRepository.getSelection() && SelectProjectLocationPage.this.isRepositoryTreeInputCorrect()) {
                    if (!SelectProjectLocationPage.this.enableRepositoryTree((IVersionedFileSystemManager)SelectProjectLocationPage.this.m_repositoryTreeViewer.getTreeViewer().getInput())) {
                        SelectProjectLocationPage.this.setMessage("Detected corresponding destination location at DTR.", 1);
                    } else {
                        SelectProjectLocationPage.this.setMessage(Messages.getString("SelectProjectLocationPage.message.projectMove"), 2);
                    }
                }
                SelectProjectLocationPage.this.m_bnCreateFolder.setEnabled(SelectProjectLocationPage.this.m_actCreateFolder.isEnabled());
                if (!SelectProjectLocationPage.this.m_cxEnableRepository.getSelection()) {
                    SelectProjectLocationPage.this.setDefaultMessage();
                }
                SelectProjectLocationPage.this.m_repositoryTreeViewer.getTreeViewer().getTree().setFocus();
            }
        });
        this.m_txDestination.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectProjectLocationPage.super.getContainer().updateButtons();
            }
        });
        this.m_cxAddIntoActivity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectProjectLocationPage.super.getContainer().updateButtons();
            }
        });
        this.m_repositoryTreeViewer.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionEvent) {
                Object selectedElement;
                SelectProjectLocationPage.this.setMessage(null);
                if (SelectProjectLocationPage.this.m_bnCreateFolder != null) {
                    SelectProjectLocationPage.this.m_bnCreateFolder.setEnabled(SelectProjectLocationPage.this.m_actCreateFolder.isEnabled());
                }
                if (!SelectProjectLocationPage.this.isRepositoryTreeInputCorrect()) {
                    return;
                }
                ISelection selection = selectionEvent.getSelection();
                if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IVfsFolderItem) {
                    if (!SelectProjectLocationPage.this.m_repositoryTreeViewer.isEnabled()) {
                        IVfsFolder destFolder = SelectProjectLocationPage.this.getSelectedVfsFolder();
                        if (destFolder != null && !destFolder.equals(selectedElement)) {
                            SelectProjectLocationPage.this.navigateToObjectInViewer((StructuredViewer)SelectProjectLocationPage.this.m_repositoryTreeViewer.getTreeViewer(), destFolder);
                        }
                        if (SelectProjectLocationPage.this.m_firstTimeSeletionChanged) {
                            SelectProjectLocationPage.this.m_firstTimeSeletionChanged = false;
                        }
                        return;
                    }
                    SelectProjectLocationPage.this.setProjectLocation((IVfsFolderItem)selectedElement);
                    if (SelectProjectLocationPage.this.m_firstTimeSeletionChanged) {
                        SelectProjectLocationPage.this.m_firstTimeSeletionChanged = false;
                    }
                    return;
                }
                SelectProjectLocationPage.this.setProjectLocation(null);
            }
        });
    }

    private void checkPrecondition() throws IllegalStateException {
        IClient activeClient = Configuration.getConfiguration().getActiveClient();
        if (activeClient == null) {
            String errorMsg = Messages.getString("SelectProjectLocationPage.No_clients_available._1");
            this.setMessage(errorMsg, 3);
            throw new IllegalStateException(errorMsg);
        }
        try {
            if (VfsManagerProvider.getInstance().isSapIDELoginAvailable() && !VfsManagerProvider.getInstance().isUserLoggedinInSapIDE() && !VfsManagerProvider.getInstance().logIn(activeClient.getContext())) {
                String errorMsg = Messages.getString("SelectProjectLocationPage.User_cancelled_login._2");
                this.setMessage(errorMsg, 3);
                throw new IllegalStateException(errorMsg);
            }
        }
        catch (VfsException e) {
            this.setMessage(e.getMessage(), 3);
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    private void createContextMenus() {
        this.m_actCreateFolder = new Action(Messages.getString("SelectProjectLocationPage.Action.Create_Folder")){

            public boolean isEnabled() {
                IVfsContext.MountpointRelation relation;
                IVfsContext context;
                IVfsFolderItem el;
                ISelection sel;
                return !(!SelectProjectLocationPage.this.isRepositoryTreeInputCorrect() || !SelectProjectLocationPage.this.m_repositoryTreeViewer.isEnabled() || !((sel = SelectProjectLocationPage.this.m_repositoryTreeViewer.getTreeViewer().getSelection()) instanceof IStructuredSelection) || !((el = (IVfsFolderItem)((IStructuredSelection)sel).getFirstElement()) instanceof IVfsWorkspace) && !(el instanceof IVfsFolder) || (context = el.getContext()) == null || (relation = context.getMountpointRelation(el.getAbsoluteRemotePath())) != IVfsContext.MountpointRelation.MOUNTPOINT && relation != IVfsContext.MountpointRelation.BELOW_MOUNTPOINT);
            }

            public void run() {
                ISelection sel = SelectProjectLocationPage.this.m_repositoryTreeViewer.getTreeViewer().getSelection();
                if (sel instanceof IStructuredSelection) {
                    IVfsFolderItem parentFolder = (IVfsFolderItem)((IStructuredSelection)sel).getFirstElement();
                    File localFile = new File(parentFolder.getLocalFile().getAbsolutePath());
                    InputDialog dialog = new InputDialog(SelectProjectLocationPage.this.getShell(), Messages.getString("SelectProjectLocationPage.Dialog.title.Create_New_Folder"), Messages.getString("SelectProjectLocationPage.Dialog.message.Create_New_Folder"), "", null);
                    if (dialog.open() == 0) {
                        File newDir = new File(localFile, dialog.getValue());
                        newDir.mkdirs();
                        Object input = SelectProjectLocationPage.this.m_repositoryTreeViewer.getTreeViewer().getInput();
                        RefreshLogic.setRefresh(true);
                        SelectProjectLocationPage.this.m_repositoryTreeViewer.getInputProvider().refreshInput(input);
                        SelectProjectLocationPage.this.m_repositoryTreeViewer.getTreeViewer().refresh((Object)parentFolder);
                        RefreshLogic.setRefresh(false);
                        try {
                            IVfsFolderItem newFolderItem = parentFolder.getVersionedFileSystemManager().getFolderItem(newDir.getAbsolutePath());
                            if (newFolderItem != null) {
                                SelectProjectLocationPage.this.m_repositoryTreeViewer.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)newFolderItem), true);
                            }
                        }
                        catch (VfsException x) {
                            SelectProjectLocationPage.this.setMessage(x.getMessage(), 3);
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                        }
                    }
                }
            }
        };
        ActionContributionItem contItem = new ActionContributionItem(this.m_actCreateFolder){

            public boolean isDynamic() {
                return true;
            }
        };
        this.m_repositoryTreeViewer.getMenuManager().addMenuListener(new IMenuListener((IContributionItem)contItem){
            private final /* synthetic */ IContributionItem val$contItem;
            {
                this.val$contItem = val$contItem;
            }

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add(this.val$contItem);
            }
        });
    }

    public boolean canFlipToNextPage() {
        return this.m_cxAddIntoActivity.getSelection() && this.m_txDestination.getData() instanceof IVfsFolder;
    }

    public boolean isPageComplete() {
        return !this.m_cxAddIntoActivity.getSelection() && this.m_txDestination.getData() instanceof IVfsFolder;
    }

    private void setProjectLocation(IVfsFolderItem folderItem) {
        boolean isSelectedDestinationAllowable = false;
        if (folderItem instanceof IVfsFolder) {
            if (folderItem.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED) {
                this.setMessage(MESSAGE_NOT_MOUNTED, 3);
            } else {
                isSelectedDestinationAllowable = true;
                IVfsFolder folder = (IVfsFolder)folderItem;
                LocalFileService localFileService = new LocalFileService();
                String folderPath = PathUtilities.assureTrailingSeparator((String)folder.getLocalPath(), (IFileService)localFileService);
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (projects[i] != this.m_project) {
                        String projectPath = PathUtilities.assureTrailingSeparator((String)projects[i].getLocation().toOSString(), (IFileService)localFileService);
                        if (projectPath.equals(folderPath)) {
                            this.setMessage("Selected folder is the project root of another project \"" + projects[i].getName() + "\".", 3);
                            isSelectedDestinationAllowable = false;
                            break;
                        }
                        if (folderPath.startsWith(projectPath)) {
                            this.setMessage("Selected folder is under another existing project \"" + projects[i].getName() + "\".", 3);
                            isSelectedDestinationAllowable = false;
                            break;
                        }
                    }
                    ++i;
                }
                if (isSelectedDestinationAllowable) {
                    try {
                        IVfsFolderItem[] childrens = folder.refreshFolderItems();
                        if (childrens != null && childrens.length > 0) {
                            if (folder.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                                String projectPath = PathUtilities.assureTrailingSeparator((String)this.m_project.getLocation().toOSString(), (IFileService)localFileService);
                                if (!projectPath.equals(folderPath)) {
                                    this.setMessage(MESSAGE_LOCAL_NOT_EMPTY, 2);
                                }
                            } else {
                                boolean existsRemoteChild = false;
                                int i2 = 0;
                                while (i2 < childrens.length) {
                                    if (childrens[i2].getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY) {
                                        this.setMessage(MESSAGE_FOLDER_NOT_EMPTY, 2);
                                        existsRemoteChild = true;
                                        break;
                                    }
                                    ++i2;
                                }
                                if (!existsRemoteChild) {
                                    this.setMessage(MESSAGE_SERVER_NOT_EMPTY, 2);
                                }
                            }
                        }
                    }
                    catch (VfsException e) {
                        this.setMessage("Retrieving folder items from selected destination failed.\n(" + e.getMessage() + ")", 3);
                        LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                    }
                    this.m_txDestination.setText(folderPath);
                    this.m_txDestination.setData((Object)folder);
                }
            }
        } else if (this.m_firstTimeSeletionChanged) {
            this.setDefaultMessage();
        } else {
            this.setMessage(MESSAGE_DESTINATION, 3);
        }
        if (!isSelectedDestinationAllowable) {
            this.m_txDestination.setText("");
            this.m_txDestination.setData(null);
        }
        this.getContainer().updateButtons();
    }

    private IVfsFolder getSelectedVfsFolder() {
        if (this.m_txDestination != null) {
            return (IVfsFolder)this.m_txDestination.getData();
        }
        return null;
    }

    public File getNewProjectLocation() {
        IVfsFolder dest;
        if (this.m_txDestination != null && (dest = (IVfsFolder)this.m_txDestination.getData()) != null && dest.getLocationState() != VfsFolderItemLocationState.NOT_MOUNTED) {
            return new File(dest.getLocalFile().getAbsolutePath());
        }
        return null;
    }

    public IVfsWorkspace getDestinationWorkspace() {
        IVfsFolder item = this.getSelectedVfsFolder();
        if (item == null || item.asActivityRecordedFolderItem() == null) {
            return null;
        }
        return ((IVfsActivityRecordedFolderItem)item).getWorkspace();
    }

    public boolean getAddIntoActivity() {
        return this.m_cxAddIntoActivity.getSelection();
    }

    private boolean isRepositoryTreeInputCorrect() {
        if (this.m_repositoryTreeViewer != null) {
            return this.m_repositoryTreeViewer.getTreeViewer().getInput() instanceof IVersionedFileSystemManager;
        }
        return false;
    }

    private void setDefaultMessage() {
        this.setMessage(MESSAGE_DEFAULT);
    }

    private void updateSeletionArea() {
        this.m_repositoryTreeViewer.getTreeViewer().getTree().setFocus();
        Object input = this.m_repositoryTreeViewer.getTreeViewer().getInput();
        if (input instanceof IVersionedFileSystemManager) {
            boolean enable = this.enableRepositoryTree((IVersionedFileSystemManager)input);
            this.m_repositoryTreeViewer.setEnabled(enable);
            this.m_cxEnableRepository.setEnabled(true);
            this.m_cxEnableRepository.setSelection(enable);
            this.m_cxEnableRepository.setVisible(!enable);
            this.m_cxAddIntoActivity.setEnabled(true);
            if (enable) {
                this.m_repositoryTreeViewer.getTreeViewer().expandToLevel(2);
                this.setDefaultMessage();
            } else {
                this.setMessage("Detected corresponding destination location at DTR.", 1);
            }
        } else {
            this.m_repositoryTreeViewer.setEnabled(false);
            this.m_cxEnableRepository.setEnabled(false);
            this.m_cxAddIntoActivity.setEnabled(false);
            IClient activeClient = Configuration.getConfiguration().getActiveClient();
            if (activeClient != null) {
                this.setMessage(Messages.getString("SelectProjectLocationPage.Client.selection.error.message.part1") + activeClient.getName() + Messages.getString("SelectProjectLocationPage.Client.selection.error.message.part2"), 3);
            } else {
                this.setMessage("Connecting to repository server failed.", 3);
            }
        }
    }

    private boolean enableRepositoryTree(IVersionedFileSystemManager input) {
        boolean m_defaultEnabled = false;
        if (input == null) {
            return m_defaultEnabled;
        }
        String[] mountPoints = input.getCurrentContext().getAbsoluteLocalPathsOfMountPoints();
        int i = 0;
        while (i < mountPoints.length) {
            Path mountPointPath = new Path(mountPoints[i]);
            if (mountPointPath.isPrefixOf(this.m_project.getLocation())) {
                try {
                    IVfsFolderItem item = input.getFolderItem(this.m_project.getLocation().toOSString());
                    if (item.asFolder() == null) break;
                    this.navigateToObjectInViewer((StructuredViewer)this.m_repositoryTreeViewer.getTreeViewer(), item);
                    this.m_txDestination.setText(item.getLocalPath());
                    this.m_txDestination.setData((Object)item);
                    return m_defaultEnabled;
                }
                catch (VfsException e) {
                    this.setMessage("Failed to retrieve folder items for selected project.\n(" + e.getMessage() + ")", 3);
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
                break;
            }
            ++i;
        }
        m_defaultEnabled = true;
        return m_defaultEnabled;
    }

    private boolean navigateToObjectInViewer(StructuredViewer viewer, Object destObject) {
        if (destObject == null) {
            return false;
        }
        viewer.setSelection((ISelection)new StructuredSelection(destObject), true);
        return viewer.testFindItem(destObject) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Combo access$200(SelectProjectLocationPage x0) {
        return x0.m_cbClients;
    }

    static /* synthetic */ Text access$600(SelectProjectLocationPage x0) {
        return x0.m_txDestination;
    }

    static /* synthetic */ void access$700(SelectProjectLocationPage x0) {
        x0.updateSeletionArea();
    }

    class DisabledRepositoryTreeViewer
    extends RepositoryTreeViewer {
        private boolean fEnabled = true;

        public DisabledRepositoryTreeViewer(String viewId, IConfigurationElement cfg) {
            super(viewId, cfg, 2820);
        }

        public boolean isEnabled() {
            return this.fEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.fEnabled = enabled;
            if (this.fEnabled) {
                this.getTreeViewer().getTree().setBackground(this.getTreeViewer().getControl().getDisplay().getSystemColor(25));
            } else {
                this.getTreeViewer().getTree().setBackground(this.getTreeViewer().getControl().getDisplay().getSystemColor(22));
            }
        }
    }
}

