/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.share;

import com.tssap.dtr.client.eclipse.ui.ActivitySelectionViewer;
import com.tssap.dtr.client.eclipse.ui.ActivityViewerInput;
import com.tssap.dtr.client.eclipse.ui.share.DAVConnectionExpert;
import com.tssap.dtr.client.eclipse.ui.share.Messages;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectActivityPage
extends WizardPage {
    private IVfsActivity fActivity;
    private ActivitySelectionViewer fActivityViewer;
    private IVfsWorkspace m_workspace = null;

    public SelectActivityPage(IVfsWorkspace workspace) {
        super(Messages.getString("SelectActivityPage.page.Name"), Messages.getString("SelectActivityPage.page.title"), DAVConnectionExpert.TITLE_IMAGE_CONNECTION_WIZARD.getImageDescriptor());
        this.setMessage(Messages.getString("SelectActivityPage.page.message"));
        this.m_workspace = workspace;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)new GridData(1808));
        this.fActivityViewer = new ActivitySelectionViewer(panel, false, null, null);
        this.fActivityViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = SelectActivityPage.this.fActivityViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structSel = (IStructuredSelection)selection;
                    if (!structSel.isEmpty() && structSel.getFirstElement() instanceof IVfsActivity) {
                        SelectActivityPage.this.fActivity = (IVfsActivity)structSel.getFirstElement();
                    } else {
                        SelectActivityPage.this.fActivity = null;
                    }
                }
                SelectActivityPage.this.setPageComplete(SelectActivityPage.this.fActivity != null);
                if (SelectActivityPage.super.isCurrentPage()) {
                    SelectActivityPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        Control control = this.fActivityViewer.getControl();
        if (control instanceof Composite) {
            Button buttonNew = new Button((Composite)control, 8);
            buttonNew.setText(this.fActivityViewer.getCreateActivityAction().getText());
            GridData gridData = new GridData(128);
            gridData.horizontalSpan = 2;
            gridData.widthHint = LayoutHelper.getButtonWidthHint(buttonNew);
            buttonNew.setLayoutData((Object)gridData);
            buttonNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectActivityPage.this.fActivityViewer.getCreateActivityAction().run();
                }
            });
        }
        this.setControl((Control)panel);
        this.fActivityViewer.setInput(new ActivityViewerInput(this.m_workspace, null));
    }

    public void setWorkspace(IVfsWorkspace workspace) {
        this.m_workspace = workspace;
        if (this.fActivityViewer != null) {
            ActivityViewerInput input = new ActivityViewerInput(workspace, null);
            this.fActivityViewer.setInput(input);
        }
    }

    public IVfsWorkspace getWorkspace() {
        return this.m_workspace;
    }

    public IVfsActivity getSelectedActivity() {
        return this.fActivity;
    }
}

