/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.share;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.share.SelectActivityPage;
import com.tssap.dtr.client.eclipse.ui.share.SelectProjectLocationPage;
import com.tssap.dtr.client.eclipse.ui.share.SelectResourcesPage;
import com.tssap.dtr.client.eclipse.ui.util.ImageDescriptorSingletone;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.actions.AddAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;

public class DAVConnectionExpert
extends Wizard
implements IConfigurationWizard,
IExecutableExtension {
    public static final String PERFORM_CHECKIN = "do.checkin";
    private static final String EXPERT_TITLE = "Share Project";
    private static final String BROWSER_CONFIGURATION_ELEMENT = "repositoryBrowser";
    private static final String VIEW_ID_ATTRIBUTE = "viewId";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$share$DAVConnectionExpert == null ? (class$com$tssap$dtr$client$eclipse$ui$share$DAVConnectionExpert = DAVConnectionExpert.class$("com.tssap.dtr.client.eclipse.ui.share.DAVConnectionExpert")) : class$com$tssap$dtr$client$eclipse$ui$share$DAVConnectionExpert));
    protected static final ImageDescriptorSingletone TITLE_IMAGE_CONNECTION_WIZARD = new ImageDescriptorSingletone("connectionWizard/DTRClient.gif");
    private IWorkbench m_workbench;
    private IProject m_project;
    private SelectProjectLocationPage m_locationPage;
    private SelectResourcesPage m_resourcesPage;
    private SelectActivityPage m_activityPage;
    private String myViewId = "";
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$share$DAVConnectionExpert;

    public DAVConnectionExpert() {
        this.setWindowTitle(EXPERT_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        IConfigurationElement[] browserConfiguration = cfig.getChildren(BROWSER_CONFIGURATION_ELEMENT);
        if (browserConfiguration.length != 1) {
            Logbook.getErrorChapter().println("Incorrect number of configuration elements (repositoryBrowser) specified for the ConnectionExpert: " + browserConfiguration.length + ", should be 1.");
            return;
        }
        this.myViewId = browserConfiguration[0].getAttribute(VIEW_ID_ATTRIBUTE);
    }

    public boolean performFinish() {
        boolean shared;
        final File newProjectLocation = this.m_locationPage.getNewProjectLocation();
        if (newProjectLocation == null) {
            String errorMsg = "Unable to associate project " + this.m_project.getName() + " with DTR - incorrect new project location (null) was specified.";
            if (!this.setMessageOnWizard(errorMsg, 3)) {
                Logbook.getErrorChapter().println(errorMsg);
            }
            return false;
        }
        String clientName = Configuration.getConfiguration().getActiveClient().getName();
        if (clientName == null) {
            String errorMsg = "Unable to associate project " + this.m_project.getName() + " with DTR - corresponding client is null.";
            if (!this.setMessageOnWizard(errorMsg, 3)) {
                Logbook.getErrorChapter().println(errorMsg);
            }
            return false;
        }
        if (!newProjectLocation.equals(this.m_project.getLocation().toFile())) {
            final Boolean[] moved = new Boolean[]{Boolean.TRUE};
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        DAVConnectionExpert.this.moveProjectTo(newProjectLocation);
                    }
                    catch (CoreException unableToMoveProject) {
                        String errorMsg = "Project association with DTR failed - unable to move project to new location.\n(" + unableToMoveProject.getMessage() + ")";
                        if (!DAVConnectionExpert.this.setMessageOnWizard(errorMsg, 3)) {
                            Logbook.getErrorChapter().println(errorMsg);
                        }
                        LogUtil.logException((Location)LOCATION, (Throwable)unableToMoveProject);
                        moved[0] = Boolean.FALSE;
                    }
                }
            });
            if (!moved[0].booleanValue()) {
                return false;
            }
        }
        if (shared = BluebirdPlugin.getDefault().associateProjectWithDTR(this.m_project, clientName)) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DAVConnectionExpert.this.addIntoActivity(DAVConnectionExpert.this.m_project);
                }
            });
        }
        return shared;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.m_locationPage) {
            return currentPage.isPageComplete();
        }
        if (currentPage == this.m_resourcesPage) {
            return !currentPage.canFlipToNextPage();
        }
        if (currentPage == this.m_activityPage) {
            return this.m_activityPage.getSelectedActivity() != null;
        }
        return super.canFinish();
    }

    private void addIntoActivity(IProject prj) {
        IVfsActivity activity;
        IResource[] resources = this.m_resourcesPage.getSelectedResources();
        IVfsActivityRecordedFolderItem[] folderItems = this.getFolderItemsForAdding(resources);
        IVfsWorkspace workspace = this.getWorkspace();
        IVfsActivity iVfsActivity = activity = WorkspacesWithDefaultActivity.usingDefaultActivity(workspace) ? null : this.m_activityPage.getSelectedActivity();
        if (folderItems != null && folderItems.length != 0) {
            VfsActionManager.getInstance().doSynchronously((IVfsAction)new AddAction(folderItems, activity, 0));
        }
    }

    private IVfsActivityRecordedFolderItem[] getFolderItemsForAdding(IResource[] resources) {
        if (resources == null || resources.length == 0) {
            return null;
        }
        DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider((IResource)resources[0].getProject());
        if (provider == null) {
            return null;
        }
        IVersionedFileSystemManager manager = provider.getVFSManager();
        if (manager == null) {
            return null;
        }
        ArrayList<IVfsFolderItem> vfsResources = new ArrayList<IVfsFolderItem>();
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IResource) {
                try {
                    IVfsFolderItem item = manager.getFolderItem(resources[i].getLocation().toOSString());
                    if (item != null && item.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                        vfsResources.add(item);
                    }
                }
                catch (VfsException e) {
                    if (!this.setMessageOnWizard(e.getMessage(), 3)) {
                        Logbook.getErrorChapter().println(e.getMessage());
                    }
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                }
            }
            ++i;
        }
        return vfsResources.toArray(new IVfsActivityRecordedFolderItem[vfsResources.size()]);
    }

    public void init(IWorkbench workbench, IProject project) {
        this.m_project = project;
        this.m_workbench = workbench;
    }

    public void addPages() {
        this.m_locationPage = new SelectProjectLocationPage(this.m_project, this.myViewId);
        this.m_resourcesPage = new SelectResourcesPage(this.m_project);
        this.m_activityPage = new SelectActivityPage(null);
        this.addPage((IWizardPage)this.m_locationPage);
        this.addPage((IWizardPage)this.m_resourcesPage);
        this.addPage((IWizardPage)this.m_activityPage);
    }

    protected IVfsWorkspace getWorkspace() {
        return this.m_locationPage.getDestinationWorkspace();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.m_locationPage && this.m_locationPage.getAddIntoActivity()) {
            return this.m_resourcesPage;
        }
        if (page == this.m_resourcesPage) {
            IResource[] elements = this.m_resourcesPage.getSelectedResources();
            if (elements == null) {
                return null;
            }
            if (elements.length > 0) {
                IVfsWorkspace workspace = this.getWorkspace();
                if (workspace == null) {
                    if (!this.setMessageOnWizard("Retrieving workspace failed: workspace is <null>.", 3)) {
                        Logbook.getErrorChapter().println("Retrieving workspace failed: workspace is <null>.");
                    }
                    return null;
                }
                if (WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
                    return null;
                }
                this.m_activityPage.setWorkspace(workspace);
                return this.m_activityPage;
            }
        }
        return null;
    }

    private boolean setMessageOnWizard(String message, int messageType) {
        IWizardPage wizardPage = this.getContainer().getCurrentPage();
        if (wizardPage instanceof WizardPage) {
            ((WizardPage)wizardPage).setMessage(message, messageType);
            return true;
        }
        return false;
    }

    private void moveProjectTo(File destination) throws CoreException {
        IProjectDescription projectDescription = this.m_project.getDescription();
        Path path = new Path(destination.getAbsolutePath());
        projectDescription.setLocation((IPath)path);
        this.m_project.move(projectDescription, true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

