/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.dialogEditor;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.conflict.Messages;
import com.tssap.dtr.client.eclipse.ui.dialogEditor.SimpleDialogKeyBinding;
import com.tssap.dtr.client.eclipse.ui.dialogEditor.SimpleDialogSite;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.ui.util.ResizableTitleDialog;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.texteditor.ITextEditor;

public class DialogEditor
extends ResizableTitleDialog {
    private static final String FILE_EDITOR_DIALOG_LOCATION = "com.tssap.dtr.client.eclipse_fileEditorDialogLocation";
    private static final String FILE_EDITOR_DIALOG_SIZE = "com.tssap.dtr.client.eclipse_fileEditorDialogSize";
    private IEditorPart fEditor;
    private static IEditorSite fEditorSite;
    private Menu fMenu;
    private IAction fFindAction;
    private IAction fGotoLineAcltion;
    private IAction fPrintAction;
    private static final Location LOCATION;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$dialogEditor$DialogEditor;

    public DialogEditor(Shell parent, IEditorPart editor, String title, Image titleImage) {
        super(parent, title, titleImage);
        this.fEditor = editor;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite out = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(out, 2048);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        composite.setFont(parent.getFont());
        if (fEditorSite instanceof SimpleDialogSite) {
            ((SimpleDialogSite)fEditorSite).setShell(this.getShell());
        }
        this.fEditor.createPartControl(composite);
        this.accelerators(parent);
        if (fEditorSite instanceof SimpleDialogSite) {
            SimpleDialogKeyBinding keyBindingService = (SimpleDialogKeyBinding)fEditorSite.getKeyBindingService();
            this.fFindAction = keyBindingService.getAction("org.eclipse.ui.edit.findReplace");
            this.fGotoLineAcltion = keyBindingService.getAction("org.eclipse.ui.edit.text.goto.line");
            this.fPrintAction = keyBindingService.getAction("org.eclipse.ui.file.print");
            SimpleDialogSite site = (SimpleDialogSite)fEditorSite;
            MenuManager manager = site.getMenuManager(this.fMenu);
            if (manager != null) {
                manager.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        manager.add(DialogEditor.this.fFindAction);
                        manager.add(DialogEditor.this.fGotoLineAcltion);
                        manager.add(DialogEditor.this.fPrintAction);
                    }
                });
            }
        }
        return out;
    }

    private void accelerators(Composite parent) {
        Control[] childrens = parent.getChildren();
        GlobalKeyListener listener = new GlobalKeyListener();
        int i = 0;
        while (i < childrens.length) {
            if (childrens[i] instanceof Composite) {
                Composite children = (Composite)childrens[i];
                children.addKeyListener((KeyListener)listener);
                if (children.getMenu() != null && children instanceof StyledText) {
                    this.fMenu = children.getMenu();
                }
                if (children.getChildren().length > 0) {
                    this.accelerators(children);
                }
            } else {
                childrens[i].addKeyListener((KeyListener)listener);
            }
            ++i;
        }
    }

    public boolean close() {
        this.persistShellGeometry();
        return super.close();
    }

    protected void handleShellCloseEvent() {
        if (this.fEditor.isDirty()) {
            MessageDialog dialog = new MessageDialog(this.getShell(), "Save Resource", null, "The content of your local file has been changed.\n\nDo you want to save the changes ?", 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            int returnCode = dialog.open();
            switch (returnCode) {
                case 0: {
                    this.saveContent();
                    break;
                }
                case 1: {
                    if (!(this.fEditor instanceof ITextEditor)) break;
                    ((ITextEditor)this.fEditor).doRevertToSaved();
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        super.handleShellCloseEvent();
    }

    protected void okPressed() {
        this.saveContent();
        super.okPressed();
    }

    private void saveContent() {
        if (this.fEditor.isDirty()) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor pm) throws CoreException {
                    DialogEditor.this.fEditor.doSave(pm);
                }
            };
            Shell shell = this.getShell();
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            pmd.create();
            try {
                operation.run(pmd.getProgressMonitor());
            }
            catch (InterruptedException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
                this.showErrorSavingMessage(x);
            }
            catch (OperationCanceledException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
                this.showErrorSavingMessage(x);
            }
            catch (InvocationTargetException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
                this.showErrorSavingMessage(x);
            }
        }
    }

    private void showErrorSavingMessage(Throwable exception) {
        String title = Messages.getString("Error occured");
        String msg = Messages.getString("Some error occured during saving chages.");
        MessageDialog.openError((Shell)this.getParentShell(), (String)title, (String)(msg + exception.getMessage()));
    }

    protected Point getInitialLocation(Point initialSize) {
        Point locationPoint;
        String locationString = this.getPreferenceStore().getString(FILE_EDITOR_DIALOG_LOCATION);
        if (locationString.length() > 0 && (locationPoint = LayoutHelper.parseCoordinates(locationString)) != null) {
            return locationPoint;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        Point sizePoint;
        String sizeString = this.getPreferenceStore().getString(FILE_EDITOR_DIALOG_SIZE);
        if (sizeString.length() > 0 && (sizePoint = LayoutHelper.parseCoordinates(sizeString)) != null) {
            return sizePoint;
        }
        return super.getInitialSize();
    }

    private void persistShellGeometry() {
        Point shellLocation = this.getShell().getLocation();
        Point shellSize = this.getShell().getSize();
        String locationString = LayoutHelper.serializeCoords(shellLocation);
        String sizeString = LayoutHelper.serializeCoords(shellSize);
        this.getPreferenceStore().setValue(FILE_EDITOR_DIALOG_LOCATION, locationString);
        this.getPreferenceStore().setValue(FILE_EDITOR_DIALOG_SIZE, sizeString);
    }

    public static IEditorDescriptor findEditorDescriptor(String name, boolean useDefault) {
        IWorkbench workbench = BluebirdPlugin.getDefault().getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(name);
        if (descriptor == null || useDefault) {
            descriptor = registry.getDefaultEditor();
        }
        return (EditorDescriptor)descriptor;
    }

    public static IEditorPart createEditor(IEditorDescriptor descriptor) throws PartInitException {
        if (!(descriptor instanceof EditorDescriptor)) {
            throw new PartInitException("Wrong editor descriptor instance");
        }
        final EditorDescriptor desc = (EditorDescriptor)descriptor;
        final IEditorPart[] editor = new IEditorPart[1];
        final Throwable[] ex = new Throwable[1];
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws CoreException {
                editor[0] = (IEditorPart)WorkbenchPlugin.createExtension((IConfigurationElement)desc.getConfigurationElement(), (String)"class");
            }

            public void handleException(Throwable e) {
                ex[0] = e;
            }
        });
        if (ex[0] != null) {
            throw new PartInitException(WorkbenchMessages.format((String)"EditorManager.unableToInstantiate", (Object[])new Object[]{desc.getId(), ex[0]}));
        }
        return editor[0];
    }

    public static IEditorSite getEditorSite(IEditorDescriptor descripror) {
        fEditorSite = descripror instanceof EditorDescriptor ? new SimpleDialogSite((EditorDescriptor)descripror) : new SimpleDialogSite((EditorDescriptor)DialogEditor.findEditorDescriptor("", true));
        return fEditorSite;
    }

    public static void setEditorSite(IEditorSite site) {
        fEditorSite = site;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$dialogEditor$DialogEditor == null ? (class$com$tssap$dtr$client$eclipse$ui$dialogEditor$DialogEditor = DialogEditor.class$("com.tssap.dtr.client.eclipse.ui.dialogEditor.DialogEditor")) : class$com$tssap$dtr$client$eclipse$ui$dialogEditor$DialogEditor));
    }

    class GlobalKeyListener
    implements KeyListener {
        private boolean fCtrlPressed = false;

        GlobalKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 262144) {
                this.fCtrlPressed = true;
            }
            if (e.keyCode == 27) {
                DialogEditor.this.close();
            }
            if (this.fCtrlPressed) {
                this.handleKeys(e.character);
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 262144) {
                this.fCtrlPressed = false;
            }
        }

        private void handleKeys(char character) {
            IAction action = null;
            if (character == '\u0006' && this.fCtrlPressed) {
                action = DialogEditor.this.fFindAction;
            } else if (character == '\f' && this.fCtrlPressed) {
                action = DialogEditor.this.fGotoLineAcltion;
            }
            if (action != null) {
                action.run();
            }
        }
    }
}

