/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.conflict;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.conflict.IntegrateCollisionUtil;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsMergeVersion;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class IntegrateCollisionUtil {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$conflict$IntegrateCollisionUtil == null ? (class$com$tssap$dtr$client$eclipse$ui$conflict$IntegrateCollisionUtil = IntegrateCollisionUtil.class$("com.tssap.dtr.client.eclipse.ui.conflict.IntegrateCollisionUtil")) : class$com$tssap$dtr$client$eclipse$ui$conflict$IntegrateCollisionUtil));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$conflict$IntegrateCollisionUtil;

    public static void undoDiscard(IVfsIntegrateCollision collision) {
        if (collision.getDiscardTargets() == IVfsIntegrateCollision.VfsDiscardTargetVersion.ACTIVE_VERSION) {
            try {
                collision.undoDiscardCollidingVersion(collision.getWorkspace().getDefaultActivity());
            }
            catch (VfsException e) {
                LOCATION.errorT("Caught: " + e.getMessage());
            }
        } else if (collision.getDiscardTargets() == IVfsIntegrateCollision.VfsDiscardTargetVersion.COLLIDING_VERSION) {
            try {
                collision.undoDiscardActiveVersion(collision.getWorkspace().getDefaultActivity());
            }
            catch (VfsException e) {
                LOCATION.errorT("Caught: " + e.getMessage());
            }
        }
    }

    public static void undoMerge(IVfsIntegrateCollision collision) throws VfsException {
        collision.revertMergeVersion();
    }

    public static IVfsMergeVersion getMergedVersion(final IVfsIntegrateCollision collision, final Shell shell) throws VfsException {
        class ValueHolder {
            public IVfsMergeVersion fMergeVersion;

            ValueHolder() {
            }
        }
        final ValueHolder result = new ValueHolder();
        Runnable action = new Runnable(){
            {
            }

            public void run() {
                IVfsMergeVersion[] mergeVersion = new IVfsMergeVersion[]{collision.getMergeVersion()};
                if (mergeVersion[0] == null) {
                    IVfsWorkspace workspace = collision.getWorkspace();
                    IVfsActivity[] activity = new IVfsActivity[1];
                    if (WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
                        try {
                            activity[0] = workspace.getDefaultActivity();
                        }
                        catch (VfsException e) {
                            LogUtil.logException((Location)LOCATION, (Throwable)e);
                            result.fMergeVersion = null;
                            return;
                        }
                    } else {
                        SelectActivityDialog selectActivity = new SelectActivityDialog(shell, collision.getWorkspace());
                        if (selectActivity.open() == 0) {
                            activity[0] = selectActivity.getActivitySelection()[0];
                        } else {
                            result.fMergeVersion = null;
                            return;
                        }
                    }
                    BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(this, mergeVersion, activity){
                        private final /* synthetic */ IVfsMergeVersion[] val$mergeVersion;
                        private final /* synthetic */ IVfsActivity[] val$activity;
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                            this.val$mergeVersion = val$mergeVersion;
                            this.val$activity = val$activity;
                        }

                        public void run() {
                            try {
                                this.val$mergeVersion[0] = 1.access$100(this.this$0).createMergeVersion(this.val$activity[0], 1.access$100(this.this$0).getWorkspace());
                            }
                            catch (VfsException e) {
                                1.access$200(this.this$0).fMergeVersion = null;
                                return;
                            }
                        }
                    });
                }
                result.fMergeVersion = mergeVersion[0];
            }

            static /* synthetic */ IVfsIntegrateCollision access$100(1 x0) {
                return x0.collision;
            }

            static /* synthetic */ ValueHolder access$200(1 x0) {
                return x0.result;
            }
        };
        shell.getDisplay().syncExec(action);
        return result.fMergeVersion;
    }

    public static IVfsActivity getMultipleSelectionActivityInOneWorkspace(final IStructuredSelection selection, final Shell shell) {
        class ValueHolder {
            public IVfsActivity fActivity;

            ValueHolder() {
            }
        }
        final ValueHolder result = new ValueHolder();
        Runnable action = new Runnable(){
            {
            }

            public void run() {
                if (!IntegrateCollisionUtil.belongsToOneWorkspace(selection)) {
                    result.fActivity = null;
                    return;
                }
                if (!IntegrateCollisionUtil.isActivityNeeded(selection)) {
                    result.fActivity = null;
                    return;
                }
                IVfsWorkspace workspace = ((IVfsIntegrateCollision)selection.getFirstElement()).getWorkspace();
                if (WorkspacesWithDefaultActivity.usingDefaultActivity(workspace)) {
                    try {
                        result.fActivity = workspace.getDefaultActivity();
                    }
                    catch (VfsException e) {
                        LogUtil.logException((Location)LOCATION, (Throwable)e);
                        result.fActivity = null;
                        return;
                    }
                    return;
                }
                SelectActivityDialog selectActivityDialog = new SelectActivityDialog(shell, workspace);
                if (selectActivityDialog.open() == 1) {
                    result.fActivity = null;
                    return;
                }
                result.fActivity = selectActivityDialog.getActivitySelection()[0];
            }
        };
        shell.getDisplay().syncExec(action);
        return result.fActivity;
    }

    public static boolean belongsToOneWorkspace(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        if (!(selection.getFirstElement() instanceof IVfsIntegrateCollision)) {
            return false;
        }
        IVfsWorkspace workspace = ((IVfsIntegrateCollision)selection.getFirstElement()).getWorkspace();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IVfsIntegrateCollision)) {
                return false;
            }
            IVfsIntegrateCollision col = (IVfsIntegrateCollision)element;
            if (col.getWorkspace().equals(workspace)) continue;
            return false;
        }
        return true;
    }

    public static boolean isActivityNeeded(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IVfsIntegrateCollision col;
            Object element = iter.next();
            if (!(element instanceof IVfsIntegrateCollision) || (col = (IVfsIntegrateCollision)element).getMergeVersion() != null) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

