/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.conflict;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.preference.DtrPreferenceManager;
import com.tssap.dtr.client.eclipse.ui.conflict.ParameterHandler;
import com.tssap.dtr.client.eclipse.util.RemoteFileVersionInputStream;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;

public class ExternalAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$conflict$ExternalAction == null ? (class$com$tssap$dtr$client$eclipse$ui$conflict$ExternalAction = ExternalAction.class$("com.tssap.dtr.client.eclipse.ui.conflict.ExternalAction")) : class$com$tssap$dtr$client$eclipse$ui$conflict$ExternalAction));
    private static String TMP_DIR = ".dtr" + File.separatorChar + "tmp";
    private Shell myShell;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$conflict$ExternalAction;

    public ExternalAction(Shell shell) {
        Assert.isNotNull((Object)shell);
        this.myShell = shell;
    }

    public int executeMerge(Object collision, File baseVersion, File activeVersion, File collidingVersion, File mergedVersion, boolean wait) {
        try {
            DtrPreferenceManager manager = BluebirdPlugin.getDefault().getPreferenceManager();
            String mergeCMD = manager.getExternalMergeCommand();
            String encodedParam = ParameterHandler.getParametersModification(manager.getExternalMergeParametersType(), manager.getExternalMergeParameters(), collision);
            String mergeParam = encodedParam != null && !encodedParam.equals("") ? this.decodeParameters(encodedParam, baseVersion, activeVersion, collidingVersion, mergedVersion) : this.decodeParameters("%1 %2 %4", baseVersion, activeVersion, collidingVersion, mergedVersion);
            return this.runExternalTool(mergeCMD, mergeParam, wait);
        }
        catch (IllegalArgumentException e) {
            Logbook.getErrorChapter().println("Error during decoding parameters: " + e.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return -1;
        }
    }

    public int executeDiff(File left, File right, boolean wait) {
        try {
            DtrPreferenceManager manager = BluebirdPlugin.getDefault().getPreferenceManager();
            String diffCMD = manager.getExternalDiffCommand();
            String diffParam = this.decodeParameters("%1 %2", left, right, null, null);
            return this.runExternalTool(diffCMD, diffParam, wait);
        }
        catch (IllegalArgumentException e) {
            Logbook.getErrorChapter().println("Error during decoding parameters: " + e.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return -1;
        }
    }

    protected String decodeParameters(String paramEncoded, File param1, File param2, File param3, File param4) throws IllegalArgumentException {
        StringBuffer out = new StringBuffer();
        int paramIndex = paramEncoded.indexOf(37);
        while (paramIndex >= 0) {
            out.setLength(0);
            out.append(paramEncoded.substring(0, paramIndex));
            out.append("\"");
            int par = Integer.parseInt(new String(new char[]{paramEncoded.charAt(paramIndex + 1)}));
            switch (par) {
                case 1: {
                    if (param1 == null) {
                        throw new IllegalArgumentException("Parameter %1 is null");
                    }
                    out.append(param1.toString());
                    break;
                }
                case 2: {
                    if (param2 == null) {
                        throw new IllegalArgumentException("Parameter %2 is null");
                    }
                    out.append(param2.toString());
                    break;
                }
                case 3: {
                    if (param3 == null) {
                        throw new IllegalArgumentException("Parameter %3 is null");
                    }
                    out.append(param3.toString());
                    break;
                }
                case 4: {
                    if (param4 == null) {
                        throw new IllegalArgumentException("Parameter %4 is null");
                    }
                    out.append(param4.toString());
                }
            }
            out.append("\"");
            out.append(paramEncoded.substring(paramIndex + 2, paramEncoded.length()));
            paramEncoded = out.toString();
            paramIndex = paramEncoded.indexOf(37);
        }
        return out.toString();
    }

    public static File createTmpFile(IVfsVersion ver, String prefix) {
        try {
            File tempFile = File.createTempFile("_" + prefix, ver.getDisplayName());
            tempFile.deleteOnExit();
            InputStream is = RemoteFileVersionInputStream.getInputStream(ver);
            ExternalAction.createFile(is, tempFile);
            return tempFile;
        }
        catch (IOException ex) {
            Logbook.getErrorChapter().println("Creating local file failed: " + ex.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)ex);
            return null;
        }
    }

    public static File createTmpFile(IVfsFile file, String prefix) {
        try {
            File tempFile = File.createTempFile("_" + prefix, file.getName());
            tempFile.deleteOnExit();
            InputStream is = file.getContent();
            ExternalAction.createFile(is, tempFile);
            return tempFile;
        }
        catch (VfsException e) {
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            return null;
        }
        catch (IOException ex) {
            Logbook.getErrorChapter().println("Creating local file failed: " + ex.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)ex);
            return null;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private static void createFile(InputStream inputStream, File file) {
        block19: {
            int bytesRead;
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) >= 0) {
                void var3_5;
                fileOutputStream.write(buffer, 0, (int)var3_5);
            }
            Object var6_7 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block19;
            }
            catch (IOException x) {
                Logbook.getErrorChapter().println("IO excepion: " + x.getMessage());
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
            break block19;
            {
                catch (FileNotFoundException e) {
                    Logbook.getErrorChapter().println("File " + file.toString() + " does not exist.");
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                    Object var6_8 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block19;
                    }
                    catch (IOException x) {
                        Logbook.getErrorChapter().println("IO excepion: " + x.getMessage());
                        LogUtil.logException((Location)LOCATION, (Throwable)x);
                    }
                    break block19;
                }
                catch (IOException ex) {
                    Logbook.getErrorChapter().println("IO excepion: " + ex.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)ex);
                    Object var6_9 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        break block19;
                    }
                    catch (IOException x) {
                        Logbook.getErrorChapter().println("IO excepion: " + x.getMessage());
                        LogUtil.logException((Location)LOCATION, (Throwable)x);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException x) {
                    Logbook.getErrorChapter().println("IO excepion: " + x.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)x);
                }
                throw throwable;
            }
        }
    }

    protected void refreshResource(File file) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(file.toString());
        try {
            root.getFile((IPath)path).refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Logbook.getErrorChapter().println(e.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    protected Shell getShell() {
        return this.myShell;
    }

    protected int runExternalTool(String cmd, String param, boolean wait) {
        if (cmd.equals("") || param.equals("")) {
            MessageDialog dialog = new MessageDialog(this.getShell(), "External Diff/Merge command/parameters not specified.", null, "Specify Diff/Merge command/parameters in preference page.\nYou can find it via: Window -> Preferences -> Team -> DTR Preferences", 1, new String[]{"OK"}, 0);
            dialog.create();
            dialog.open();
            return -1;
        }
        try {
            Process process = Runtime.getRuntime().exec(cmd + " " + param);
            InputStreamConsumer error = new InputStreamConsumer(process.getErrorStream());
            InputStreamConsumer stdout = new InputStreamConsumer(process.getInputStream());
            error.runConsumer();
            stdout.runConsumer();
            if (wait) {
                try {
                    int exitValue = process.waitFor();
                    return exitValue;
                }
                catch (InterruptedException e) {
                    Logbook.getErrorChapter().println("Problem occurred during external merge command: " + e.getMessage());
                    LogUtil.logException((Location)LOCATION, (Throwable)e);
                    return -1;
                }
            }
        }
        catch (IOException e) {
            Logbook.getErrorChapter().println("Problem occurred during external merge command: " + e.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)e);
            return -1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class InputStreamConsumer {
        private InputStream fInputStream;

        InputStreamConsumer(InputStream stream) {
            this.fInputStream = stream;
        }

        public void runConsumer() {
            if (this.fInputStream == null) {
                return;
            }
            Thread consumerThread = new Thread(this){
                private final /* synthetic */ InputStreamConsumer this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    try {
                        while (InputStreamConsumer.access$000(this.this$1).read() != -1) {
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            consumerThread.start();
        }

        static /* synthetic */ InputStream access$000(InputStreamConsumer x0) {
            return x0.fInputStream;
        }
    }
}

