/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.conflict;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.conflict.ConflictUtility;
import com.tssap.dtr.client.eclipse.ui.conflict.DAVTextMergeViewer;
import com.tssap.dtr.client.eclipse.ui.conflict.ExternalAction;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DiffEditorInput
extends CompareEditorInput {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$conflict$DiffEditorInput == null ? (class$com$tssap$dtr$client$eclipse$ui$conflict$DiffEditorInput = DiffEditorInput.class$("com.tssap.dtr.client.eclipse.ui.conflict.DiffEditorInput")) : class$com$tssap$dtr$client$eclipse$ui$conflict$DiffEditorInput));
    private List myListenerList = new ArrayList();
    private File myFile;
    private IVfsVersion[] myVersions;
    private IVfsVersion myAncestor;
    private boolean myEditable;
    private Boolean myDirty;
    private Image myFolderImage = BluebirdPlugin.getDefault().createImageDescriptor("file.gif").createImage();
    public static final String ACCEPT_ENABLED_PROPERTY = "Accept enabled";
    private IPropertyChangeListener myDirtyListener;
    private DiffTreeViewer myDiffViewer;
    private Object myRoot;
    private Viewer myContentViewer;
    private boolean fContentSaved = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$conflict$DiffEditorInput;

    public DiffEditorInput(File file, IVfsVersion[] versions, IVfsVersion ancestor, boolean writable) {
        super(new CompareConfiguration());
        this.getCompareConfiguration().setLeftEditable(true);
        this.getCompareConfiguration().setRightEditable(true);
        this.getCompareConfiguration().setProperty("org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (Object)Boolean.FALSE);
        this.myFile = file;
        this.myAncestor = ancestor;
        this.setTitle(this.myFile.getName());
        this.myVersions = versions;
        this.myEditable = writable;
        this.myDirtyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getProperty();
                if ("DIRTY_STATE".equals(propertyName)) {
                    boolean changed = false;
                    Object newValue = e.getNewValue();
                    if (newValue instanceof Boolean) {
                        changed = (Boolean)newValue;
                    }
                    DiffEditorInput.this.setDirtyState(e.getSource(), changed);
                }
            }
        };
    }

    public File getLocalFile() {
        return this.myFile;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.myRoot != null) {
            return this.myRoot;
        }
        monitor.beginTask("Preparing resources for diff operation...", -1);
        if (this.getCompareConfiguration().getLeftLabel(null) == null || this.getCompareConfiguration().getLeftLabel(null).length() == 0) {
            this.getCompareConfiguration().setLeftLabel("Conflicting Version (local)");
            this.getCompareConfiguration().setRightLabel("Active Version (remote) #" + String.valueOf(this.myVersions[0].getBranchSequenceNumber()));
        }
        Differencer d = new Differencer(){

            protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                return new MyDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
            }
        };
        IVfsVersion version = this.myVersions[0];
        FileResourceNode versionStructure = (FileResourceNode)this.getStructure(version, "right");
        IStructureComparator ancestorStructure = version.equals(this.myAncestor) ? this.getStructure(versionStructure.myFile, "ancestor") : this.getStructure(this.myAncestor, "ancestor");
        this.myRoot = d.findDifferences(this.myAncestor != null, monitor, null, (Object)ancestorStructure, (Object)this.getStructure(this.myFile, "left"), (Object)versionStructure);
        monitor.done();
        return this.myRoot;
    }

    public Viewer createDiffViewer(Composite parent) {
        Viewer v = super.createDiffViewer(parent);
        if (v instanceof DiffTreeViewer) {
            this.myDiffViewer = (DiffTreeViewer)v;
        }
        return v;
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        String type = ConflictUtility.guessType(input.getLeft());
        boolean text = "txt".equals(type);
        if (!text) {
            this.myContentViewer = super.findContentViewer(oldViewer, input, parent);
        } else if (this.myContentViewer == null || !(oldViewer instanceof DAVTextMergeViewer)) {
            this.myContentViewer = new DAVTextMergeViewer(parent, 0, this.getCompareConfiguration());
            Control c = this.myContentViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (DiffEditorInput.this.myContentViewer instanceof DAVTextMergeViewer) {
                        ((DAVTextMergeViewer)DiffEditorInput.this.myContentViewer).disposeResources();
                    }
                }
            });
        }
        if (this.myContentViewer instanceof IPropertyChangeNotifier) {
            final IPropertyChangeNotifier dsp = (IPropertyChangeNotifier)this.myContentViewer;
            dsp.addPropertyChangeListener(this.myDirtyListener);
            Control c = this.myContentViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (DiffEditorInput.this.myContentViewer instanceof DAVTextMergeViewer) {
                        dsp.removePropertyChangeListener(DiffEditorInput.this.myDirtyListener);
                    }
                }
            });
        }
        return this.myContentViewer;
    }

    public Viewer getCurrentContentViewer() {
        return this.myContentViewer;
    }

    protected void setDirtyState(Object source, boolean dirty) {
        Boolean oldDirty = this.myDirty;
        this.myDirty = new Boolean(dirty);
        this.setDirty(dirty);
        this.firePropertyChange(source, oldDirty, this.myDirty);
    }

    protected void firePropertyChange(Object source, Boolean oldState, Boolean newState) {
        Iterator i = this.myListenerList.iterator();
        while (i.hasNext()) {
            IPropertyChangeListener listener = (IPropertyChangeListener)i.next();
            listener.propertyChange(new PropertyChangeEvent(source, "DIRTY_STATE", (Object)oldState, (Object)newState));
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.myListenerList.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.myListenerList.remove(listener);
    }

    private IStructureComparator getStructure(Object input, String prefix) {
        File file = null;
        if (input instanceof IVfsVersion) {
            file = ExternalAction.createTmpFile((IVfsVersion)input, prefix);
        } else if (input instanceof IVfsFile) {
            file = ExternalAction.createTmpFile((IVfsFile)input, prefix);
        } else {
            if (input instanceof IContainer) {
                return new ResourceNode((IResource)((IContainer)input));
            }
            if (input instanceof File) {
                file = (File)input;
            }
        }
        if (input == null || file == null) {
            return null;
        }
        FileResourceNode resourceNode = new FileResourceNode(file);
        resourceNode.addContentChangeListener(new IContentChangeListener(){

            public void contentChanged(IContentChangeNotifier source) {
                if (source instanceof FileResourceNode) {
                    try {
                        ((FileResourceNode)source).commit((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Logbook.getErrorChapter().println("File save operation failed for file " + ((FileResourceNode)source).getResource().getName() + ".");
                        LogUtil.logException((Location)LOCATION, (Throwable)e);
                    }
                }
            }
        });
        return resourceNode;
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.myRoot instanceof DiffNode) {
            block4: {
                try {
                    DiffEditorInput.commit(pm, (DiffNode)this.myRoot);
                    Object var3_2 = null;
                    if (this.myDiffViewer == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.myDiffViewer != null) {
                        this.myDiffViewer.refresh();
                    }
                    this.setDirty(false);
                    this.fContentSaved = true;
                    throw throwable;
                }
                this.myDiffViewer.refresh();
            }
            this.setDirty(false);
            this.fContentSaved = true;
            {
            }
        }
    }

    public boolean isContentChanged() {
        return this.fContentSaved;
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left;
        if (node instanceof MyDiffNode) {
            ((MyDiffNode)node).clearDirty();
        }
        if ((left = node.getLeft()) instanceof FileResourceNode) {
            ((FileResourceNode)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof FileResourceNode) {
            ((FileResourceNode)right).commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                IDiffElement element = children[i];
                if (element instanceof DiffNode) {
                    DiffEditorInput.commit(pm, (DiffNode)element);
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyDiffNode
    extends DiffNode {
        private boolean fDirty = false;
        private ITypedElement fLastId;
        private String fLastName;

        public MyDiffNode(IDiffContainer parent, int description, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, description, ancestor, left, right);
        }

        public void fireChange() {
            super.fireChange();
            DiffEditorInput.this.setDirty(true);
            this.fDirty = true;
            if (DiffEditorInput.this.myDiffViewer != null) {
                DiffEditorInput.this.myDiffViewer.refresh((Object)this);
            }
        }

        void clearDirty() {
            this.fDirty = false;
        }

        public String getName() {
            if (this.fLastName == null) {
                this.fLastName = super.getName();
            }
            if (this.fDirty) {
                return '<' + this.fLastName + '>';
            }
            return this.fLastName;
        }

        public ITypedElement getId() {
            ITypedElement id = super.getId();
            if (id == null) {
                return this.fLastId;
            }
            this.fLastId = id;
            return id;
        }
    }

    static class FileResourceNode
    extends ResourceNode {
        File myFile;
        private boolean fDirty = false;

        public FileResourceNode(File file) {
            super((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(file.getAbsolutePath())));
            this.myFile = file;
        }

        protected InputStream createStream() throws CoreException {
            try {
                return new FileInputStream(this.myFile);
            }
            catch (FileNotFoundException e) {
                Logbook.getErrorChapter().println("File " + this.myFile + " not found!");
                LogUtil.logException((Location)LOCATION, (Throwable)e);
                return null;
            }
        }

        public void setContent(byte[] contents) {
            this.fDirty = true;
            super.setContent(contents);
        }

        public void commit(IProgressMonitor pm) throws CoreException {
            if (this.fDirty) {
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    os.write(this.getContent());
                    os.writeTo(new FileOutputStream(this.myFile));
                    IResource res = BluebirdPlugin.getResource(this.myFile);
                    if (res != null) {
                        res.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.tssap.dtr.client.eclipse", 4, "IOException occured during saving changes to file.", (Throwable)e));
                }
            }
        }
    }
}

