/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.conflict;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.conflict.DAVUndoManager;
import com.tssap.dtr.client.eclipse.ui.conflict.IEscListener;
import com.tssap.dtr.client.eclipse.ui.conflict.Messages;
import com.tssap.dtr.client.eclipse.ui.util.ImageDescriptorSingletone;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.FindReplaceAction;

public class DAVTextMergeViewer
extends TextMergeViewer {
    private int count = 0;
    private DAVUndoManager myUndoManager;
    private Composite myParentComposite;
    private Color myGrayColorAncestor;
    private Color myGrayColorLeft;
    private Color myGrayColorRight;
    private Action myUndoAction;
    private Action myRedoAction;
    private ImageDescriptorSingletone myEnabledUndoImage = new ImageDescriptorSingletone("undo_edit.gif");
    private ImageDescriptorSingletone myDisabledUndoImage = new ImageDescriptorSingletone("undo_edit_gray.gif");
    private ImageDescriptorSingletone myEnabledRedoImage = new ImageDescriptorSingletone("redo_edit.gif");
    private ImageDescriptorSingletone myDisabledRedoImage = new ImageDescriptorSingletone("redo_edit_gray.gif");
    private IAction fEnableAncestor;
    private IAction fIgnoreAncestor;
    private IAction fCopyAllFromRight;
    private IAction fCopyCurrentDiff;
    private IAction fNext;
    private IAction fPrevious;
    private IAction fAncestorFind;
    private IAction fRightFind;
    private IAction fLeftFind;
    private IAction fAncestorGotoLine;
    private IAction fRightGotoLine;
    private IAction fLeftGotoLine;
    private boolean fColorized;
    private TextViewer fAncestor;
    private TextViewer fLeft;
    private TextViewer fRight;
    private List fEscListeners = new ArrayList(5);
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$conflict$DAVTextMergeViewer == null ? (class$com$tssap$dtr$client$eclipse$ui$conflict$DAVTextMergeViewer = DAVTextMergeViewer.class$("com.tssap.dtr.client.eclipse.ui.conflict.DAVTextMergeViewer")) : class$com$tssap$dtr$client$eclipse$ui$conflict$DAVTextMergeViewer));
    static /* synthetic */ Class class$org$eclipse$compare$contentmergeviewer$TextMergeViewer;
    static /* synthetic */ Class class$org$eclipse$ui$texteditor$ITextEditor;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$conflict$DAVTextMergeViewer;

    public DAVTextMergeViewer(Composite parent, int styles, CompareConfiguration mp) {
        super(parent, styles, mp);
        this.myParentComposite = parent;
        ToolBarManager manager = CompareViewerPane.getToolBarManager((Composite)parent);
        if (manager != null) {
            this.contributeActionsToToolBar(manager);
        }
        this.setViewersFont();
    }

    public void setFocus() {
        this.fLeft.getTextWidget().setFocus();
    }

    private void setViewersFont() {
        Font compareFont = null;
        compareFont = this.fColorized ? JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont") : JFaceResources.getFont((String)(class$org$eclipse$compare$contentmergeviewer$TextMergeViewer == null ? (class$org$eclipse$compare$contentmergeviewer$TextMergeViewer = DAVTextMergeViewer.class$("org.eclipse.compare.contentmergeviewer.TextMergeViewer")) : class$org$eclipse$compare$contentmergeviewer$TextMergeViewer).getName());
        if (this.fAncestor != null) {
            this.fAncestor.getTextWidget().setFont(compareFont);
        }
        if (this.fLeft != null) {
            this.fLeft.getTextWidget().setFont(compareFont);
        }
        if (this.fRight != null) {
            this.fRight.getTextWidget().setFont(compareFont);
        }
    }

    protected void createControls(Composite composite) {
        this.setConfirmSave(true);
        super.createControls(composite);
        Object acceptProperty = this.getCompareConfiguration().getProperty("Accept enabled");
        if (acceptProperty instanceof Boolean) {
            this.setConfirmSave((Boolean)acceptProperty);
        }
    }

    private void contributeActionsToToolBar(ToolBarManager toolBarManager) {
        if (this.fAncestor != null) {
            this.fAncestorFind = new FindReplAction(this.fAncestor);
        }
        this.fRightFind = new FindReplAction(this.fRight);
        this.fLeftFind = new FindReplAction(this.fLeft);
        IContributionItem[] items = toolBarManager.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)items[i]).getAction();
                if (action.getText().equalsIgnoreCase("Enable Ancestor Pane")) {
                    this.fEnableAncestor = action;
                } else if (action.getText().equalsIgnoreCase("Ignore Ancestor")) {
                    this.fIgnoreAncestor = action;
                } else if (action.getText().equalsIgnoreCase("Copy Right to Left")) {
                    this.fCopyAllFromRight = action;
                } else if (action.getText().equalsIgnoreCase("Copy Current Diff")) {
                    this.fCopyCurrentDiff = action;
                } else if (action.getText().equalsIgnoreCase("Next")) {
                    action.setToolTipText(action.getToolTipText() + " - F8");
                    this.fNext = action;
                } else if (action.getText().equalsIgnoreCase("Previous")) {
                    action.setToolTipText(action.getToolTipText() + "-  F7");
                    this.fPrevious = action;
                }
            }
            ++i;
        }
        if (this.getCompareConfiguration().isLeftEditable() || this.getCompareConfiguration().isRightEditable()) {
            this.myUndoAction = new Action(){

                public String getText() {
                    return Messages.getString("DAVTextMergeViewer.Action.Undo.label");
                }

                public String getToolTipText() {
                    return Messages.getString("DAVTextMergeViewer.Action.Undo.toolTip");
                }

                public void run() {
                    DAVTextMergeViewer.this.getCustomUndoManager().undo();
                }
            };
            this.myRedoAction = new Action(){

                public String getText() {
                    return Messages.getString("DAVTextMergeViewer.Action.Redo.label");
                }

                public String getToolTipText() {
                    return Messages.getString("DAVTextMergeViewer.Action.Redo.toolTip");
                }

                public void run() {
                    DAVTextMergeViewer.this.getCustomUndoManager().redo();
                }
            };
            this.myUndoAction.setEnabled(this.getCustomUndoManager().undoable());
            this.myUndoAction.setImageDescriptor(this.myDisabledUndoImage.getImageDescriptor());
            this.myUndoAction.setHoverImageDescriptor(this.myDisabledUndoImage.getImageDescriptor());
            toolBarManager.add((IAction)this.myUndoAction);
            this.myRedoAction.setEnabled(this.getCustomUndoManager().redoable());
            this.myRedoAction.setImageDescriptor(this.myDisabledRedoImage.getImageDescriptor());
            this.myRedoAction.setHoverImageDescriptor(this.myDisabledRedoImage.getImageDescriptor());
            toolBarManager.add((IAction)this.myRedoAction);
        }
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof SourceViewer) {
            try {
                this.tryJavaColorization(textViewer);
                this.fColorized = true;
            }
            catch (Throwable e) {
                this.fColorized = false;
                LogUtil.logException((Location)Location.getLocation((Object)((Object)this)), (Throwable)e);
            }
        }
        switch (this.count) {
            case 0: {
                this.fAncestor = textViewer;
                this.fAncestorGotoLine = new GotoLineAction(textViewer);
                textViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.stateMask == 262144 && e.character == '\u0006' && DAVTextMergeViewer.this.fAncestorFind != null) {
                            DAVTextMergeViewer.this.fAncestorFind.run();
                        }
                        if (e.stateMask == 262144 && e.character == '\f') {
                            DAVTextMergeViewer.this.fAncestorGotoLine.run();
                        }
                        if (e.keyCode == 0x1000011) {
                            DAVTextMergeViewer.this.fNext.run();
                        }
                        if (e.keyCode == 0x1000010) {
                            DAVTextMergeViewer.this.fPrevious.run();
                        }
                        if (e.keyCode == 27) {
                            DAVTextMergeViewer.this.fireEscKeyEvent();
                        }
                    }
                });
                this.myGrayColorAncestor = new Color(null, 231, 232, 217);
                textViewer.getTextWidget().setBackground(this.myGrayColorAncestor);
                break;
            }
            case 1: {
                this.fLeft = textViewer;
                this.fLeftGotoLine = new GotoLineAction(textViewer);
                if (!this.getCompareConfiguration().isLeftEditable()) {
                    this.myGrayColorLeft = new Color(null, 231, 232, 217);
                    textViewer.getTextWidget().setBackground(this.myGrayColorLeft);
                } else {
                    textViewer.setUndoManager(this.getCustomUndoManager());
                    this.getCustomUndoManager().connect((ITextViewer)textViewer);
                    textViewer.addTextListener(new ITextListener(){

                        public void textChanged(TextEvent event) {
                            if (event != null) {
                                DAVTextMergeViewer.this.updateToolbarActions();
                            }
                        }
                    });
                }
                textViewer.addTextInputListener(new ITextInputListener(){

                    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                        DAVTextMergeViewer.this.updateToolbarActions();
                    }

                    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                    }
                });
                textViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.stateMask == 262144 && e.character == '\u001a' && DAVTextMergeViewer.this.getCustomUndoManager().undoable()) {
                            DAVTextMergeViewer.this.getCustomUndoManager().undo();
                        }
                        if (e.stateMask == 262144 && e.character == '\u0019' && DAVTextMergeViewer.this.getCustomUndoManager().redoable()) {
                            DAVTextMergeViewer.this.getCustomUndoManager().redo();
                        }
                        if (e.stateMask == 262144 && e.character == '\u0006') {
                            DAVTextMergeViewer.this.fLeftFind.run();
                        }
                        if (e.stateMask == 262144 && e.character == '\f') {
                            DAVTextMergeViewer.this.fLeftGotoLine.run();
                        }
                        if (e.keyCode == 0x1000011) {
                            DAVTextMergeViewer.this.fNext.run();
                        }
                        if (e.keyCode == 0x1000010) {
                            DAVTextMergeViewer.this.fPrevious.run();
                        }
                        if (e.keyCode == 27) {
                            DAVTextMergeViewer.this.fireEscKeyEvent();
                        }
                    }
                });
                break;
            }
            case 2: {
                this.fRight = textViewer;
                this.fRightGotoLine = new GotoLineAction(textViewer);
                textViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.stateMask == 262144 && e.character == '\u0006') {
                            DAVTextMergeViewer.this.fRightFind.run();
                        }
                        if (e.stateMask == 262144 && e.character == '\f') {
                            DAVTextMergeViewer.this.fRightGotoLine.run();
                        }
                        if (e.keyCode == 0x1000011) {
                            DAVTextMergeViewer.this.fNext.run();
                        }
                        if (e.keyCode == 0x1000010) {
                            DAVTextMergeViewer.this.fPrevious.run();
                        }
                        if (e.keyCode == 27) {
                            DAVTextMergeViewer.this.fireEscKeyEvent();
                        }
                    }
                });
                if (this.getCompareConfiguration().isRightEditable()) break;
                this.myGrayColorRight = new Color(null, 231, 232, 217);
                textViewer.getTextWidget().setBackground(this.myGrayColorRight);
                break;
            }
            default: {
                this.count = 0;
            }
        }
        ++this.count;
    }

    private void tryJavaColorization(TextViewer textViewer) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String JAVA_PLUGIN_CLASSNAME = "org.eclipse.jdt.internal.ui.JavaPlugin";
        String JAVA_TEXTTOOLS_CLASSNAME = "org.eclipse.jdt.ui.text.JavaTextTools";
        String JAVA_SOURCEVIEWERCONFIGURATION_CLASSNAME = "org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration";
        String IPREFERENCESTORE_CLASSNAME = "org.eclipse.jface.preference.IPreferenceStore";
        Class<?> javaPluginClass = Class.forName(JAVA_PLUGIN_CLASSNAME);
        Method getDefault = javaPluginClass.getMethod("getDefault", null);
        Method getPreferenceStore = javaPluginClass.getMethod("getPreferenceStore", null);
        Object defaultJavaPlugin = getDefault.invoke(null, new Object[0]);
        Object preferenceStore = getPreferenceStore.invoke(defaultJavaPlugin, new Object[0]);
        Class<?> javaTextToolsClass = Class.forName(JAVA_TEXTTOOLS_CLASSNAME);
        Class<?> preferenceStoreClass = Class.forName(IPREFERENCESTORE_CLASSNAME);
        Constructor<?> textToolsConstructor = javaTextToolsClass.getConstructor(preferenceStoreClass);
        Object textTools = textToolsConstructor.newInstance(preferenceStore);
        Class<?> javaSourceViewerConfigurationClass = Class.forName(JAVA_SOURCEVIEWERCONFIGURATION_CLASSNAME);
        Constructor<?> sourceViewerConstructor = javaSourceViewerConfigurationClass.getConstructor(javaTextToolsClass, class$org$eclipse$ui$texteditor$ITextEditor == null ? (class$org$eclipse$ui$texteditor$ITextEditor = DAVTextMergeViewer.class$("org.eclipse.ui.texteditor.ITextEditor")) : class$org$eclipse$ui$texteditor$ITextEditor);
        Object sourceViewer = sourceViewerConstructor.newInstance(textTools, null);
        ((SourceViewer)textViewer).configure((SourceViewerConfiguration)sourceViewer);
    }

    public IUndoManager getCustomUndoManager() {
        if (this.myUndoManager == null) {
            this.myUndoManager = new DAVUndoManager(25);
        }
        return this.myUndoManager;
    }

    private void updateToolbarActions() {
        if (this.myUndoAction != null) {
            this.myUndoAction.setEnabled(this.getCustomUndoManager().undoable());
            this.myUndoAction.setHoverImageDescriptor(this.getCustomUndoManager().undoable() ? this.myEnabledUndoImage.getImageDescriptor() : this.myDisabledUndoImage.getImageDescriptor());
        }
        if (this.myRedoAction != null) {
            this.myRedoAction.setEnabled(this.getCustomUndoManager().redoable());
            this.myRedoAction.setHoverImageDescriptor(this.getCustomUndoManager().redoable() ? this.myEnabledRedoImage.getImageDescriptor() : this.myDisabledRedoImage.getImageDescriptor());
        }
    }

    public void disposeResources() {
        if (this.myGrayColorAncestor != null) {
            this.myGrayColorAncestor.dispose();
        }
        if (this.myGrayColorLeft != null) {
            this.myGrayColorLeft.dispose();
        }
        if (this.myGrayColorRight != null) {
            this.myGrayColorRight.dispose();
        }
    }

    public void addEscKeyListener(IEscListener listener) {
        this.fEscListeners.add(listener);
    }

    public void removeEscKeyListener(IEscListener listener) {
        this.fEscListeners.remove(listener);
    }

    protected void fireEscKeyEvent() {
        Iterator iter = this.fEscListeners.iterator();
        while (iter.hasNext()) {
            IEscListener listener = (IEscListener)iter.next();
            listener.escKeyPressed();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class GotoLineDialog
    extends InputDialog {
        public GotoLineDialog(Shell parent, String title, String message, String initialValue, IInputValidator validator) {
            super(parent, title, message, initialValue, validator);
        }

        protected Control createDialogArea(Composite parent) {
            Control result = super.createDialogArea(parent);
            this.getText().setFocus();
            Dialog.applyDialogFont((Control)result);
            return result;
        }
    }

    class GotoLineAction
    extends Action {
        private TextViewer fViewer;
        private int fLastLine;

        public GotoLineAction(TextViewer viewer) {
            this.fViewer = viewer;
        }

        public void run() {
            try {
                IDocument doc = this.fViewer.getDocument();
                this.fLastLine = doc.getLineOfOffset(doc.getLength()) + 1;
                GotoLineDialog dialog = new GotoLineDialog(DAVTextMergeViewer.this.getControl().getShell(), Messages.getString("DAVTextMergeViewer.Dialog.GotoLine.title"), Messages.getString("DAVTextMergeViewer.Dialog.GotoLine.message") + this.fLastLine + ")", "", new NumberValidator());
                if (dialog.open() == 0) {
                    int line = Integer.parseInt(dialog.getValue()) - 1;
                    this.fViewer.setSelectedRange(doc.getLineOffset(line), doc.getLineLength(line) == 0 ? 0 : doc.getLineLength(line) - 1);
                }
            }
            catch (BadLocationException e) {
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }

        class NumberValidator
        implements IInputValidator {
            NumberValidator() {
            }

            public String isValid(String input) {
                if (input == null || input.length() == 0) {
                    return " ";
                }
                try {
                    int i = Integer.parseInt(input);
                    if (i <= 0 || GotoLineAction.this.fLastLine < i) {
                        return Messages.getString("DAVTextMergeViewer.Validator.error.range");
                    }
                }
                catch (NumberFormatException x) {
                    return Messages.getString("DAVTextMergeViewer.Validator.error.format");
                }
                return null;
            }
        }
    }

    class FakeWorkbenchPartSite
    implements IWorkbenchPartSite {
        FakeWorkbenchPartSite() {
        }

        public String getId() {
            return null;
        }

        public String getPluginId() {
            return null;
        }

        public String getRegisteredName() {
            return null;
        }

        public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
        }

        public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
        }

        public IKeyBindingService getKeyBindingService() {
            return null;
        }

        public IWorkbenchPage getPage() {
            return null;
        }

        public ISelectionProvider getSelectionProvider() {
            return null;
        }

        public Shell getShell() {
            return DAVTextMergeViewer.this.getControl().getShell();
        }

        public IWorkbenchWindow getWorkbenchWindow() {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }

        public void setSelectionProvider(ISelectionProvider provider) {
        }
    }

    class FakeWorkbenchPart
    implements IWorkbenchPart {
        private IWorkbenchPartSite fSite;
        private TextViewer fViewer;
        static /* synthetic */ Class class$org$eclipse$jface$text$IFindReplaceTarget;

        public FakeWorkbenchPart(TextViewer viewer) {
            this.fSite = new FakeWorkbenchPartSite();
            this.fViewer = viewer;
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public void createPartControl(Composite parent) {
        }

        public void dispose() {
        }

        public IWorkbenchPartSite getSite() {
            return this.fSite;
        }

        public String getTitle() {
            return null;
        }

        public Image getTitleImage() {
            return null;
        }

        public String getTitleToolTip() {
            return null;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setFocus() {
        }

        public Object getAdapter(Class adapter) {
            if ((class$org$eclipse$jface$text$IFindReplaceTarget == null ? (class$org$eclipse$jface$text$IFindReplaceTarget = FakeWorkbenchPart.class$("org.eclipse.jface.text.IFindReplaceTarget")) : class$org$eclipse$jface$text$IFindReplaceTarget).equals(adapter)) {
                return this.fViewer.getFindReplaceTarget();
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    class FindReplAction
    extends Action {
        private TextViewer fTextViewer;

        public FindReplAction(TextViewer viewer) {
            this.fTextViewer = viewer;
        }

        public String getText() {
            return Messages.getString("DAVTextMergeViewer.Action.FindReplace.label");
        }

        public void run() {
            FindReplaceAction act = new FindReplaceAction(Messages.getResourceBundle(), "Editor.FindReplace", (IWorkbenchPart)new FakeWorkbenchPart(this.fTextViewer));
            act.run();
        }
    }
}

