/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.conflict;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.conflict.DAVTextMergeViewer;
import com.tssap.dtr.client.eclipse.ui.conflict.DiffEditorInput;
import com.tssap.dtr.client.eclipse.ui.conflict.IEscListener;
import com.tssap.dtr.client.eclipse.ui.conflict.Messages;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.ui.util.ResizableTitleDialog;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DAVCompareDialog
extends ResizableTitleDialog
implements IPropertyChangeListener {
    private static final String DIFF_DIALOG_LOCATION = "com.tssap.dtr.client.eclipse_diffDialogLocation";
    private static final String DIFF_DIALOG_SIZE = "com.tssap.dtr.client.eclipse_diffDialogSize";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$conflict$DAVCompareDialog == null ? (class$com$tssap$dtr$client$eclipse$ui$conflict$DAVCompareDialog = DAVCompareDialog.class$("com.tssap.dtr.client.eclipse.ui.conflict.DAVCompareDialog")) : class$com$tssap$dtr$client$eclipse$ui$conflict$DAVCompareDialog));
    private CompareEditorInput fCompareEditorInput;
    private Button fCommitButton;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$conflict$DAVCompareDialog;

    public DAVCompareDialog(Shell shell, CompareEditorInput input) {
        super(shell, "", null);
        Assert.isNotNull((Object)input);
        this.fCompareEditorInput = input;
        this.fCompareEditorInput.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public boolean close() {
        this.persistShellGeometry();
        if (super.close()) {
            if (this.fCompareEditorInput != null) {
                this.fCompareEditorInput.removePropertyChangeListener((IPropertyChangeListener)this);
            }
            return true;
        }
        return false;
    }

    protected void handleShellCloseEvent() {
        this.setReturnCode(1);
        Object acceptEnabled = this.fCompareEditorInput.getCompareConfiguration().getProperty("Accept enabled");
        if (acceptEnabled == null || !(acceptEnabled instanceof Boolean)) {
            this.close();
            return;
        }
        if (((Boolean)acceptEnabled).booleanValue() && this.fCompareEditorInput.isSaveNeeded()) {
            MessageDialog dialog = new MessageDialog(this.getShell(), "Save Resource", null, "The content in your local file has been changed.\n\nDo you want to save the changes ?", 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            int returnCode = dialog.open();
            switch (returnCode) {
                case 0: {
                    this.saveChanges();
                    this.setReturnCode(0);
                    break;
                }
                case 1: {
                    this.setReturnCode(1);
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fCommitButton = this.createButton(parent, 0, Messages.getString("DAVCompareDialog.commitAction.label"), true);
        Object acceptProperty = this.fCompareEditorInput.getCompareConfiguration().getProperty("Accept enabled");
        if (acceptProperty != null && acceptProperty instanceof Boolean) {
            this.fCommitButton.setEnabled(((Boolean)acceptProperty).booleanValue());
        } else {
            this.fCommitButton.setEnabled(false);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object acceptButtonEnabled;
        if (this.fCommitButton != null && this.fCompareEditorInput != null && (acceptButtonEnabled = this.fCompareEditorInput.getCompareConfiguration().getProperty("Accept enabled")) instanceof Boolean) {
            this.fCommitButton.setEnabled(((Boolean)acceptButtonEnabled).booleanValue());
        }
    }

    protected Control createDialogArea(Composite parent) {
        DiffEditorInput input;
        Viewer v;
        Control c = this.fCompareEditorInput.createContents(parent);
        c.setLayoutData((Object)new GridData(1808));
        Shell shell = c.getShell();
        shell.setText(this.fCompareEditorInput.getTitle());
        shell.setImage(this.fCompareEditorInput.getTitleImage());
        if (this.fCompareEditorInput instanceof DiffEditorInput && (v = (input = (DiffEditorInput)this.fCompareEditorInput).getCurrentContentViewer()) instanceof DAVTextMergeViewer) {
            DAVTextMergeViewer viewer = (DAVTextMergeViewer)v;
            viewer.setFocus();
            viewer.addEscKeyListener(new IEscListener(){

                public void escKeyPressed() {
                    DAVCompareDialog.this.handleShellCloseEvent();
                }
            });
        }
        return c;
    }

    protected void saveChanges() {
        if (this.fCompareEditorInput.isSaveNeeded()) {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor pm) throws CoreException {
                    DAVCompareDialog.this.fCompareEditorInput.saveChanges(pm);
                }
            };
            Shell shell = this.getParentShell();
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            pmd.create();
            try {
                operation.run(pmd.getProgressMonitor());
            }
            catch (InterruptedException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
                this.showErrorSavingMessage(x);
            }
            catch (OperationCanceledException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
                this.showErrorSavingMessage(x);
            }
            catch (InvocationTargetException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
                this.showErrorSavingMessage(x);
            }
        }
    }

    protected void okPressed() {
        this.saveChanges();
        super.okPressed();
    }

    private void showErrorSavingMessage(Throwable exception) {
        String title = Messages.getString("DAVCompareDialog.saveErrorTitle");
        String msg = Messages.getString("DAVCompareDialog.saveErrorMessage");
        MessageDialog.openError((Shell)this.getParentShell(), (String)title, (String)(msg + exception.getMessage()));
    }

    protected void cancelPressed() {
        MessageDialog dialog;
        Object acceptEnabled = this.fCompareEditorInput.getCompareConfiguration().getProperty("Accept enabled");
        if (acceptEnabled == null || !(acceptEnabled instanceof Boolean)) {
            super.cancelPressed();
            return;
        }
        if (((Boolean)acceptEnabled).booleanValue() && this.fCompareEditorInput.isSaveNeeded() && (dialog = new MessageDialog(this.getShell(), "Confim Cancel", null, "There are unsaved changes.\n\nDo you want to save the changes?", 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() == 0) {
            this.saveChanges();
        }
        super.cancelPressed();
    }

    public int open() {
        try {
            ProgressMonitorDialog pmDialog = new ProgressMonitorDialog(this.getShell());
            pmDialog.open();
            this.fCompareEditorInput.run(pmDialog.getProgressMonitor());
            pmDialog.close();
        }
        catch (InvocationTargetException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        catch (InterruptedException ex) {
            LogUtil.logException((Location)LOCATION, (Throwable)ex);
        }
        int rc = super.open();
        return rc;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point locationPoint;
        String locationString = this.getPreferenceStore().getString(DIFF_DIALOG_LOCATION);
        if (locationString.length() > 0 && (locationPoint = LayoutHelper.parseCoordinates(locationString)) != null) {
            return locationPoint;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        Point sizePoint;
        String sizeString = this.getPreferenceStore().getString(DIFF_DIALOG_SIZE);
        if (sizeString.length() > 0 && (sizePoint = LayoutHelper.parseCoordinates(sizeString)) != null) {
            return sizePoint;
        }
        return super.getInitialSize();
    }

    private void persistShellGeometry() {
        Point shellLocation = this.getShell().getLocation();
        Point shellSize = this.getShell().getSize();
        String locationString = LayoutHelper.serializeCoords(shellLocation);
        String sizeString = LayoutHelper.serializeCoords(shellSize);
        this.getPreferenceStore().setValue(DIFF_DIALOG_LOCATION, locationString);
        this.getPreferenceStore().setValue(DIFF_DIALOG_SIZE, sizeString);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

