/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyConnectionTemplate;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyLogicalSystem;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationUtil;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationEditorException;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationWorkingCopyProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IConfigurationWorkingCopy;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class WorkingCopyLogicalSystem
extends AbstractWorkingCopyLogicalSystem {
    private ILogicalSystem m_logicalSystem;

    protected WorkingCopyLogicalSystem(ILogicalSystem logicalSystem) {
        this.m_logicalSystem = logicalSystem;
    }

    public Object getOriginal() {
        return this.m_logicalSystem;
    }

    public String getId() {
        return this.m_changes.containsKey("logical_system_name") ? (String)this.m_changes.get("logical_system_name") : this.m_logicalSystem.getName();
    }

    public IConfigurationWorkingCopy applyChanges() throws ConfigurationEditorException {
        if (this.getConnectionTemplates().length == 0) {
            throw new ConfigurationEditorException(this, "Unable to update logical system \"" + this.getId() + "\": No repository server specified.");
        }
        ILogicalSystem modifiedSystem = this.m_logicalSystem;
        if (this.neededNewInstance()) {
            modifiedSystem = this.createLogicalSystem(this.getId());
            Configuration.getConfiguration().removeLogicalSystem(this.m_logicalSystem);
            ConfigurationWorkingCopyProvider.getInstance().removeWorkingCopy(this.m_logicalSystem);
        }
        try {
            this.updateConnectionTemplates(modifiedSystem);
            return ConfigurationWorkingCopyProvider.getInstance().getWorkingCopy(modifiedSystem);
        }
        catch (ConfigurationException x) {
            throw new ConfigurationEditorException(this, x.getMessage());
        }
    }

    protected void rememberLastValue(String key) {
        if (key.equals("logical_system_name")) {
            this.m_lastValues.put("logical_system_name", this.m_logicalSystem.getName());
        } else if (key.equals("connection_templates")) {
            ArrayList<IConfigurationWorkingCopy> templateCopies = new ArrayList<IConfigurationWorkingCopy>();
            Iterator iter = this.m_logicalSystem.repositoryServers();
            while (iter.hasNext()) {
                IRepositoryServer server = (IRepositoryServer)iter.next();
                IConnectionTemplate template = ClientConfigurationUtil.getConnectionTemplate(server.getUrl());
                if (template == null) continue;
                templateCopies.add(ConfigurationWorkingCopyProvider.getInstance().getWorkingCopy(template));
            }
            this.m_lastValues.put("connection_templates", templateCopies);
        }
    }

    public AbstractWorkingCopyConnectionTemplate[] getConnectionTemplates() {
        List templateCopies = this.m_changes.containsKey("connection_templates") ? (List)this.m_changes.get("connection_templates") : this.getOriginalConnectionTemplates();
        IConfigurationWorkingCopy[] array = templateCopies.toArray(new AbstractWorkingCopyConnectionTemplate[templateCopies.size()]);
        return (AbstractWorkingCopyConnectionTemplate[])ConfigurationWorkingCopyProvider.getInstance().getSortedCopyArray(array);
    }
}

