/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyClient;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyLogicalSystem;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationEditorException;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationWorkingCopyProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IConfigurationWorkingCopy;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;

class WorkingCopyClient
extends AbstractWorkingCopyClient {
    private IClient m_client;
    private boolean m_isActive;

    protected WorkingCopyClient(IClient client) {
        this.m_client = client;
        this.m_isActive = client.equals(Configuration.getConfiguration().getActiveClient());
    }

    public Object getOriginal() {
        return this.m_client;
    }

    public String getId() {
        return (String)this.get("client_name");
    }

    public IConfigurationWorkingCopy applyChanges() throws ConfigurationEditorException {
        IClient modifiedClient = this.m_client;
        if (this.neededNewInstance()) {
            Configuration.getConfiguration().deleteClient(this.m_client.getName());
            String newClientName = this.getId();
            AbstractWorkingCopyLogicalSystem systemCopy = this.getLogicalSystem();
            if (!(systemCopy.getOriginal() instanceof ILogicalSystem)) {
                throw new ConfigurationEditorException(this, "The logical system \"" + systemCopy.getId() + "\" on client \"" + this.getId() + "\" is not yet completly configured.");
            }
            ILogicalSystem newLogicalSystem = (ILogicalSystem)systemCopy.getOriginal();
            String newLocalRoot = this.getLocalRoot();
            try {
                modifiedClient = this.createClient(newClientName, newLocalRoot, newLogicalSystem);
            }
            catch (ConfigurationException x) {
                throw new ConfigurationEditorException(this, x.getMessage());
            }
            ConfigurationWorkingCopyProvider.getInstance().removeWorkingCopy(this.m_client);
        }
        try {
            this.updateClientFilter(modifiedClient);
            this.updateMountPionts(modifiedClient);
            this.clearCaches();
            return this.getCopy(modifiedClient);
        }
        catch (ConfigurationException x) {
            throw new ConfigurationEditorException(this, x.getMessage());
        }
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    protected void rememberLastValue(String key) {
        if (key.equals("client_name")) {
            this.m_lastValues.put("client_name", this.m_client.getName());
        } else if (key.equals("logical_system")) {
            this.m_lastValues.put("logical_system", this.getCopy(this.m_client.getLogicalSystem()));
        } else if (key.equals("local_root")) {
            this.m_lastValues.put("local_root", this.m_client.getAbsoluteLocalRoot());
        } else if (key.equals("client_filter")) {
            String filter = this.m_client.getClientFilter();
            if (filter == null) {
                filter = "";
            }
            this.m_lastValues.put("client_filter", filter);
        } else if (key.equals("mount_points")) {
            this.m_lastValues.put("mount_points", this.m_client.mountPoints());
        }
    }

    public AbstractWorkingCopyLogicalSystem getLogicalSystem() {
        return (AbstractWorkingCopyLogicalSystem)this.get("logical_system");
    }

    public String getLocalRoot() {
        return (String)this.get("local_root");
    }

    public String getClientFilter() {
        return (String)this.get("client_filter");
    }
}

