/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationUtil;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.LocalFileService;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

class SimpleCreateClientDialog
extends Dialog {
    private Label m_image;
    private Label m_message;
    private Composite m_editArea;
    private StringFieldEditor m_feClientName;
    private StringFieldEditor m_feServerUrl;
    private StringFieldEditor m_feUserName;
    private StringFieldEditor m_fePwd;
    private Text m_txLocalRoot;
    private boolean m_creatingClientFailed;

    public SimpleCreateClientDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("New DTR Client");
    }

    protected Control createDialogArea(Composite parent) {
        Composite baseArea = (Composite)super.createDialogArea(parent);
        Composite messageArea = new Composite(baseArea, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        messageArea.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        messageArea.setLayoutData((Object)gridData);
        this.m_image = new Label(messageArea, 0);
        this.m_image.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
        this.m_image.setLayoutData((Object)new GridData(2));
        this.m_message = new Label(messageArea, 64);
        this.m_message.setText("Specify following parameters:");
        gridData = new GridData(768);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.m_message.setLayoutData((Object)gridData);
        this.m_editArea = new Composite(baseArea, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.m_editArea.setLayout((Layout)gridLayout);
        this.m_editArea.setLayoutData((Object)new GridData(1816));
        this.m_feClientName = new StringFieldEditor("", "Client Name:", this.m_editArea);
        String clientName = this.getNewClientName(0);
        this.m_feClientName.setStringValue(clientName);
        this.m_feClientName.fillIntoGrid(this.m_editArea, 2);
        this.m_feClientName.getTextControl(this.m_editArea).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimpleCreateClientDialog.this.clearMessageArea();
                SimpleCreateClientDialog.this.setOkButtonEnabled(SimpleCreateClientDialog.this.checkClientName() != null);
            }
        });
        this.m_feServerUrl = new StringFieldEditor("", "DTR Server URL:", this.m_editArea);
        this.m_feServerUrl.setStringValue("<please specify>");
        this.m_feServerUrl.fillIntoGrid(this.m_editArea, 2);
        this.m_feServerUrl.getTextControl(this.m_editArea).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimpleCreateClientDialog.this.clearMessageArea();
                SimpleCreateClientDialog.this.setOkButtonEnabled(SimpleCreateClientDialog.this.checkServerUrl() != null);
            }
        });
        if (!VfsManagerProvider.getInstance().isSapIDELoginAvailable()) {
            this.m_feUserName = new StringFieldEditor("", "User Name:", this.m_editArea);
            this.m_feUserName.setStringValue(System.getProperty("user.name"));
            this.m_feUserName.fillIntoGrid(this.m_editArea, 2);
            this.m_feUserName.getTextControl(this.m_editArea).addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SimpleCreateClientDialog.this.clearMessageArea();
                    SimpleCreateClientDialog.this.setOkButtonEnabled(SimpleCreateClientDialog.this.checkUserName() != null);
                }
            });
            this.m_fePwd = new StringFieldEditor("", "Password:", this.m_editArea);
            this.m_fePwd.getTextControl(this.m_editArea).setEchoChar('*');
            this.m_fePwd.fillIntoGrid(this.m_editArea, 2);
        }
        Composite localRootArea = new Composite(baseArea, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        localRootArea.setLayout((Layout)gridLayout);
        localRootArea.setLayoutData((Object)new GridData(768));
        Label label = new Label(localRootArea, 0);
        label.setText("Local Root:");
        int labelWidth = LayoutHelper.getControlWidthHint((Control)this.m_feClientName.getLabelControl(this.m_editArea));
        int dummyWidth = LayoutHelper.getControlWidthHint((Control)this.m_feServerUrl.getLabelControl(this.m_editArea));
        if (dummyWidth > labelWidth) {
            labelWidth = dummyWidth;
        }
        if (this.m_feUserName != null && (dummyWidth = LayoutHelper.getControlWidthHint((Control)this.m_feUserName.getLabelControl(this.m_editArea))) > labelWidth) {
            labelWidth = dummyWidth;
        }
        if (this.m_fePwd != null && (dummyWidth = LayoutHelper.getControlWidthHint((Control)this.m_fePwd.getLabelControl(this.m_editArea))) > labelWidth) {
            labelWidth = dummyWidth;
        }
        gridData = new GridData();
        gridData.widthHint = labelWidth + 3;
        label.setLayoutData((Object)gridData);
        this.m_txLocalRoot = new Text(localRootArea, 2048);
        String userHome = ClientConfigurationUtil.getUserWorkingDirectory();
        if ("".equals(userHome)) {
            userHome = System.getProperty("user.home");
            userHome = PathUtilities.assureTrailingSeparator((String)userHome, (IFileService)new LocalFileService()) + "dtr" + "\\" + clientName;
        }
        String pathProposal = userHome;
        this.m_txLocalRoot.setText(pathProposal);
        this.m_txLocalRoot.setLayoutData((Object)new GridData(768));
        this.m_txLocalRoot.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimpleCreateClientDialog.this.clearMessageArea();
                SimpleCreateClientDialog.this.setOkButtonEnabled(SimpleCreateClientDialog.this.checkLocalRoot() != null);
            }
        });
        Button bnBrowse = new Button(localRootArea, 8);
        bnBrowse.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        gridData = new GridData(128);
        gridData.widthHint = LayoutHelper.getControlHeigthHint((Control)this.m_txLocalRoot);
        gridData.heightHint = gridData.widthHint - 2;
        bnBrowse.setLayoutData((Object)gridData);
        bnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SimpleCreateClientDialog.this.getShell(), 0);
                dialog.setText("Local Root");
                dialog.setMessage("Specify the absolute local root of the client:");
                dialog.setFilterPath(SimpleCreateClientDialog.this.m_txLocalRoot.getText());
                String path = dialog.open();
                if (path != null) {
                    SimpleCreateClientDialog.this.m_txLocalRoot.setText(path);
                }
            }
        });
        return baseArea;
    }

    protected void okPressed() {
        final String clientName = this.checkClientName();
        if (clientName == null) {
            this.setOkButtonEnabled(false);
            this.m_feClientName.getTextControl(this.m_editArea).selectAll();
            this.m_feClientName.setFocus();
            return;
        }
        final String serverUrl = this.checkServerUrl();
        if (serverUrl == null) {
            this.setOkButtonEnabled(false);
            this.m_feServerUrl.getTextControl(this.m_editArea).selectAll();
            this.m_feServerUrl.setFocus();
            return;
        }
        final String userName = this.checkUserName();
        if (userName == null) {
            this.setOkButtonEnabled(false);
            if (this.m_feUserName != null) {
                this.m_feUserName.getTextControl(this.m_editArea).selectAll();
                this.m_feUserName.setFocus();
            }
            return;
        }
        final String localRoot = this.checkLocalRoot();
        if (localRoot == null) {
            this.setOkButtonEnabled(false);
            this.m_txLocalRoot.selectAll();
            this.m_txLocalRoot.setFocus();
            return;
        }
        final String pwd = this.m_fePwd != null ? this.m_fePwd.getStringValue() : "";
        final String logicalSystemName = clientName.replace(' ', '_');
        final IConfiguration dtrConfig = Configuration.getConfiguration();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IClient newClient;
                IRepositoryServer newServer;
                ILogicalSystem newLogicalSystem;
                try {
                    newLogicalSystem = dtrConfig.createLogicalSystem(SimpleCreateClientDialog.this.getNewLogicalSystemName(logicalSystemName, 0));
                }
                catch (Exception x) {
                    SimpleCreateClientDialog.this.handleExceptionDuringCreating(x);
                    return;
                }
                try {
                    newServer = newLogicalSystem.addRepositoryServer(serverUrl, userName, pwd);
                }
                catch (Exception x) {
                    SimpleCreateClientDialog.this.handleExceptionDuringCreating(x);
                    SimpleCreateClientDialog.this.m_feServerUrl.getTextControl(SimpleCreateClientDialog.this.m_editArea).selectAll();
                    SimpleCreateClientDialog.this.m_feServerUrl.setFocus();
                    dtrConfig.removeLogicalSystem(newLogicalSystem);
                    return;
                }
                try {
                    newClient = dtrConfig.createClient(clientName, localRoot, newLogicalSystem);
                }
                catch (Exception x) {
                    SimpleCreateClientDialog.this.handleExceptionDuringCreating(x);
                    dtrConfig.removeLogicalSystem(newLogicalSystem);
                    return;
                }
                try {
                    newClient.createMountPoint(newServer, "ws/", "");
                    String clientFilter = "".equals(userName) ? System.getProperty("user.name") + ":" + ClientConfigurationUtil.getHostName() : userName + ":" + ClientConfigurationUtil.getHostName();
                    newClient.setClientFilter(clientName + ":" + clientFilter);
                    dtrConfig.saveAll();
                }
                catch (Exception x) {
                    SimpleCreateClientDialog.this.handleExceptionDuringCreating(x);
                    dtrConfig.deleteClient(newClient.getName());
                    dtrConfig.removeLogicalSystem(newLogicalSystem);
                    return;
                }
                IClient client = newClient;
                SimpleCreateClientDialog.this.getShell().getDisplay().asyncExec(new Runnable(this, client){
                    private final /* synthetic */ IClient val$client;
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$client = val$client;
                    }

                    public void run() {
                        6.access$1100(this.this$1).setActiveClient(this.val$client);
                    }
                });
            }

            static /* synthetic */ IConfiguration access$1100(6 x0) {
                return x0.dtrConfig;
            }
        });
        if (this.m_creatingClientFailed) {
            return;
        }
        ClientConfigurationUtil.setUserWorkingDirectory(localRoot);
        super.okPressed();
    }

    private void handleExceptionDuringCreating(Exception x) {
        this.setErrorMessage(x.getMessage());
        this.setOkButtonEnabled(false);
        this.m_creatingClientFailed = true;
    }

    private String checkClientName() {
        String clientName = this.m_feClientName.getStringValue().trim();
        if ("".equals(clientName)) {
            this.setErrorMessage("The client name must not be empty.");
            return null;
        }
        if (this.doClientAlreadyExists(clientName)) {
            this.setErrorMessage("Another client with same name \"" + clientName + "\" already exists.");
            return null;
        }
        return clientName;
    }

    private String checkServerUrl() {
        String serverUrl = this.m_feServerUrl.getStringValue().trim();
        if ("".equals(serverUrl)) {
            this.setErrorMessage("The server URL must not be empty.");
            return null;
        }
        return serverUrl;
    }

    private String checkUserName() {
        String userName;
        String string = userName = this.m_feUserName != null ? this.m_feUserName.getStringValue().trim() : "";
        if (this.m_feUserName != null && "".equals(userName)) {
            this.setErrorMessage("The user name must not be empty.");
            return null;
        }
        return userName;
    }

    private String checkLocalRoot() {
        String localRoot = this.m_txLocalRoot.getText().trim();
        if ("".equals(localRoot)) {
            this.setErrorMessage("The absolute local root of client must not be empty.");
            return null;
        }
        return localRoot;
    }

    private void setErrorMessage(String message) {
        this.m_image.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        this.m_message.setText(message);
        this.m_message.setForeground(this.getShell().getDisplay().getSystemColor(3));
        this.m_message.getParent().pack();
    }

    private void clearMessageArea() {
        this.m_image.setText("");
        this.m_message.setText("");
        this.m_message.getParent().pack();
    }

    private String getNewClientName(int count) {
        String name = "New DTR Client" + (count > 0 ? " (" + count + ")" : "");
        if (!this.doClientAlreadyExists(name)) {
            return name;
        }
        return this.getNewClientName(count + 1);
    }

    private boolean doClientAlreadyExists(String clientName) {
        IClient client = Configuration.getConfiguration().getClient(clientName);
        return client != null;
    }

    private String getNewLogicalSystemName(String proposal, int count) {
        String name = proposal + (count > 0 ? "_" + count : "");
        if (!this.doLogicalSystemAlreadyExists(name)) {
            return name;
        }
        return this.getNewLogicalSystemName(proposal, count + 1);
    }

    private boolean doLogicalSystemAlreadyExists(String logicalSystemName) {
        ILogicalSystem logicalSystem = Configuration.getConfiguration().getLogicalSystem(logicalSystemName);
        return logicalSystem != null;
    }

    private void setOkButtonEnabled(boolean enabled) {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(enabled);
        }
    }
}

