/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.DAVDecorator;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationUtil;
import com.tssap.dtr.client.eclipse.ui.clientConfig.MountPointLocalPath;
import com.tssap.dtr.client.eclipse.ui.clientConfig.MountPointRemotePath;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class MountPointTreeLabelProvider
extends LabelProvider {
    private static final String NODE_LABEL_MOUNT_POINT = "Mount Point";

    MountPointTreeLabelProvider() {
    }

    public Image getImage(Object element) {
        if (element instanceof IConnectionTemplate) {
            return ClientConfigurationUtil.getConfigImage("reposerver.gif");
        }
        if (element instanceof IMountPoint) {
            return ClientConfigurationUtil.getConfigImage("mountPoint.gif");
        }
        if (element instanceof MountPointRemotePath) {
            return DAVDecorator.decorateFolderItem(LayoutHelper.EMPTY_IMAGE.getImage(), false, null, VfsFolderItemLocationState.SERVER_ONLY, null, null, null);
        }
        if (element instanceof MountPointLocalPath) {
            return DAVDecorator.decorateFolderItem(LayoutHelper.EMPTY_IMAGE.getImage(), false, null, VfsFolderItemLocationState.LOCAL_ONLY, null, null, null);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IConnectionTemplate) {
            return ((IConnectionTemplate)element).getUrl();
        }
        if (element instanceof IMountPoint) {
            return NODE_LABEL_MOUNT_POINT;
        }
        if (element instanceof MountPointRemotePath) {
            String remotePath = ((MountPointRemotePath)element).path;
            if (remotePath.startsWith("ws")) {
                remotePath = remotePath.substring("ws".length());
            }
            if (!remotePath.equals("/")) {
                remotePath = remotePath.substring("/".length());
            }
            return remotePath;
        }
        if (element instanceof MountPointLocalPath) {
            String localPath = ((MountPointLocalPath)element).path;
            if (localPath.equals("")) {
                localPath = "\\";
            }
            return localPath;
        }
        return null;
    }
}

