/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationUtil;
import com.tssap.dtr.client.eclipse.ui.clientConfig.MountPointLocalPath;
import com.tssap.dtr.client.eclipse.ui.clientConfig.MountPointRemotePath;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class MountPointTreeContentProvider
implements ITreeContentProvider {
    private Map m_mpAndTemplate = new HashMap();
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$config$IMountPoint;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$IConnectionTemplate;

    MountPointTreeContentProvider() {
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IConnectionTemplate) {
            HashSet<IMountPoint> mountPoints = new HashSet<IMountPoint>();
            Iterator iter = this.m_mpAndTemplate.keySet().iterator();
            while (iter.hasNext()) {
                IMountPoint mp = (IMountPoint)iter.next();
                if (!this.m_mpAndTemplate.get(mp).equals(element)) continue;
                mountPoints.add(mp);
            }
            return this.getSortedArray(Util.getArrayFromIterator(mountPoints.iterator(), class$com$tssap$dtr$client$lib$vfs$config$IMountPoint == null ? (class$com$tssap$dtr$client$lib$vfs$config$IMountPoint = MountPointTreeContentProvider.class$("com.tssap.dtr.client.lib.vfs.config.IMountPoint")) : class$com$tssap$dtr$client$lib$vfs$config$IMountPoint));
        }
        if (element instanceof IMountPoint) {
            return new Object[]{new MountPointRemotePath((IMountPoint)element), new MountPointLocalPath((IMountPoint)element)};
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IMountPoint) {
            return (IConnectionTemplate)this.m_mpAndTemplate.get(element);
        }
        if (element instanceof MountPointRemotePath) {
            return ((MountPointRemotePath)element).mountPoint;
        }
        if (element instanceof MountPointLocalPath) {
            return ((MountPointLocalPath)element).mountPoint;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IConnectionTemplate || element instanceof IMountPoint;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IClient) {
            HashSet<IConnectionTemplate> templates = new HashSet<IConnectionTemplate>();
            Iterator iter = ((IClient)inputElement).mountPoints();
            while (iter.hasNext()) {
                IMountPoint mp = (IMountPoint)iter.next();
                IConnectionTemplate template = ClientConfigurationUtil.getConnectionTemplate(mp.getRepositoryServer().getUrl());
                if (template == null) continue;
                this.m_mpAndTemplate.put(mp, template);
                templates.add(template);
            }
            iter = ((IClient)inputElement).getLogicalSystem().repositoryServers();
            while (iter.hasNext()) {
                IConnectionTemplate template = ClientConfigurationUtil.getConnectionTemplate(((IRepositoryServer)iter.next()).getUrl());
                if (this.m_mpAndTemplate.containsValue(template)) continue;
                templates.add(template);
            }
            return this.getSortedArray(Util.getArrayFromIterator(templates.iterator(), class$com$tssap$dtr$client$lib$protocol$IConnectionTemplate == null ? (class$com$tssap$dtr$client$lib$protocol$IConnectionTemplate = MountPointTreeContentProvider.class$("com.tssap.dtr.client.lib.protocol.IConnectionTemplate")) : class$com$tssap$dtr$client$lib$protocol$IConnectionTemplate));
        }
        return new Object[0];
    }

    private Object[] getSortedArray(Object[] elements) {
        if (elements == null) {
            Logbook.getWarnChapter().println("Mount point elements in getSortedArray is <null>.");
            Logbook.getWarnChapter().flush();
            return elements;
        }
        Arrays.sort(elements, new Comparator(){

            public int compare(Object elm1, Object elm2) {
                if (elm1 == null || elm2 == null) {
                    Logbook.getWarnChapter().println("Argument in getSortedArray.compare is <null>.");
                    Logbook.getWarnChapter().flush();
                    throw new IllegalStateException("Can't compare <null> arguments.");
                }
                String str1 = null;
                String str2 = null;
                if (elm1 instanceof IConnectionTemplate) {
                    str1 = ((IConnectionTemplate)elm1).getUrl();
                    str2 = ((IConnectionTemplate)elm2).getUrl();
                } else if (elm1 instanceof IMountPoint) {
                    str1 = ((IMountPoint)elm1).getRelativeRemoteRoot();
                    str2 = ((IMountPoint)elm2).getRelativeRemoteRoot();
                }
                if (str1 == null || str2 == null) {
                    Logbook.getWarnChapter().println("Argument's toString in getSortedArray.compare is <null>.");
                    Logbook.getWarnChapter().flush();
                    throw new IllegalStateException("Can't compare <null> toString'ed arguments.");
                }
                return str1.compareTo(str2);
            }
        });
        return elements;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }

    protected Iterator mountPoints() {
        return this.m_mpAndTemplate.keySet().iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

