/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.DAVDecorator;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationUtil;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ExcludeFilter;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IncludeFilter;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ReadOnlyFilter;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class FilterTreeLabelProvider
extends LabelProvider {
    private static final String NODE_LABEL_INCLUDE_FILTER = "Include Filter";
    private static final String NODE_LABEL_EXCLUDE_FILTER = "Exclude Filter";
    private static final String NODE_LABEL_READONLY_FILTER = "Read-only Filter";

    FilterTreeLabelProvider() {
    }

    public Image getImage(Object element) {
        if (element instanceof IRepositoryServer) {
            return ClientConfigurationUtil.getConfigImage("reposerver.gif");
        }
        if (element instanceof IncludeFilter[]) {
            return ClientConfigurationUtil.getConfigImage("filters_in.gif");
        }
        if (element instanceof ExcludeFilter[]) {
            return ClientConfigurationUtil.getConfigImage("filters_ex.gif");
        }
        if (element instanceof ReadOnlyFilter[]) {
            return ClientConfigurationUtil.getConfigImage("filters_ro.gif");
        }
        if (element instanceof IncludeFilter || element instanceof ExcludeFilter || element instanceof ReadOnlyFilter) {
            return DAVDecorator.decorateFolderItem(null, false, VfsFolderItemCategory.FOLDER, null, null, null, null);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IRepositoryServer) {
            return ((IRepositoryServer)element).getUrl();
        }
        if (element instanceof IncludeFilter[]) {
            return NODE_LABEL_INCLUDE_FILTER;
        }
        if (element instanceof ExcludeFilter[]) {
            return NODE_LABEL_EXCLUDE_FILTER;
        }
        if (element instanceof ReadOnlyFilter[]) {
            return NODE_LABEL_READONLY_FILTER;
        }
        if (element instanceof IncludeFilter) {
            return this.getPreparedFilterPath(((IncludeFilter)element).path);
        }
        if (element instanceof ExcludeFilter) {
            return this.getPreparedFilterPath(((ExcludeFilter)element).path);
        }
        if (element instanceof ReadOnlyFilter) {
            return this.getPreparedFilterPath(((ReadOnlyFilter)element).path);
        }
        return null;
    }

    private String getPreparedFilterPath(String realPath) {
        String wsPath;
        String preparedPath = realPath + "/";
        int index = preparedPath.indexOf(wsPath = "/ws/");
        if (index != -1) {
            preparedPath = preparedPath.substring(index + wsPath.length());
        }
        if (preparedPath.equals("")) {
            preparedPath = "/";
        }
        return preparedPath;
    }
}

