/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.MenuActionBase;
import com.tssap.dtr.client.eclipse.ui.clientConfig.EditUserDialog;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import java.security.KeyStore;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

public class EditUserMenuAction
extends MenuActionBase {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$clientConfig$EditUserMenuAction == null ? (class$com$tssap$dtr$client$eclipse$ui$clientConfig$EditUserMenuAction = EditUserMenuAction.class$("com.tssap.dtr.client.eclipse.ui.clientConfig.EditUserMenuAction")) : class$com$tssap$dtr$client$eclipse$ui$clientConfig$EditUserMenuAction));
    private IAction m_action;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$clientConfig$EditUserMenuAction;
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$config$IRepositoryServer;

    public void run(IAction action) {
        Iterator iter;
        IRepositoryServer[] servers;
        IClient activeClient = Configuration.getConfiguration().getActiveClient();
        if (activeClient != null) {
            try {
                VfsManagerProvider.getInstance().getVersionedFileSystemManager(activeClient.getContext());
            }
            catch (VfsException x) {
                this.showErrorMessage("Changing password failed: " + x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                return;
            }
        }
        if ((servers = (IRepositoryServer[])Util.getArrayFromIterator(iter = activeClient.getLogicalSystem().repositoryServers(), class$com$tssap$dtr$client$lib$vfs$config$IRepositoryServer == null ? (class$com$tssap$dtr$client$lib$vfs$config$IRepositoryServer = EditUserMenuAction.class$("com.tssap.dtr.client.lib.vfs.config.IRepositoryServer")) : class$com$tssap$dtr$client$lib$vfs$config$IRepositoryServer)).length != 1) {
            this.showErrorMessage("Changing password failed: Could not determine the repository server for current DTR client!");
            return;
        }
        new EditUserDialog(this.getShell(), servers[0]).open();
    }

    protected boolean notifyIDELoginEvent() {
        return true;
    }

    protected boolean notifyClientConfigurationChangeEvent() {
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.m_action == null && action != null) {
            this.m_action = action;
            this.m_action.setEnabled(false);
        }
    }

    public void onUserLoggedIn(String[] userAndPassword, KeyStore[] serverAndClientCerts) {
        if (this.m_action != null && Configuration.getConfiguration().getActiveClient() != null) {
            this.m_action.setEnabled(true);
        }
    }

    public void onUserLoggedOut() {
        if (this.m_action != null) {
            this.m_action.setEnabled(false);
        }
    }

    public void onActiveClientChanged(IClient newClient, IClient oldClient) {
        if (this.m_action != null) {
            this.m_action.setEnabled(newClient != null);
        }
    }

    public void onConfigurationChanged(IConfiguration configuration) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

