/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationUtil;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditUserDialog
extends Dialog {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$clientConfig$EditUserDialog == null ? (class$com$tssap$dtr$client$eclipse$ui$clientConfig$EditUserDialog = EditUserDialog.class$("com.tssap.dtr.client.eclipse.ui.clientConfig.EditUserDialog")) : class$com$tssap$dtr$client$eclipse$ui$clientConfig$EditUserDialog));
    private static final char ECHO_CAHR = '*';
    private IRepositoryServer m_server;
    private String m_user;
    private Label m_image;
    private Label m_message;
    private Text m_txOldPwd;
    private Text m_txNewPwd;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$clientConfig$EditUserDialog;

    public EditUserDialog(Shell parentShell, IRepositoryServer repositoryServer) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_server = repositoryServer;
        this.setCurrentUser(repositoryServer.getUrl());
    }

    public EditUserDialog(Shell parentShell, IConnectionTemplate connectionTemplate) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setRepositoryServer(connectionTemplate.getUrl());
        this.m_user = connectionTemplate.getSessionContext().getUser();
    }

    public EditUserDialog(Shell parentShell, String serverUrl) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setRepositoryServer(serverUrl);
        this.setCurrentUser(serverUrl);
    }

    private void setRepositoryServer(String serverUrl) {
        IRepositoryServer server = null;
        Iterator logicalSystems = Configuration.getConfiguration().logicalSystems();
        while (logicalSystems.hasNext()) {
            server = ((ILogicalSystem)logicalSystems.next()).getRepositoryServer(serverUrl);
            if (server == null) continue;
            this.m_server = server;
            break;
        }
        if (server == null) {
            throw new IllegalArgumentException("Could not determine the repository server for given URL!");
        }
    }

    private void setCurrentUser(String serverUrl) {
        IConnectionTemplate connectionTemplate = ClientConfigurationUtil.getConnectionTemplate(serverUrl);
        if (connectionTemplate == null) {
            throw new IllegalArgumentException("Could not determine the current user!");
        }
        this.m_user = connectionTemplate.getSessionContext().getUser();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Change Password");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialog = (Composite)super.createDialogArea(parent);
        Composite messageArea = new Composite(dialog, 0);
        messageArea.setLayout((Layout)new GridLayout(2, false));
        messageArea.setLayoutData((Object)new GridData(768));
        this.m_image = new Label(messageArea, 0);
        this.m_image.setLayoutData((Object)new GridData(66));
        this.m_message = new Label(messageArea, 64);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.getMinimumMessageWidth();
        this.m_message.setLayoutData((Object)gridData);
        this.setInfoMassage("Change password on DTR server \"" + this.m_server.getUrl() + "\":");
        Composite editArea = new Composite(dialog, 0);
        editArea.setLayout((Layout)new GridLayout(2, false));
        editArea.setLayoutData((Object)new GridData(768));
        new Label(editArea, 0).setText("User Name:");
        Text txName = new Text(editArea, 526340);
        txName.setLayoutData((Object)new GridData(768));
        txName.setEditable(false);
        txName.setText(this.m_user);
        new Label(editArea, 0).setText("Old Password:");
        this.m_txOldPwd = new Text(editArea, 2052);
        this.m_txOldPwd.setEchoChar('*');
        this.m_txOldPwd.setLayoutData((Object)new GridData(768));
        Label spacer = new Label(editArea, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        spacer.setLayoutData((Object)gridData);
        new Label(editArea, 0).setText("New Password:");
        this.m_txNewPwd = new Text(editArea, 2052);
        this.m_txNewPwd.setEchoChar('*');
        this.m_txNewPwd.setLayoutData((Object)new GridData(768));
        new Label(editArea, 0).setText("Confirmation:");
        final Text txNewPwdConf = new Text(editArea, 2052);
        txNewPwdConf.setEchoChar('*');
        txNewPwdConf.setLayoutData((Object)new GridData(768));
        this.m_txNewPwd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String confirm = txNewPwdConf.getText().trim();
                if (confirm.length() > 0) {
                    boolean isSame = confirm.equals(EditUserDialog.this.m_txNewPwd.getText().trim());
                    EditUserDialog.super.getButton(0).setEnabled(isSame);
                } else {
                    EditUserDialog.super.getButton(0).setEnabled(false);
                }
            }
        });
        txNewPwdConf.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean isSame = txNewPwdConf.getText().trim().equals(EditUserDialog.this.m_txNewPwd.getText().trim());
                EditUserDialog.super.getButton(0).setEnabled(isSame);
            }
        });
        this.m_txOldPwd.setFocus();
        return dialog;
    }

    private int getMinimumMessageWidth() {
        return this.convertHorizontalDLUsToPixels(300);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
        this.getButton(1).addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                EditUserDialog.this.setInfoMassage("Change password on DTR server \"" + EditUserDialog.this.m_server.getUrl() + "\":");
            }
        });
    }

    protected void okPressed() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    EditUserDialog.this.m_server.setPassword(EditUserDialog.this.m_user, EditUserDialog.this.m_txOldPwd.getText().trim(), EditUserDialog.this.m_txNewPwd.getText().trim());
                    EditUserDialog.super.okPressed();
                }
                catch (ConfigurationException x) {
                    EditUserDialog.super.getButton(1).setFocus();
                    EditUserDialog.this.setErrorMessage(x.getMessage());
                    LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                    return;
                }
            }
        });
    }

    private void setErrorMessage(String message) {
        this.m_image.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        this.m_message.setForeground(this.getShell().getDisplay().getSystemColor(3));
        this.m_message.setBackground(this.getShell().getDisplay().getSystemColor(22));
        this.m_message.setText(message);
    }

    private void setInfoMassage(String message) {
        this.m_image.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
        this.m_message.setForeground(this.getShell().getDisplay().getSystemColor(28));
        this.m_message.setBackground(this.getShell().getDisplay().getSystemColor(29));
        this.m_message.setText(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

