/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyConnectionTemplate;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyLogicalSystem;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationEditorException;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationWorkingCopyProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IConfigurationWorkingCopy;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import java.util.ArrayList;
import java.util.List;

public class DummyLogicalSystem
extends AbstractWorkingCopyLogicalSystem {
    private String m_systemName;
    private List m_templates = new ArrayList();

    protected DummyLogicalSystem() {
    }

    public Object getOriginal() {
        return this;
    }

    public String getId() {
        return this.m_changes.containsKey("logical_system_name") ? (String)this.m_changes.get("logical_system_name") : this.m_systemName;
    }

    public IConfigurationWorkingCopy applyChanges() throws ConfigurationEditorException {
        AbstractWorkingCopyConnectionTemplate[] newTemplates = this.getConnectionTemplates();
        if (newTemplates.length == 0) {
            throw new ConfigurationEditorException(this, "The repository server on logical system \"" + this.getId() + "\" is not yet specified.");
        }
        String newSystemName = (String)this.m_changes.get("logical_system_name");
        try {
            ILogicalSystem newLogicalSystem = this.createLogicalSystem(newSystemName);
            this.updateConnectionTemplates(newLogicalSystem);
            ConfigurationWorkingCopyProvider.getInstance().removeWorkingCopy(this);
            this.clearCaches();
            return this.getCopy(newLogicalSystem);
        }
        catch (ConfigurationException x) {
            throw new ConfigurationEditorException(this, x.getMessage());
        }
    }

    public void revertChanges() {
        if (this.m_systemName == null && this.m_changes.containsKey("logical_system_name")) {
            this.m_systemName = (String)this.m_changes.get("logical_system_name");
        }
        super.revertChanges();
    }

    protected void rememberLastValue(String key) {
    }

    public AbstractWorkingCopyConnectionTemplate[] getConnectionTemplates() {
        List templateCopies = this.m_changes.containsKey("connection_templates") ? (List)this.m_changes.get("connection_templates") : this.m_templates;
        IConfigurationWorkingCopy[] array = templateCopies.toArray(new AbstractWorkingCopyConnectionTemplate[templateCopies.size()]);
        return (AbstractWorkingCopyConnectionTemplate[])ConfigurationWorkingCopyProvider.getInstance().getSortedCopyArray(array);
    }
}

