/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyClient;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyLogicalSystem;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationEditorException;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationWorkingCopyProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IConfigurationWorkingCopy;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;

class DummyClient
extends AbstractWorkingCopyClient {
    private String m_clientName;
    private String m_localRoot = null;
    private String m_clientFilter = "";
    private AbstractWorkingCopyLogicalSystem m_systemCopy = null;

    protected DummyClient() {
    }

    public Object getOriginal() {
        return this;
    }

    public String getId() {
        return this.m_changes.containsKey("client_name") ? (String)this.m_changes.get("client_name") : this.m_clientName;
    }

    public IConfigurationWorkingCopy applyChanges() throws ConfigurationEditorException {
        String newLocalRoot = this.getLocalRoot();
        if (newLocalRoot == null || newLocalRoot.equals("")) {
            throw new ConfigurationEditorException(this, "The absolute local root of client \"" + this.getId() + "\" is not yet specified.");
        }
        AbstractWorkingCopyLogicalSystem systemCopy = this.getLogicalSystem();
        if (systemCopy == null) {
            throw new ConfigurationEditorException(this, "The logical system of client \"" + this.getId() + "\" is not yet specified.");
        }
        if (!(systemCopy.getOriginal() instanceof ILogicalSystem)) {
            throw new ConfigurationEditorException(this, "The logical system \"" + systemCopy.getId() + "\" on client \"" + this.getId() + "\" is not yet completly configured.");
        }
        ILogicalSystem newLogicalSystem = (ILogicalSystem)systemCopy.getOriginal();
        String newClientName = this.getId();
        try {
            IClient newClient = this.createClient(newClientName, newLocalRoot, newLogicalSystem);
            this.updateClientFilter(newClient);
            this.updateMountPionts(newClient);
            this.clearCaches();
            ConfigurationWorkingCopyProvider.getInstance().removeWorkingCopy(this);
            return this.getCopy(newClient);
        }
        catch (ConfigurationException x) {
            throw new ConfigurationEditorException(this, x.getMessage());
        }
    }

    public boolean isActive() {
        return !Configuration.getConfiguration().clients().hasNext();
    }

    public void revertChanges() {
        if (this.m_clientName == null && this.m_changes.containsKey("client_name")) {
            this.m_clientName = (String)this.m_changes.get("client_name");
        }
        super.revertChanges();
    }

    protected void rememberLastValue(String key) {
        if (key.equals("client_filter")) {
            this.m_lastValues.put("client_filter", this.m_clientFilter);
        }
    }

    public AbstractWorkingCopyLogicalSystem getLogicalSystem() {
        return this.m_changes.containsKey("logical_system") ? (AbstractWorkingCopyLogicalSystem)this.m_changes.get("logical_system") : this.m_systemCopy;
    }

    public String getLocalRoot() {
        return this.m_changes.containsKey("local_root") ? (String)this.m_changes.get("local_root") : this.m_localRoot;
    }

    public String getClientFilter() {
        return this.m_changes.containsKey("client_filter") ? (String)this.m_changes.get("client_filter") : this.m_clientFilter;
    }
}

