/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsRootFolder;
import com.tssap.dtr.client.lib.vfs.actions.IVfsAction;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.actions.RemoveAction;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class DiscardDTRClientAction
extends VfsObjectSelectionAction
implements IViewActionDelegate {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$clientConfig$DiscardDTRClientAction == null ? (class$com$tssap$dtr$client$eclipse$ui$clientConfig$DiscardDTRClientAction = DiscardDTRClientAction.class$("com.tssap.dtr.client.eclipse.ui.clientConfig.DiscardDTRClientAction")) : class$com$tssap$dtr$client$eclipse$ui$clientConfig$DiscardDTRClientAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$clientConfig$DiscardDTRClientAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        return true;
    }

    protected boolean runWithinWorkerThread() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        Object selected = selection.getFirstElement();
        IConfiguration config = Configuration.getConfiguration();
        if (selected instanceof IVfsRootFolder) {
            IVfsRootFolder rootFolder = (IVfsRootFolder)selected;
            IVersionedFileSystemManager vfsManager = rootFolder.getVersionedFileSystemManager();
            if (vfsManager == null) {
                this.showErrorMessage("Deleting client failed: <null> VFS manager.");
                return;
            }
            String clientName = vfsManager.getClientName();
            IClient client = config.getClient(clientName);
            if (client == null) {
                this.showErrorMessage("Deleting client \"" + clientName + "\" failed: <null> client object.");
                return;
            }
            this.performDeletingClient(config, client, rootFolder);
            return;
        }
        IClient activeClient = config.getActiveClient();
        if (activeClient != null) {
            this.performDeletingClient(config, activeClient, null);
            return;
        }
        this.showErrorMessage("Deleting client failed: <null> client object.");
    }

    private void performDeletingClient(final IConfiguration config, IClient client, final IVfsRootFolder rootFolder) {
        final String clientName = client.getName();
        String warningMessage = rootFolder != null ? "This Action will remove all files synced under this client. However you must revert or check-in all open activities under this client." : "The client is currently offline. Deletion of this client will result in the loss of all files in currently open activities under this client.";
        warningMessage = warningMessage + "\n\n" + "Are you sure you want to delete the DTR client \"" + clientName + "\"?";
        MessageDialog warningDialog = new MessageDialog(this.getShell(), "Delete Client", null, warningMessage, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
        if (warningDialog.open() == 0) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    if (rootFolder != null) {
                        DiscardDTRClientAction.super.executeFinalVfsAction((IVfsAction)new RemoveAction((IVfsFolderItem)rootFolder));
                    }
                    DiscardDTRClientAction.super.getShell().getDisplay().asyncExec(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            1.access$200(this.this$1).deleteClientForcedWithNoMercy(1.access$100(this.this$1));
                            Iterator clients = 1.access$200(this.this$1).clients();
                            if (clients.hasNext()) {
                                IClient client = (IClient)clients.next();
                                if (VfsManagerProvider.getInstance().performClientFilterCheck(client.getContext())) {
                                    1.access$200(this.this$1).setActiveClient(client);
                                }
                            } else {
                                1.access$200(this.this$1).setActiveClient(null);
                            }
                            try {
                                1.access$200(this.this$1).saveAll();
                            }
                            catch (IOException x) {
                                DiscardDTRClientAction.access$401(1.access$300(this.this$1), "Saving client configuration failed: " + x.getMessage());
                                LogUtil.logException((Location)DiscardDTRClientAction.access$500(), (Throwable)x);
                            }
                        }
                    });
                }

                static /* synthetic */ String access$100(1 x0) {
                    return x0.clientName;
                }

                static /* synthetic */ IConfiguration access$200(1 x0) {
                    return x0.config;
                }

                static /* synthetic */ DiscardDTRClientAction access$300(1 x0) {
                    return x0.DiscardDTRClientAction.this;
                }
            });
        }
    }

    public void init(IViewPart view) {
        this.m_targetPart = view;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$401(DiscardDTRClientAction x0, String x1) {
        super.showErrorMessage(x1);
    }

    static /* synthetic */ Location access$500() {
        return LOCATION;
    }
}

