/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.util.ImageDescriptorSingletone;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class ConfigureClientDropDownAction
implements IWorkbenchWindowPulldownDelegate {
    protected static final ImageDescriptor IMAGE_DESCRIPTOR_CHECKED = new ImageDescriptorSingletone("checked.gif").getImageDescriptor();
    private Menu m_menu = null;
    private boolean m_showConfigureMenu;

    public ConfigureClientDropDownAction() {
        this(true);
    }

    public ConfigureClientDropDownAction(boolean showConfigureMenu) {
        this.m_showConfigureMenu = showConfigureMenu;
    }

    public Menu getMenu(Control parent) {
        if (this.getCreatedMenu() != null) {
            this.getCreatedMenu().dispose();
        }
        this.setCreatedMenu(new Menu(parent));
        return this.createMenu(this.getCreatedMenu());
    }

    public void dispose() {
        if (this.getCreatedMenu() != null) {
            this.getCreatedMenu().dispose();
        }
    }

    protected Menu getCreatedMenu() {
        return this.m_menu;
    }

    protected void setCreatedMenu(Menu createdMenu) {
        this.m_menu = createdMenu;
    }

    protected Menu createMenu(Menu menu) {
        TreeMap<String, IClient> map = new TreeMap<String, IClient>();
        final IConfiguration config = Configuration.getConfiguration();
        Iterator clients = config.clients();
        while (clients.hasNext()) {
            IClient clt = (IClient)clients.next();
            map.put(clt.getName(), clt);
        }
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            final IClient client = (IClient)map.get(iter.next());
            Action switchAction = new Action(){

                public void run() {
                    if (VfsManagerProvider.getInstance().performClientFilterCheck(client.getContext())) {
                        config.setActiveClient(client);
                    }
                }

                public String getText() {
                    return client.getName();
                }

                public ImageDescriptor getImageDescriptor() {
                    if (client.equals(config.getActiveClient())) {
                        return IMAGE_DESCRIPTOR_CHECKED;
                    }
                    return null;
                }
            };
            ActionContributionItem item = new ActionContributionItem((IAction)switchAction);
            item.fill(menu, -1);
        }
        if (map.isEmpty()) {
            Action noClientAction = new Action("<No Client>"){};
            noClientAction.setEnabled(false);
            ActionContributionItem item = new ActionContributionItem((IAction)noClientAction);
            item.fill(menu, -1);
        }
        if (this.m_showConfigureMenu) {
            // empty if block
        }
        return menu;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

