/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyClient;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyConnectionTemplate;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyLogicalSystem;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationUtil;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationEditorException;
import com.tssap.dtr.client.eclipse.ui.clientConfig.DummyClient;
import com.tssap.dtr.client.eclipse.ui.clientConfig.DummyLogicalSystem;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IConfigurationWorkingCopy;
import com.tssap.dtr.client.eclipse.ui.clientConfig.WorkingCopyClient;
import com.tssap.dtr.client.eclipse.ui.clientConfig.WorkingCopyConnectionTemplate;
import com.tssap.dtr.client.eclipse.ui.clientConfig.WorkingCopyLogicalSystem;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class ConfigurationWorkingCopyProvider {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$clientConfig$ConfigurationWorkingCopyProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$clientConfig$ConfigurationWorkingCopyProvider = ConfigurationWorkingCopyProvider.class$("com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationWorkingCopyProvider")) : class$com$tssap$dtr$client$eclipse$ui$clientConfig$ConfigurationWorkingCopyProvider));
    protected static final String NEW_CLIENT_ID = "New DTR Client";
    protected static final String NEW_LOGICAL_SYSTEM_ID = "New Logical System";
    private static final String NEW_CONNECTION_TEMPLATE_ID = "[ New Server ]";
    private static ConfigurationWorkingCopyProvider m_instance;
    private Map m_copies = new HashMap();
    private List m_deleted = new ArrayList();
    private boolean copiedOriginalClients;
    private boolean copiedOriginalLogicalSystems;
    private boolean copiedOriginalConnectionTemlates;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$clientConfig$ConfigurationWorkingCopyProvider;

    ConfigurationWorkingCopyProvider() {
    }

    public static synchronized ConfigurationWorkingCopyProvider getInstance() {
        if (m_instance == null) {
            m_instance = new ConfigurationWorkingCopyProvider();
        }
        return m_instance;
    }

    public AbstractWorkingCopyClient[] getClientWorkingCopies() {
        if (!this.copiedOriginalClients) {
            this.copyOriginalClients();
        }
        ArrayList copies = new ArrayList();
        Iterator iter = this.m_copies.values().iterator();
        while (iter.hasNext()) {
            Object copy = iter.next();
            if (!(copy instanceof AbstractWorkingCopyClient)) continue;
            copies.add(copy);
        }
        IConfigurationWorkingCopy[] array = copies.toArray(new AbstractWorkingCopyClient[copies.size()]);
        return (AbstractWorkingCopyClient[])this.getSortedCopyArray(array);
    }

    private void copyOriginalClients() {
        Iterator iter = Configuration.getConfiguration().clients();
        while (iter.hasNext()) {
            this.getWorkingCopy(iter.next());
        }
        this.copiedOriginalClients = true;
    }

    public AbstractWorkingCopyLogicalSystem[] getLogicalSystemWorkingCopies() {
        if (!this.copiedOriginalLogicalSystems) {
            this.copyOriginalLogicalSystems();
        }
        ArrayList copies = new ArrayList();
        Iterator iter = this.m_copies.values().iterator();
        while (iter.hasNext()) {
            Object copy = iter.next();
            if (!(copy instanceof AbstractWorkingCopyLogicalSystem)) continue;
            copies.add(copy);
        }
        IConfigurationWorkingCopy[] array = copies.toArray(new AbstractWorkingCopyLogicalSystem[copies.size()]);
        return (AbstractWorkingCopyLogicalSystem[])this.getSortedCopyArray(array);
    }

    private void copyOriginalLogicalSystems() {
        Iterator iter = Configuration.getConfiguration().logicalSystems();
        while (iter.hasNext()) {
            this.getWorkingCopy(iter.next());
        }
        this.copiedOriginalLogicalSystems = true;
    }

    public AbstractWorkingCopyConnectionTemplate[] getConnectionTemplateWorkingCopies() {
        if (!this.copiedOriginalConnectionTemlates) {
            this.copyOriginalConnectionTemplates();
        }
        ArrayList copies = new ArrayList();
        Iterator iter = this.m_copies.values().iterator();
        while (iter.hasNext()) {
            Object copy = iter.next();
            if (!(copy instanceof AbstractWorkingCopyConnectionTemplate)) continue;
            copies.add(copy);
        }
        IConfigurationWorkingCopy[] array = copies.toArray(new AbstractWorkingCopyConnectionTemplate[copies.size()]);
        return (AbstractWorkingCopyConnectionTemplate[])this.getSortedCopyArray(array);
    }

    private void copyOriginalConnectionTemplates() {
        Iterator iter = ClientConfigurationUtil.getConnectionTemplates();
        while (iter.hasNext()) {
            this.getWorkingCopy(iter.next());
        }
        this.copiedOriginalConnectionTemlates = true;
    }

    protected IConfigurationWorkingCopy[] getSortedCopyArray(IConfigurationWorkingCopy[] copies) {
        Arrays.sort(copies, new Comparator(){

            public int compare(Object elm1, Object elm2) {
                String str1 = ((IConfigurationWorkingCopy)elm1).getId();
                String str2 = ((IConfigurationWorkingCopy)elm2).getId();
                return str1.compareTo(str2);
            }
        });
        return copies;
    }

    public IConfigurationWorkingCopy getWorkingCopy(Object original) {
        if (original instanceof IConfigurationWorkingCopy) {
            return (IConfigurationWorkingCopy)original;
        }
        if (!this.m_copies.containsKey(original)) {
            if (original instanceof IClient) {
                this.m_copies.put(original, new WorkingCopyClient((IClient)original));
            } else if (original instanceof ILogicalSystem) {
                this.m_copies.put(original, new WorkingCopyLogicalSystem((ILogicalSystem)original));
            } else if (original instanceof IConnectionTemplate) {
                this.m_copies.put(original, new WorkingCopyConnectionTemplate((IConnectionTemplate)original));
            }
        }
        return (IConfigurationWorkingCopy)this.m_copies.get(original);
    }

    protected void removeWorkingCopy(Object original) {
        this.m_copies.remove(original);
    }

    protected void reset() {
        this.m_copies.clear();
        this.m_deleted.clear();
        this.copiedOriginalClients = false;
        this.copiedOriginalLogicalSystems = false;
        this.copiedOriginalConnectionTemlates = false;
    }

    public IConfigurationWorkingCopy createNewClient() {
        DummyClient dummy = new DummyClient();
        dummy.modifyClientName(this.getNewId(NEW_CLIENT_ID, this.getClientWorkingCopies()));
        this.m_copies.put(dummy, dummy);
        return dummy;
    }

    public IConfigurationWorkingCopy createNewLogicalSystem() {
        DummyLogicalSystem dummy = new DummyLogicalSystem();
        dummy.modifyLogicalSystemName(this.getNewId(NEW_LOGICAL_SYSTEM_ID, this.getLogicalSystemWorkingCopies()));
        this.m_copies.put(dummy, dummy);
        return dummy;
    }

    public IConfigurationWorkingCopy createNewConnectionTemplate() {
        return null;
    }

    private String getNewId(String defaultId, IConfigurationWorkingCopy[] copies) {
        int dummyCount = 1;
        String newId = defaultId;
        while (this.hasIdClash(newId, copies)) {
            newId = defaultId + " (" + dummyCount++ + ")";
        }
        return newId;
    }

    protected boolean hasIdClash(String id, IConfigurationWorkingCopy[] copies) {
        int i = 0;
        while (i < copies.length) {
            if (copies[i].getId().equals(id)) {
                return true;
            }
            Object original = copies[i].getOriginal();
            if (original instanceof IClient ? id.equals(((IClient)original).getName()) : (original instanceof ILogicalSystem ? id.equals(((ILogicalSystem)original).getName()) : original instanceof IConnectionTemplate && id.equals(((IConnectionTemplate)original).getUrl()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IConfigurationWorkingCopy usedByOtherConfigurationElement(IConfigurationWorkingCopy copy) {
        block6: {
            block5: {
                if (!(copy instanceof AbstractWorkingCopyLogicalSystem)) break block5;
                AbstractWorkingCopyClient[] clientCopies = this.getClientWorkingCopies();
                int i = 0;
                while (i < clientCopies.length) {
                    if (copy.equals(clientCopies[i].getLogicalSystem())) {
                        return clientCopies[i];
                    }
                    ++i;
                }
                break block6;
            }
            if (!(copy instanceof AbstractWorkingCopyConnectionTemplate)) break block6;
            AbstractWorkingCopyLogicalSystem[] systemCopies = this.getLogicalSystemWorkingCopies();
            int i = 0;
            while (i < systemCopies.length) {
                AbstractWorkingCopyConnectionTemplate[] templateCopies = systemCopies[i].getConnectionTemplates();
                int j = 0;
                while (j < templateCopies.length) {
                    if (copy.equals(templateCopies[j])) {
                        return systemCopies[i];
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public void deleteWorkingCopy(IConfigurationWorkingCopy copy) throws ConfigurationEditorException {
        IConfigurationWorkingCopy usage = this.usedByOtherConfigurationElement(copy);
        if (usage != null) {
            throw new ConfigurationEditorException(copy, "Deletion failed: Configuration element \"" + copy.getId() + "\" is still used by \"" + usage.getId());
        }
        this.removeWorkingCopy(copy.getOriginal());
        if (copy instanceof WorkingCopyClient || copy instanceof WorkingCopyLogicalSystem || copy instanceof WorkingCopyConnectionTemplate) {
            this.m_deleted.add(copy);
        }
    }

    protected void saveConfiguration(boolean applyChanges) throws ConfigurationEditorException {
        if (applyChanges) {
            AbstractWorkingCopyConnectionTemplate[] templateCopies = this.getConnectionTemplateWorkingCopies();
            int i = 0;
            while (i < templateCopies.length) {
                if (templateCopies[i].isDirty()) {
                    templateCopies[i].applyChanges();
                }
                ++i;
            }
            AbstractWorkingCopyLogicalSystem[] systemCopies = this.getLogicalSystemWorkingCopies();
            int i2 = 0;
            while (i2 < systemCopies.length) {
                if (systemCopies[i2].isDirty()) {
                    systemCopies[i2].applyChanges();
                }
                ++i2;
            }
            AbstractWorkingCopyClient[] clientCopies = this.getClientWorkingCopies();
            int i3 = 0;
            while (i3 < clientCopies.length) {
                if (clientCopies[i3].isDirty()) {
                    clientCopies[i3].applyChanges();
                }
                ++i3;
            }
        }
        Iterator iter = this.m_deleted.iterator();
        while (iter.hasNext()) {
            IConfigurationWorkingCopy copy = (IConfigurationWorkingCopy)iter.next();
            if (copy.getOriginal() instanceof IClient) {
                Configuration.getConfiguration().deleteClient(((IClient)copy.getOriginal()).getName());
                continue;
            }
            if (copy.getOriginal() instanceof ILogicalSystem) {
                Configuration.getConfiguration().removeLogicalSystem((ILogicalSystem)copy.getOriginal());
                continue;
            }
            if (!(copy.getOriginal() instanceof IConnectionTemplate)) continue;
            ClientConfigurationUtil.removeConnectionTemplate((IConnectionTemplate)copy.getOriginal());
        }
    }

    public boolean hasDirtyWorkingCopy() {
        Iterator iter = this.m_copies.values().iterator();
        while (iter.hasNext()) {
            if (!((IConfigurationWorkingCopy)iter.next()).isDirty()) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

