/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.deltavlib.ConnectionPool;
import com.tssap.dtr.client.lib.deltavlib.TemplateProvider;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.pool.IConnectionPool;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.impl.Configuration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public final class ClientConfigurationUtil {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$clientConfig$ClientConfigurationUtil == null ? (class$com$tssap$dtr$client$eclipse$ui$clientConfig$ClientConfigurationUtil = ClientConfigurationUtil.class$("com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationUtil")) : class$com$tssap$dtr$client$eclipse$ui$clientConfig$ClientConfigurationUtil));
    private static final Object[] EMPTY_IMAGE_PROPERTY = new Object[0];
    private static final String CONFIG_IMAGE_DIRECTORY = "config/";
    protected static final String IMAGE_FILE_NAME_VIEW_DETAILS = "view.gif";
    protected static final String IMAGE_FILE_NAME_ADD = "add.gif";
    protected static final String IMAGE_FILE_NAME_EDIT = "edit.gif";
    protected static final String IMAGE_FILE_NAME_DELETE = "delete.gif";
    protected static final String IMAGE_FILE_NAME_PWD = "change_pwd.gif";
    protected static final String IMAGE_FILE_NAME_SUGGEST = "suggestion.gif";
    protected static final String CONFIG_IMAGE_CLIENTS = "user.gif";
    protected static final String CONFIG_IMAGE_LOGICAL_SYSTEMS = "logicsystems.gif";
    protected static final String CONFIG_IMAGE_LOGICAL_SYSTEM = "logicsystem.gif";
    protected static final String CONFIG_IMAGE_SERVERS = "reposervers.gif";
    protected static final String CONFIG_IMAGE_SERVER = "reposerver.gif";
    protected static final String CONFIG_IMAGE_MOUNTPOINTS = "mountPoints.gif";
    protected static final String CONFIG_IMAGE_MOUNTPOINT = "mountPoint.gif";
    protected static final String CONFIG_IMAGE_FILTERS = "filters.gif";
    protected static final String CONFIG_IMAGE_FILTERS_EX = "filters_ex.gif";
    protected static final String CONFIG_IMAGE_FILTERS_IN = "filters_in.gif";
    protected static final String CONFIG_IMAGE_FILTERS_RO = "filters_ro.gif";
    protected static final String CONFIG_IMAGE_SETTINGS = "settings.gif";
    protected static final String CONFIG_IMAGE_NEW_LOGICAL_SYSTEM = "create_logicalsystem.gif";
    protected static final String CONFIG_IMAGE_NEW_SERVER = "create_server.gif";
    protected static final String VALUE_NOT_SPECIFIED = "<please specify>";
    protected static final String PATH_DTR_WS = "ws";
    protected static final String PATH_SLASH = "/";
    protected static final String PATH_BACKSLASH = "\\";
    private static final String PREFER_KEY_USER_WORKING_DIR = "userWorkingDirectory";
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$clientConfig$ClientConfigurationUtil;

    private static TemplateProvider getTemplateProvider() {
        return Configuration.getTemplateProvider();
    }

    protected static void replaceConnectionTemplate(IConnectionTemplate newTemplate) {
        IConnectionPool pool = ConnectionPool.getInstance();
        if (!(pool instanceof com.tssap.dtr.client.lib.protocol.pool.ConnectionPool)) {
            throw new IllegalStateException("Unexpected connection pool implementation (" + pool + ")");
        }
        ClientConfigurationUtil.getTemplateProvider().replaceConnectionTemplate(newTemplate);
        com.tssap.dtr.client.lib.protocol.pool.ConnectionPool connectionPool = (com.tssap.dtr.client.lib.protocol.pool.ConnectionPool)pool;
        connectionPool.refreshAll();
    }

    protected static IConnectionTemplate getConnectionTemplate(String url) {
        return ClientConfigurationUtil.getTemplateProvider().getConnectionTemplate(url);
    }

    protected static Iterator getConnectionTemplates() {
        return ClientConfigurationUtil.getTemplateProvider().iterator();
    }

    protected static void removeConnectionTemplate(IConnectionTemplate template) {
        ClientConfigurationUtil.getTemplateProvider().removeConnectionTemplate(template);
    }

    protected static Image getConfigImage(String imageFileName) {
        ImageDescriptor imageDescriptor;
        if (imageFileName != null && !imageFileName.equals("") && (imageDescriptor = BluebirdPlugin.getDefault().createImageDescriptor(CONFIG_IMAGE_DIRECTORY + imageFileName)) != null) {
            return BluebirdPlugin.getDefault().getPluginImageRegistry().getImage(imageDescriptor.createImage(true), EMPTY_IMAGE_PROPERTY);
        }
        return LayoutHelper.EMPTY_IMAGE.getImage();
    }

    protected static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException x) {
            LogUtil.logException((Location)LOCATION, (Throwable)x);
            return "<host name>";
        }
    }

    protected static String getUserWorkingDirectory() {
        return BluebirdPlugin.getDefault().getPluginPreferences().getString(PREFER_KEY_USER_WORKING_DIR);
    }

    protected static void setUserWorkingDirectory(String workingDirectory) {
        BluebirdPlugin.getDefault().getPluginPreferences().setValue(PREFER_KEY_USER_WORKING_DIR, workingDirectory);
    }

    public static Control createClientSelector(Composite parent) {
        IClient client;
        TreeMap<String, IClient> clients = new TreeMap<String, IClient>();
        Iterator iter = com.tssap.dtr.client.lib.vfs.config.Configuration.getConfiguration().clients();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof IClient)) continue;
            client = (IClient)obj;
            clients.put(client.getName(), client);
        }
        int count = clients.size();
        if (count == 1) {
            client = (IClient)clients.values().iterator().next();
            Text text = new Text(parent, 2060);
            text.setText(client.getName());
            text.setData((Object)client);
            return text;
        }
        if (count > 1) {
            final Combo combo = new Combo(parent, 8);
            IClient[] clientArray = clients.values().toArray(new IClient[clients.size()]);
            IClient activeClient = com.tssap.dtr.client.lib.vfs.config.Configuration.getConfiguration().getActiveClient();
            int i = 0;
            while (i < clientArray.length) {
                String name = clientArray[i].getName();
                combo.add(name);
                combo.setData(name, (Object)clientArray[i]);
                if (clientArray[i].equals(activeClient)) {
                    combo.select(i);
                }
                ++i;
            }
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object data = combo.getData(combo.getText());
                    if (data instanceof IClient) {
                        IClient client = (IClient)data;
                        if (VfsManagerProvider.getInstance().performClientFilterCheck(client.getContext())) {
                            com.tssap.dtr.client.lib.vfs.config.Configuration.getConfiguration().setActiveClient(client);
                        }
                    }
                }
            });
            return combo;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

