/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.DAVDecorator;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyClient;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyConnectionTemplate;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyLogicalSystem;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationUtil;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IConfigurationWorkingCopy;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class ClientConfigurationLabelProvider
extends LabelProvider {
    private static final String NODE_LABEL_CLIENTS = "Clients";
    private static final String NODE_LABEL_SYSTEMS = "Logical Systems";
    private static final String NODE_LABEL_SERVERS = "Servers";
    private static final String DIRTY_MARK = "*";
    private static final String LABEL_EXT_ACTIVE_CLIENT = "active";

    ClientConfigurationLabelProvider() {
    }

    public Image getImage(Object element) {
        if (element instanceof AbstractWorkingCopyClient[]) {
            return ClientConfigurationUtil.getConfigImage("user.gif");
        }
        if (element instanceof AbstractWorkingCopyLogicalSystem[]) {
            return ClientConfigurationUtil.getConfigImage("logicsystems.gif");
        }
        if (element instanceof AbstractWorkingCopyConnectionTemplate[]) {
            return ClientConfigurationUtil.getConfigImage("reposervers.gif");
        }
        if (element instanceof AbstractWorkingCopyClient) {
            return DAVDecorator.decorateFolderItem(null, false, VfsFolderItemCategory.ROOT, null, null, null, null);
        }
        if (element instanceof AbstractWorkingCopyLogicalSystem) {
            return ClientConfigurationUtil.getConfigImage("logicsystem.gif");
        }
        if (element instanceof AbstractWorkingCopyConnectionTemplate) {
            return ClientConfigurationUtil.getConfigImage("reposerver.gif");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof AbstractWorkingCopyClient[]) {
            return NODE_LABEL_CLIENTS;
        }
        if (element instanceof AbstractWorkingCopyLogicalSystem[]) {
            return NODE_LABEL_SYSTEMS;
        }
        if (element instanceof AbstractWorkingCopyConnectionTemplate[]) {
            return NODE_LABEL_SERVERS;
        }
        if (element instanceof AbstractWorkingCopyClient) {
            String label = ((AbstractWorkingCopyClient)element).getId();
            if (((AbstractWorkingCopyClient)element).isDirty()) {
                label = DIRTY_MARK + label;
            }
            if (((AbstractWorkingCopyClient)element).isActive()) {
                label = label + " <" + LABEL_EXT_ACTIVE_CLIENT + ">";
            }
            return label;
        }
        if (element instanceof IConfigurationWorkingCopy) {
            String label = ((IConfigurationWorkingCopy)element).getId();
            if (((IConfigurationWorkingCopy)element).isDirty()) {
                label = DIRTY_MARK + label;
            }
            return label;
        }
        return null;
    }
}

