/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.ui.AscendingElementLabelSorter;
import com.tssap.dtr.client.eclipse.ui.DAVDecorator;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyClient;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyConnectionTemplate;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyLogicalSystem;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationContentProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationLabelProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationUtil;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationEditorException;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationWorkingCopyProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.EditUserDialog;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ExcludeFilter;
import com.tssap.dtr.client.eclipse.ui.clientConfig.FilterTreeContentProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.FilterTreeLabelProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IConfigurationWorkingCopy;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IncludeFilter;
import com.tssap.dtr.client.eclipse.ui.clientConfig.MountPointLocalPath;
import com.tssap.dtr.client.eclipse.ui.clientConfig.MountPointRemotePath;
import com.tssap.dtr.client.eclipse.ui.clientConfig.MountPointTreeContentProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.MountPointTreeLabelProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ReadOnlyFilter;
import com.tssap.dtr.client.eclipse.ui.util.ImageDescriptorSingletone;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemCategory;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ClientConfigurationDialog
extends TitleAreaDialog {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$clientConfig$ClientConfigurationDialog == null ? (class$com$tssap$dtr$client$eclipse$ui$clientConfig$ClientConfigurationDialog = ClientConfigurationDialog.class$("com.tssap.dtr.client.eclipse.ui.clientConfig.ClientConfigurationDialog")) : class$com$tssap$dtr$client$eclipse$ui$clientConfig$ClientConfigurationDialog));
    private static final String CLIENT_CONFIGURATION_DIALOG_LOCATION = "com.tssap.dtr.client.eclipseclientConfigurationDialogLocation";
    private static final String CLIENT_CONFIGURATION_DIALOG_SIZE = "com.tssap.dtr.client.eclipseclientConfigurationDialogSize";
    private static final String CLIENT_CONFIGURATION_DIALOG_SASH_WEIGHTS = "com.tssap.dtr.client.eclipseclientConfigurationDialogSashWeights";
    private static final Point DEFAULT_INITIAL_DIALOG_SIZE = new Point(810, 600);
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{375, 620};
    private static final float MAX_DIALOG_WIDTH_PERCENT = 0.75f;
    private static final int BUTTON_ID_CLOSE = 1026;
    private static final String BUTTON_LABEL_NEW = "New";
    private static final String BUTTON_LABEL_DELETE = "Delete";
    private static final String BUTTON_LABEL_APPLY = "Apply";
    private static final String BUTTON_LABEL_REVERT = "Revert";
    private static final ImageDescriptorSingletone IMAGE_CONFIGURE_WIZ = new ImageDescriptorSingletone("clientconfig_wizban.gif");
    private static final ImageDescriptorSingletone IMAGE_CHECKED = new ImageDescriptorSingletone("checked.gif");
    private static int ICON_BUTTON_HEIGHT;
    private static final String DIALOG_TITLE = "DTR Client Configurations";
    private static final String DIALOG_DESCRIPTION = "Manage and configure DTR clients";
    private static final String TEXT_LABEL_CLIENT = "Client Name:";
    private static final String TEXT_LABEL_SYSTEM = "Logical System Name:";
    private static final String TEXT_LABEL_SERVER = "Server URL:";
    private static final String VALUE_EMPTY = "<empty>";
    private static final String TIT_EDIT_MOUNT_POINT = "Change Mount Point";
    private static final String TIT_EDIT_MPPATH_REMOTE = "Change Remote Path";
    private static final String TIT_EDIT_MPPTH_LOCAL = "Change Local Path";
    private static final String TIT_NEW_MOUNT_POINT = "Add Mount Point";
    private static final String TIT_NEW_MPPATH_REMOTE = "Remote Path";
    private static final String TIT_NEW_MPPTH_LOCAL = "Local Path";
    private static final String MSG_SPEC_MPPATH_REMOTE = "Specify the remote path of the mount point:";
    private static final String MSG_SPEC_MPPATH_LOCAL = "Specify the local path of the mount point:";
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private static final String PROTOCOL_NOT_SUPPORTED = "<not supported>";
    private SashForm m_sashForm;
    private Composite m_selectionArea;
    private Composite m_editArea;
    private Composite m_tabArea;
    private TreeViewer m_configTreeViewer;
    private Label m_lbName;
    private Text m_txName;
    private TabFolder m_tabFolder;
    private ButtonAction m_buttonNew;
    private ButtonAction m_buttonDelete;
    private Button m_buttonApply;
    private Button m_buttonRevert;
    private DirectoryDialog m_directoryDialog;
    private IConfiguration m_clientConfiguration;
    private Object m_currentSelection;
    private Object m_lastSelection;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$clientConfig$ClientConfigurationDialog;

    public ClientConfigurationDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_clientConfiguration = Configuration.getConfiguration();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite topComp = new Composite(dialogArea, 0);
        topComp.setLayoutData((Object)new GridData(1808));
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 5;
        topLayout.marginWidth = 0;
        topComp.setLayout((Layout)topLayout);
        this.setTitle(DIALOG_DESCRIPTION);
        this.setTitleImage(IMAGE_CONFIGURE_WIZ.getImageDescriptor().createImage());
        this.m_sashForm = new SashForm(topComp, 0);
        this.m_sashForm.setOrientation(256);
        GridData gdata = new GridData(1808);
        gdata.horizontalSpan = 2;
        this.m_sashForm.setLayoutData((Object)gdata);
        Composite selectionArea = this.createSelectionArea((Composite)this.m_sashForm);
        selectionArea.setLayoutData((Object)new GridData(1040));
        Composite editArea = this.createEditArea((Composite)this.m_sashForm);
        editArea.setLayoutData((Object)new GridData(1808));
        Label separator = new Label(topComp, 258);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        separator.setLayoutData((Object)gdata);
        dialogArea.layout(true);
        return dialogArea;
    }

    private Composite createSelectionArea(Composite parent) {
        this.m_selectionArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        this.m_selectionArea.setLayout((Layout)layout);
        Label treeLabel = new Label(this.m_selectionArea, 0);
        treeLabel.setText("DTR Client Configurations:");
        GridData gdata = new GridData();
        gdata.horizontalSpan = 3;
        treeLabel.setLayoutData((Object)gdata);
        this.m_configTreeViewer = new TreeViewer(this.m_selectionArea, 2816);
        this.m_configTreeViewer.setContentProvider((IContentProvider)new ClientConfigurationContentProvider());
        this.m_configTreeViewer.setLabelProvider((IBaseLabelProvider)new ClientConfigurationLabelProvider());
        gdata = new GridData(1808);
        gdata.horizontalSpan = 3;
        gdata.widthHint = 0;
        this.m_configTreeViewer.getTree().setLayoutData((Object)gdata);
        Action actNew = new Action(BUTTON_LABEL_NEW){

            public void run() {
                ClientConfigurationDialog.this.handleNewPressed();
            }
        };
        Action actDelete = new Action(BUTTON_LABEL_DELETE){

            public void run() {
                ClientConfigurationDialog.this.handleDeletePressed();
            }
        };
        Action actApply = new Action(BUTTON_LABEL_APPLY){

            public void run() {
                ClientConfigurationDialog.this.handleApplyPressed();
            }
        };
        Action actRevert = new Action(BUTTON_LABEL_REVERT){

            public void run() {
                ClientConfigurationDialog.this.handleRevertPressed();
            }
        };
        final MenuManager menuManager = new MenuManager();
        Menu contextMenu = menuManager.createContextMenu((Control)this.m_configTreeViewer.getTree());
        this.m_configTreeViewer.getTree().setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener((IAction)actNew, (IAction)actDelete, (IAction)actApply, (IAction)actRevert){
            private final /* synthetic */ IAction val$actNew;
            private final /* synthetic */ IAction val$actDelete;
            private final /* synthetic */ IAction val$actApply;
            private final /* synthetic */ IAction val$actRevert;
            {
                this.val$actNew = val$actNew;
                this.val$actDelete = val$actDelete;
                this.val$actApply = val$actApply;
                this.val$actRevert = val$actRevert;
            }

            public void menuAboutToShow(IMenuManager manager) {
                menuManager.removeAll();
                menuManager.add(this.val$actNew);
                if (ClientConfigurationDialog.this.m_currentSelection instanceof IConfigurationWorkingCopy) {
                    menuManager.add(this.val$actDelete);
                    if (((IConfigurationWorkingCopy)ClientConfigurationDialog.this.m_currentSelection).isDirty()) {
                        menuManager.add((IContributionItem)new Separator());
                        menuManager.add(this.val$actApply);
                        menuManager.add(this.val$actRevert);
                    }
                }
            }
        });
        this.m_configTreeViewer.setInput((Object)ConfigurationWorkingCopyProvider.getInstance());
        this.m_configTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ClientConfigurationDialog.this.handleConfigTreeSelection(event);
            }
        });
        this.addTreeDoubleClickListener(this.m_configTreeViewer);
        Button bnNew = this.createPushButton(this.m_selectionArea, BUTTON_LABEL_NEW, null);
        this.m_buttonNew = new ButtonActionNew(bnNew.getText(), bnNew);
        Button bnDelete = this.createPushButton(this.m_selectionArea, BUTTON_LABEL_DELETE, null);
        this.m_buttonDelete = new ButtonActionDelete(bnDelete.getText(), bnDelete);
        return this.m_selectionArea;
    }

    private void handleConfigTreeSelection(SelectionChangedEvent event) {
        if (!(event.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        this.m_lastSelection = this.m_currentSelection;
        this.m_currentSelection = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (this.m_currentSelection == null) {
            this.m_editArea.setVisible(false);
            return;
        }
        this.clearMessageArea();
        this.m_buttonNew.setEnabled(true);
        if (this.m_currentSelection.equals(this.m_lastSelection)) {
            return;
        }
        if (this.m_currentSelection instanceof IConfigurationWorkingCopy[]) {
            this.m_editArea.setVisible(false);
            this.m_buttonDelete.setEnabled(false);
            if (this.m_currentSelection instanceof AbstractWorkingCopyClient[]) {
                this.setMessage("Press NEW to create a DTR Client");
            } else if (this.m_currentSelection instanceof AbstractWorkingCopyLogicalSystem[]) {
                this.setMessage("Press NEW to create a Logical System");
            } else if (this.m_currentSelection instanceof AbstractWorkingCopyConnectionTemplate[]) {
                this.setMessage("Press NEW to create a Server");
            }
            return;
        }
        if (this.m_currentSelection instanceof IConfigurationWorkingCopy) {
            this.m_buttonDelete.setEnabled(true);
            if (this.m_lastSelection != null && this.m_currentSelection.getClass().equals(this.m_lastSelection.getClass())) {
                this.updateEditArea((IConfigurationWorkingCopy)this.m_currentSelection, false, this.m_tabFolder.getSelectionIndex());
            } else {
                this.updateEditArea((IConfigurationWorkingCopy)this.m_currentSelection, false, 0);
            }
            this.setApplyAndRevertButtonEnabled(((IConfigurationWorkingCopy)this.m_currentSelection).isDirty());
        }
    }

    private Composite createEditArea(Composite parent) {
        Composite baseArea = new Composite(parent, 0);
        GridLayout baseAreaLayout = new GridLayout();
        baseAreaLayout.numColumns = 1;
        baseAreaLayout.marginHeight = 0;
        baseArea.setLayout((Layout)baseAreaLayout);
        this.m_editArea = new Composite(baseArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        this.m_editArea.setLayout((Layout)layout);
        this.m_editArea.setLayoutData((Object)new GridData(1808));
        this.m_lbName = new Label(this.m_editArea, 16640);
        GridData gdata = new GridData(4);
        this.m_lbName.setText(TEXT_LABEL_CLIENT);
        int width = LayoutHelper.getControlWidthHint((Control)this.m_lbName);
        this.m_lbName.setText(TEXT_LABEL_SYSTEM);
        if (LayoutHelper.getControlWidthHint((Control)this.m_lbName) > width) {
            width = LayoutHelper.getControlWidthHint((Control)this.m_lbName);
        }
        this.m_lbName.setText(TEXT_LABEL_SERVER);
        if (LayoutHelper.getControlWidthHint((Control)this.m_lbName) > width) {
            width = LayoutHelper.getControlWidthHint((Control)this.m_lbName);
        }
        gdata.widthHint = width;
        this.m_lbName.setLayoutData((Object)gdata);
        this.m_txName = new Text(this.m_editArea, 2052);
        ICON_BUTTON_HEIGHT = LayoutHelper.getControlHeigthHint((Control)this.m_txName);
        this.m_txName.setLayoutData((Object)new GridData(768));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClientConfigurationDialog.this.handleNameFiledModified((TypedEvent)e);
            }
        };
        this.m_txName.addModifyListener(modifyListener);
        this.m_txName.setData((Object)modifyListener);
        Label spacer = new Label(this.m_editArea, 0);
        gdata = new GridData();
        gdata.horizontalSpan = 2;
        spacer.setLayoutData((Object)gdata);
        this.m_tabArea = new Composite(this.m_editArea, 0);
        GridLayout outerTabCompositeLayout = new GridLayout();
        outerTabCompositeLayout.marginHeight = 0;
        outerTabCompositeLayout.marginWidth = 0;
        this.m_tabArea.setLayout((Layout)outerTabCompositeLayout);
        gdata = new GridData(1808);
        gdata.horizontalSpan = 2;
        this.m_tabArea.setLayoutData((Object)gdata);
        this.m_tabFolder = new TabFolder(this.m_tabArea, 0);
        this.m_tabFolder.setLayoutData((Object)new GridData(1808));
        this.m_tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (evt.item instanceof TabItem) {
                    if (((TabItem)evt.item).getText().equals("")) {
                        return;
                    }
                    int tabIndex = ((TabItem)evt.item).getParent().getSelectionIndex();
                    ClientConfigurationDialog.this.handleTabSelection(tabIndex);
                }
            }
        });
        Composite buttonComp = new Composite(this.m_editArea, 0);
        GridLayout buttonCompLayout = new GridLayout();
        buttonCompLayout.numColumns = 2;
        buttonCompLayout.marginHeight = 0;
        buttonCompLayout.marginWidth = 0;
        buttonComp.setLayout((Layout)buttonCompLayout);
        gdata = new GridData(128);
        gdata.horizontalSpan = 2;
        buttonComp.setLayoutData((Object)gdata);
        this.m_buttonApply = this.createPushButton(buttonComp, BUTTON_LABEL_APPLY, null);
        this.m_buttonApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientConfigurationDialog.this.handleApplyPressed();
            }
        });
        this.m_buttonRevert = this.createPushButton(buttonComp, BUTTON_LABEL_REVERT, null);
        this.m_buttonRevert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientConfigurationDialog.this.handleRevertPressed();
            }
        });
        return baseArea;
    }

    private void updateEditArea(IConfigurationWorkingCopy copy, boolean init, int tabIndexToSelect) {
        if (copy == null) {
            this.m_editArea.setVisible(false);
            return;
        }
        this.m_editArea.setVisible(true);
        ModifyListener modifyListener = (ModifyListener)this.m_txName.getData();
        this.m_txName.removeModifyListener(modifyListener);
        if (copy instanceof AbstractWorkingCopyClient) {
            this.m_lbName.setText(TEXT_LABEL_CLIENT);
        } else if (copy instanceof AbstractWorkingCopyLogicalSystem) {
            this.m_lbName.setText(TEXT_LABEL_SYSTEM);
        } else if (copy instanceof AbstractWorkingCopyConnectionTemplate) {
            this.m_lbName.setText(TEXT_LABEL_SERVER);
        } else {
            this.m_lbName.setText("");
        }
        this.m_txName.setText(copy.getId());
        this.m_txName.setEditable(!(copy instanceof AbstractWorkingCopyConnectionTemplate));
        this.m_txName.addModifyListener(modifyListener);
        this.createEditTabs(copy, init, tabIndexToSelect);
    }

    private void createEditTabs(IConfigurationWorkingCopy configElementCopy, boolean init, int tabIndexToSelect) {
        this.m_editArea.setVisible(false);
        TabItem[] oldTabs = this.m_tabFolder.getItems();
        int i = 0;
        while (i < oldTabs.length) {
            oldTabs[i].dispose();
            ++i;
        }
        if (configElementCopy instanceof AbstractWorkingCopyClient) {
            TabItem item = new TabItem(this.m_tabFolder, 0, 0);
            item.setText("General");
            item.setImage(DAVDecorator.decorateFolderItem(null, false, VfsFolderItemCategory.ROOT, null, null, null, null));
            item = new TabItem(this.m_tabFolder, 0, 1);
            item.setText("Mount Points");
            item.setImage(ClientConfigurationUtil.getConfigImage("mountPoints.gif"));
        } else if (configElementCopy instanceof AbstractWorkingCopyLogicalSystem) {
            TabItem item = new TabItem(this.m_tabFolder, 0, 0);
            item.setText("General");
            item.setImage(ClientConfigurationUtil.getConfigImage("logicsystem.gif"));
            item = new TabItem(this.m_tabFolder, 0, 1);
            item.setText("Filters");
            item.setImage(ClientConfigurationUtil.getConfigImage("filters.gif"));
        } else if (configElementCopy instanceof AbstractWorkingCopyConnectionTemplate) {
            TabItem item = new TabItem(this.m_tabFolder, 0, 0);
            item.setText("General");
            item.setImage(ClientConfigurationUtil.getConfigImage("reposerver.gif"));
            item = new TabItem(this.m_tabFolder, 0, 1);
            item.setText("Connection Settings");
            item.setImage(ClientConfigurationUtil.getConfigImage("settings.gif"));
        }
        this.m_tabFolder.setSelection(tabIndexToSelect);
        this.handleTabSelection(tabIndexToSelect);
        this.m_editArea.setVisible(true);
    }

    private void handleTabSelection(int tabIndex) {
        this.clearMessageArea();
        this.m_tabFolder.getItem(tabIndex).setControl(null);
        if (this.m_currentSelection instanceof AbstractWorkingCopyClient) {
            if (tabIndex == 0) {
                this.m_tabFolder.getItem(tabIndex).setControl(this.createClientTabGeneral((Composite)this.m_tabFolder, (AbstractWorkingCopyClient)this.m_currentSelection));
            } else if (tabIndex == 1) {
                this.m_tabFolder.getItem(tabIndex).setControl(this.createClientTabMountPoints((Composite)this.m_tabFolder, (AbstractWorkingCopyClient)this.m_currentSelection));
            }
        } else if (this.m_currentSelection instanceof AbstractWorkingCopyLogicalSystem) {
            if (tabIndex == 0) {
                this.m_tabFolder.getItem(tabIndex).setControl(this.createSystemTabGeneral((Composite)this.m_tabFolder, (AbstractWorkingCopyLogicalSystem)this.m_currentSelection));
            } else if (tabIndex == 1) {
                this.m_tabFolder.getItem(tabIndex).setControl(this.createSystemTabFilter((Composite)this.m_tabFolder, (AbstractWorkingCopyLogicalSystem)this.m_currentSelection));
            }
        } else if (this.m_currentSelection instanceof AbstractWorkingCopyConnectionTemplate) {
            if (tabIndex == 0) {
                this.m_tabFolder.getItem(tabIndex).setControl(this.createServerTabGeneral((Composite)this.m_tabFolder, (AbstractWorkingCopyConnectionTemplate)this.m_currentSelection));
            } else if (tabIndex == 1) {
                this.m_tabFolder.getItem(tabIndex).setControl(this.createServerTabSetting((Composite)this.m_tabFolder, (AbstractWorkingCopyConnectionTemplate)this.m_currentSelection));
            }
        }
        this.m_tabFolder.setSelection(tabIndex);
    }

    private Control createClientTabGeneral(Composite parent, final AbstractWorkingCopyClient clientCopy) {
        Composite pageArea = new Composite(parent, 0);
        GridLayout pageAreaLayout = new GridLayout();
        pageAreaLayout.numColumns = 4;
        pageAreaLayout.marginHeight = 20;
        pageAreaLayout.marginWidth = 10;
        pageArea.setLayout((Layout)pageAreaLayout);
        Label systemLabel = new Label(pageArea, 0);
        systemLabel.setText("Logical System:");
        systemLabel.setLayoutData((Object)new GridData(1));
        final Text systemText = new Text(pageArea, 2060);
        if (clientCopy.getLogicalSystem() != null) {
            systemText.setText(clientCopy.getLogicalSystem().getId());
            systemText.setData((Object)clientCopy.getLogicalSystem());
        } else {
            systemText.setText("<please specify>");
        }
        systemText.setToolTipText("Use dropdown button to change");
        systemText.setLayoutData((Object)new GridData(768));
        systemText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClientConfigurationDialog.this.clearMessageArea();
                clientCopy.modifyLogicalSystem((IConfigurationWorkingCopy)systemText.getData());
                ClientConfigurationDialog.this.handleWorkingCopyModified(clientCopy);
            }
        });
        ToolBar toolBar = new ToolBar(pageArea, 0);
        ToolItem item = new ToolItem(toolBar, 4);
        item.setImage(ClientConfigurationUtil.getConfigImage("logicsystem.gif"));
        item.setToolTipText("Choose another...");
        AbstractWorkingCopyLogicalSystem[] systems = ConfigurationWorkingCopyProvider.getInstance().getLogicalSystemWorkingCopies();
        item.addSelectionListener((SelectionListener)new DropDownSelectionListener(pageArea, clientCopy, systemText, systems));
        toolBar.setLayoutData((Object)new GridData(128));
        Button bnView = this.createIconButton(pageArea, "view.gif", "View selected Logical System", 128, true);
        bnView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.getSource() instanceof Button) {
                    ClientConfigurationDialog.this.clearMessageArea();
                    if (!ClientConfigurationDialog.this.navigateInTree(ClientConfigurationDialog.this.m_configTreeViewer, systemText.getData())) {
                        ClientConfigurationDialog.this.setErrorMessage("Could not find the logical system named \"" + systemText.getText() + "\".");
                    }
                }
            }
        });
        Label spacer = new Label(pageArea, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        spacer.setLayoutData((Object)gridData);
        Label lbRoot = new Label(pageArea, 0);
        lbRoot.setText("Local Root:");
        lbRoot.setLayoutData((Object)new GridData(1));
        final Text txRoot = new Text(pageArea, 2060);
        txRoot.setText(clientCopy.getLocalRoot() != null ? clientCopy.getLocalRoot() : "<please specify>");
        txRoot.setToolTipText("Use Change button to modify");
        txRoot.setLayoutData((Object)new GridData(768));
        txRoot.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClientConfigurationDialog.this.clearMessageArea();
                clientCopy.modifyLocalRoot(txRoot.getText());
                ClientConfigurationDialog.this.handleWorkingCopyModified(clientCopy);
            }
        });
        Button bnBrowseRoot = this.createIconButton(pageArea, "edit.gif", "Change Local Root...", 32, true);
        bnBrowseRoot.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path = ClientConfigurationDialog.this.openChangeLocalPathDialog("Change Local Root", "Choose the absolute local root for the client \"" + clientCopy.getId() + "\"", txRoot.getText());
                if (path != null) {
                    path = PathUtilities.assureTrailingSeparator((String)path, (boolean)true);
                    txRoot.setText(path);
                }
            }
        });
        spacer = new Label(pageArea, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        spacer.setLayoutData((Object)gridData);
        Label lbFilter = new Label(pageArea, 0);
        lbFilter.setText("Client Filter:");
        lbFilter.setLayoutData((Object)new GridData(1));
        final Text txFilter = new Text(pageArea, 2052);
        txFilter.setText(clientCopy.getClientFilter());
        txFilter.setLayoutData((Object)new GridData(768));
        txFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClientConfigurationDialog.this.clearMessageArea();
                clientCopy.modifyClientFilter(txFilter.getText());
                ClientConfigurationDialog.this.handleWorkingCopyModified(clientCopy);
            }
        });
        Button bnSuggest = this.createIconButton(pageArea, "suggestion.gif", "Get Suggestion", 32, true);
        bnSuggest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String currentValue;
                String suggestion = System.getProperty("user.name");
                if (!(suggestion = suggestion + ":" + ClientConfigurationUtil.getHostName()).equals(currentValue = txFilter.getText().trim())) {
                    txFilter.setText(suggestion);
                }
            }
        });
        return pageArea;
    }

    private Control createClientTabMountPoints(Composite parent, AbstractWorkingCopyClient clientCopy) {
        Composite pageArea = new Composite(parent, 0);
        GridLayout pageAreaLayout = new GridLayout();
        pageAreaLayout.numColumns = 3;
        pageAreaLayout.marginHeight = 20;
        pageAreaLayout.marginWidth = 10;
        pageArea.setLayout((Layout)pageAreaLayout);
        Label lbRoot = new Label(pageArea, 0);
        lbRoot.setText("Local Root:");
        lbRoot.setLayoutData((Object)new GridData(1));
        final Text txRoot = new Text(pageArea, 2060);
        txRoot.setText(clientCopy.getLocalRoot() != null ? clientCopy.getLocalRoot() : "<please specify>");
        txRoot.setLayoutData((Object)new GridData(768));
        final TreeViewer mpTreeViewer = new TreeViewer(pageArea, 2816);
        mpTreeViewer.setContentProvider((IContentProvider)new MountPointTreeContentProvider());
        mpTreeViewer.setLabelProvider((IBaseLabelProvider)new MountPointTreeLabelProvider());
        mpTreeViewer.setInput(clientCopy.getOriginal());
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 4;
        mpTreeViewer.getTree().setLayoutData((Object)gridData);
        mpTreeViewer.expandAll();
        this.addTreeDoubleClickListener(mpTreeViewer);
        final Button bnView = this.createIconButton(pageArea, "view.gif", "View selected Repository Server", 2, false);
        bnView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Object selected;
                if (mpTreeViewer.getSelection() instanceof IStructuredSelection && (selected = ((IStructuredSelection)mpTreeViewer.getSelection()).getFirstElement()) instanceof IConnectionTemplate && !ClientConfigurationDialog.this.navigateInTree(ClientConfigurationDialog.this.m_configTreeViewer, selected)) {
                    ClientConfigurationDialog.this.setErrorMessage("Could not find the repository server with URL \"" + ((IConnectionTemplate)selected).getUrl() + "\".");
                }
            }
        });
        final Button bnAdd = this.createIconButton(pageArea, "add.gif", "Create...", 2, false);
        bnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Object selected;
                if (mpTreeViewer.getSelection() instanceof IStructuredSelection && (selected = ((IStructuredSelection)mpTreeViewer.getSelection()).getFirstElement()) instanceof IConnectionTemplate) {
                    String serverUrl = "/";
                    String localRoot = txRoot.getText();
                    String mpRemotePath = ClientConfigurationDialog.this.openChangeRemotePathDialog("Add Mount Point (1/2) - Remote Path", ClientConfigurationDialog.MSG_SPEC_MPPATH_REMOTE, serverUrl);
                    String mpLocalPath = ClientConfigurationDialog.this.openChangeLocalPathDialog("Add Mount Point (2/2) - Local Path", ClientConfigurationDialog.MSG_SPEC_MPPATH_LOCAL, localRoot);
                    if (mpRemotePath == null || !mpRemotePath.equals(serverUrl)) {
                        // empty if block
                    }
                    if (mpLocalPath == null || !mpLocalPath.equals(localRoot)) {
                        // empty if block
                    }
                }
            }
        });
        final Button bnChangeMountPoint = this.createIconButton(pageArea, "edit.gif", "Change...", 2, false);
        bnChangeMountPoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void widgetSelected(SelectionEvent evt) {
                String newPath;
                if (!(mpTreeViewer.getSelection() instanceof IStructuredSelection)) return;
                Object selected = ((IStructuredSelection)mpTreeViewer.getSelection()).getFirstElement();
                if (selected instanceof IMountPoint) {
                    String oldLocalPath;
                    String oldRemotePath = ((IMountPoint)selected).getRelativeRemoteRoot();
                    if (oldRemotePath.equals("ws/")) {
                        oldRemotePath = "/";
                    }
                    if ((oldLocalPath = ((IMountPoint)selected).getRelativeLocalRoot()).equals("\"\"")) {
                        oldLocalPath = "";
                    }
                    String newRemotePath = ClientConfigurationDialog.this.openChangeRemotePathDialog("Change Mount Point (1/2) - Change Remote Path", ClientConfigurationDialog.MSG_SPEC_MPPATH_REMOTE, oldRemotePath);
                    String newLocalPath = ClientConfigurationDialog.this.openChangeLocalPathDialog("Change Mount Point (2/2) - Change Local Path", ClientConfigurationDialog.MSG_SPEC_MPPATH_LOCAL, txRoot.getText() + oldLocalPath);
                    if (newRemotePath == null || !newRemotePath.equals(oldRemotePath)) {
                        // empty if block
                    }
                    if (newLocalPath != null && newLocalPath.equals(oldLocalPath)) return;
                }
                if (selected instanceof MountPointRemotePath) {
                    String newPath2;
                    String remotePath = ((MountPointRemotePath)selected).path;
                    if (remotePath.equals("ws/")) {
                        remotePath = "/";
                    }
                    if ((newPath2 = ClientConfigurationDialog.this.openChangeRemotePathDialog(ClientConfigurationDialog.TIT_EDIT_MPPATH_REMOTE, ClientConfigurationDialog.MSG_SPEC_MPPATH_REMOTE, remotePath)) != null && newPath2.equals(remotePath)) return;
                }
                if (!(selected instanceof MountPointLocalPath)) return;
                String localPath = ((MountPointLocalPath)selected).path;
                if (localPath.equals("\"\"")) {
                    localPath = "";
                }
                if ((newPath = ClientConfigurationDialog.this.openChangeLocalPathDialog(ClientConfigurationDialog.TIT_EDIT_MPPTH_LOCAL, ClientConfigurationDialog.MSG_SPEC_MPPATH_LOCAL, txRoot.getText() + localPath)) != null && newPath.equals(localPath)) return;
            }
        });
        final Button bnDelete = this.createIconButton(pageArea, "delete.gif", BUTTON_LABEL_DELETE, 2, false);
        bnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                Object selected;
                if (!(mpTreeViewer.getSelection() instanceof IStructuredSelection) || (selected = ((IStructuredSelection)mpTreeViewer.getSelection()).getFirstElement()) instanceof IMountPoint) {
                    // empty if block
                }
            }
        });
        mpTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (selected instanceof IConnectionTemplate) {
                        bnView.setEnabled(true);
                        bnAdd.setEnabled(true);
                        bnChangeMountPoint.setEnabled(false);
                        bnDelete.setEnabled(false);
                    } else if (selected instanceof IMountPoint) {
                        bnView.setEnabled(false);
                        bnAdd.setEnabled(false);
                        bnChangeMountPoint.setEnabled(true);
                        bnDelete.setEnabled(true);
                    } else if (selected instanceof MountPointRemotePath || selected instanceof MountPointLocalPath) {
                        bnView.setEnabled(false);
                        bnAdd.setEnabled(false);
                        bnChangeMountPoint.setEnabled(true);
                        bnDelete.setEnabled(false);
                    }
                }
            }
        });
        return pageArea;
    }

    private Control createSystemTabGeneral(Composite parent, final AbstractWorkingCopyLogicalSystem systemCopy) {
        Composite pageArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 20;
        gridLayout.marginWidth = 10;
        pageArea.setLayout((Layout)gridLayout);
        Composite aboveArea = new Composite(pageArea, 0);
        gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        aboveArea.setLayout((Layout)gridLayout);
        aboveArea.setLayoutData((Object)new GridData(768));
        Label systemLabel = new Label(aboveArea, 0);
        systemLabel.setText("Repository Server(s):");
        systemLabel.setLayoutData((Object)new GridData(1));
        final Combo templateCombo = new Combo(aboveArea, 12);
        templateCombo.setToolTipText("Use dropdown button to chnage");
        templateCombo.setLayoutData((Object)new GridData(768));
        AbstractWorkingCopyConnectionTemplate[] templateCopies = systemCopy.getConnectionTemplates();
        if (templateCopies != null && templateCopies.length > 0) {
            String[] labels = new String[templateCopies.length];
            int i = 0;
            while (i < templateCopies.length) {
                labels[i] = templateCopies[i].getId();
                templateCombo.setData(labels[i], (Object)templateCopies[i]);
                ++i;
            }
            templateCombo.setItems(labels);
        } else {
            templateCombo.setItems(new String[]{"<please specify>"});
        }
        templateCombo.select(0);
        ToolBar toolBar = new ToolBar(aboveArea, 0);
        ToolItem item = new ToolItem(toolBar, 4);
        item.setImage(ClientConfigurationUtil.getConfigImage("reposerver.gif"));
        item.setToolTipText("Add or Remove Server...");
        AbstractWorkingCopyConnectionTemplate[] allTemplateCopies = ConfigurationWorkingCopyProvider.getInstance().getConnectionTemplateWorkingCopies();
        item.addSelectionListener((SelectionListener)new DropDownSelectionListener(aboveArea, templateCombo, allTemplateCopies));
        toolBar.setLayoutData((Object)new GridData(128));
        final Button bnViewServer = this.createIconButton(aboveArea, "view.gif", "View selected Repository Server", 128, true);
        bnViewServer.setEnabled(templateCombo.getData(templateCombo.getText()) != null);
        bnViewServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AbstractWorkingCopyConnectionTemplate templateCopy = (AbstractWorkingCopyConnectionTemplate)templateCombo.getData(templateCombo.getText());
                if (!ClientConfigurationDialog.this.navigateInTree(ClientConfigurationDialog.this.m_configTreeViewer, templateCopy)) {
                    ClientConfigurationDialog.this.setErrorMessage("Could not find the repository server with URL \"" + templateCopy.getId() + "\".");
                }
            }
        });
        templateCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                bnViewServer.setEnabled(!templateCombo.getText().equals("<please specify>"));
                ArrayList<Object> newTemplates = new ArrayList<Object>();
                String[] items = templateCombo.getItems();
                int i = 0;
                while (i < items.length) {
                    Object templateCopy = templateCombo.getData(items[i]);
                    if (templateCopy != null) {
                        newTemplates.add(templateCopy);
                    }
                    ++i;
                }
                systemCopy.modifyConnectionTemplates(newTemplates);
                ClientConfigurationDialog.this.handleWorkingCopyModified(systemCopy);
            }
        });
        Composite bellowArea = new Composite(pageArea, 0);
        bellowArea.setLayout((Layout)new GridLayout());
        bellowArea.setLayoutData((Object)new GridData(1040));
        Label spacer = new Label(bellowArea, 0);
        GridData gridData = new GridData(1040);
        spacer.setLayoutData((Object)gridData);
        Group usageGroup = new Group(pageArea, 0);
        usageGroup.setText("Usage");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        usageGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        usageGroup.setLayoutData((Object)gridData);
        Label clientLabel = new Label((Composite)usageGroup, 0);
        clientLabel.setText("Used by Client:");
        clientLabel.setLayoutData((Object)new GridData(1));
        final Text clientText = new Text((Composite)usageGroup, 2060);
        gridData = new GridData(768);
        clientText.setLayoutData((Object)gridData);
        AbstractWorkingCopyClient[] clientCopies = ConfigurationWorkingCopyProvider.getInstance().getClientWorkingCopies();
        int i = 0;
        while (i < clientCopies.length) {
            if (systemCopy.equals(clientCopies[i].getLogicalSystem())) {
                clientText.setText(clientCopies[i].getId());
                clientText.setData((Object)clientCopies[i]);
                break;
            }
            ++i;
        }
        Button bnViewClient = this.createIconButton((Composite)usageGroup, "view.gif", "View selected Client", 128, true);
        bnViewClient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AbstractWorkingCopyClient clientCopy = (AbstractWorkingCopyClient)clientText.getData();
                if (clientCopy != null) {
                    if (!ClientConfigurationDialog.this.navigateInTree(ClientConfigurationDialog.this.m_configTreeViewer, clientCopy)) {
                        ClientConfigurationDialog.this.setErrorMessage("Could not find the client named \"" + clientCopy.getId() + "\".");
                    }
                } else {
                    ClientConfigurationDialog.this.setErrorMessage("Internal error: client is <null>");
                }
            }
        });
        if (clientText.getText() == null || clientText.getText().equals("")) {
            clientText.setText(VALUE_EMPTY);
            bnViewClient.setEnabled(false);
        }
        return pageArea;
    }

    private Control createSystemTabFilter(Composite parent, AbstractWorkingCopyLogicalSystem systemCopy) {
        ILogicalSystem system = (ILogicalSystem)systemCopy.getOriginal();
        Composite pageArea = new Composite(parent, 0);
        GridLayout pageAreaLayout = new GridLayout(2, false);
        pageAreaLayout.marginHeight = 20;
        pageAreaLayout.marginWidth = 10;
        pageArea.setLayout((Layout)pageAreaLayout);
        final TreeViewer filterTreeViewer = new TreeViewer(pageArea, 2816);
        filterTreeViewer.setContentProvider((IContentProvider)new FilterTreeContentProvider());
        filterTreeViewer.setLabelProvider((IBaseLabelProvider)new FilterTreeLabelProvider());
        filterTreeViewer.setSorter((ViewerSorter)new AscendingElementLabelSorter());
        filterTreeViewer.setInput((Object)system);
        GridData gdata = new GridData(1808);
        gdata.verticalSpan = 4;
        filterTreeViewer.getTree().setLayoutData((Object)gdata);
        filterTreeViewer.expandAll();
        this.addTreeDoubleClickListener(filterTreeViewer);
        final Button bnView = this.createIconButton(pageArea, "view.gif", "View selected Repository Server", 2, false);
        bnView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String serverUrl;
                Object selected;
                if (filterTreeViewer.getSelection() instanceof IStructuredSelection && (selected = ((IStructuredSelection)filterTreeViewer.getSelection()).getFirstElement()) instanceof IRepositoryServer && (serverUrl = ((FilterTreeLabelProvider)filterTreeViewer.getLabelProvider()).getText((IRepositoryServer)selected)) != null) {
                    IConnectionTemplate template = ClientConfigurationUtil.getConnectionTemplate(serverUrl);
                    if (!ClientConfigurationDialog.this.navigateInTree(ClientConfigurationDialog.this.m_configTreeViewer, template)) {
                        ClientConfigurationDialog.this.setErrorMessage("Could not find the repository server with URL \"" + serverUrl + "\".");
                    }
                }
            }
        });
        final Button bnAdd = this.createIconButton(pageArea, "add.gif", "Add...", 2, false);
        bnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
            }
        });
        final Button bnChange = this.createIconButton(pageArea, "edit.gif", "Change...", 2, false);
        bnChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
            }
        });
        final Button bnDelete = this.createIconButton(pageArea, "delete.gif", BUTTON_LABEL_DELETE, 2, false);
        bnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
            }
        });
        filterTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (selected instanceof IRepositoryServer) {
                        bnView.setEnabled(true);
                        bnAdd.setEnabled(false);
                        bnChange.setEnabled(false);
                        bnDelete.setEnabled(false);
                    } else if (selected instanceof IncludeFilter[] || selected instanceof ExcludeFilter[] || selected instanceof ReadOnlyFilter[]) {
                        bnView.setEnabled(false);
                        bnAdd.setEnabled(true);
                        bnChange.setEnabled(false);
                        bnDelete.setEnabled(false);
                    } else if (selected instanceof IncludeFilter || selected instanceof ExcludeFilter || selected instanceof ReadOnlyFilter) {
                        bnView.setEnabled(false);
                        bnAdd.setEnabled(false);
                        bnChange.setEnabled(true);
                        bnDelete.setEnabled(true);
                    }
                }
            }
        });
        return pageArea;
    }

    private Control createServerTabGeneral(Composite parent, AbstractWorkingCopyConnectionTemplate templateCopy) {
        final IConnectionTemplate template = (IConnectionTemplate)templateCopy.getOriginal();
        Composite pageArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 20;
        gridLayout.marginWidth = 10;
        pageArea.setLayout((Layout)gridLayout);
        Group gpInfo = new Group(pageArea, 0);
        gpInfo.setText("Server Information");
        gpInfo.setLayout((Layout)new GridLayout(5, false));
        gpInfo.setLayoutData((Object)new GridData(768));
        new Label((Composite)gpInfo, 0).setText("Protocol:");
        final Combo cbProtocol = new Combo((Composite)gpInfo, 12);
        cbProtocol.setLayoutData((Object)new GridData(768));
        cbProtocol.setItems(new String[]{PROTOCOL_HTTP, PROTOCOL_HTTPS});
        Label spacer = new Label((Composite)gpInfo, 2);
        GridData gridData = new GridData(1040);
        gridData.verticalSpan = 4;
        gridData.widthHint = 25;
        spacer.setLayoutData((Object)gridData);
        Button cxUsingProxy = new Button((Composite)gpInfo, 32);
        cxUsingProxy.setText("Use Proxy");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        cxUsingProxy.setLayoutData((Object)gridData);
        cxUsingProxy.setEnabled(false);
        new Label((Composite)gpInfo, 0).setText("Host:");
        final Text txHost = new Text((Composite)gpInfo, 2052);
        txHost.setLayoutData((Object)new GridData(768));
        new Label((Composite)gpInfo, 0).setText("Host:");
        final Text txProxyHost = new Text((Composite)gpInfo, 2052);
        txProxyHost.setLayoutData((Object)new GridData(768));
        new Label((Composite)gpInfo, 0).setText("Port:");
        final Text txPort = new Text((Composite)gpInfo, 2052);
        txPort.setLayoutData((Object)new GridData(768));
        new Label((Composite)gpInfo, 0).setText("Port:");
        final Text txProxyPort = new Text((Composite)gpInfo, 2052);
        txProxyPort.setLayoutData((Object)new GridData(768));
        cxUsingProxy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (evt.getSource() instanceof Button) {
                    boolean checked = ((Button)evt.getSource()).getSelection();
                    txProxyHost.setEditable(checked);
                    txProxyPort.setEditable(checked);
                }
            }
        });
        new Label((Composite)gpInfo, 0).setText("Base Path:");
        final Text txBasePath = new Text((Composite)gpInfo, 2052);
        txBasePath.setLayoutData((Object)new GridData(768));
        new Label(pageArea, 0).setLayoutData((Object)new GridData(768));
        Group gpUser = new Group(pageArea, 0);
        gpUser.setText("Authorization");
        gpUser.setLayout((Layout)new GridLayout(3, false));
        gpUser.setLayoutData((Object)new GridData(768));
        new Label((Composite)gpUser, 0).setText("User Name:");
        Text txUserName = new Text((Composite)gpUser, 2052);
        txUserName.setLayoutData((Object)new GridData(768));
        Button bnChange = this.createIconButton((Composite)gpUser, "change_pwd.gif", "Change Password", 3, true);
        new Label(pageArea, 0).setLayoutData((Object)new GridData(1040));
        Group gpUsage = new Group(pageArea, 0);
        gpUsage.setText("Usage");
        gpUsage.setLayout((Layout)new GridLayout(3, false));
        gpUsage.setLayoutData((Object)new GridData(768));
        new Label((Composite)gpUsage, 0).setText("Used by Logical System:");
        final Combo cbSystems = new Combo((Composite)gpUsage, 12);
        cbSystems.setLayoutData((Object)new GridData(768));
        Button bnViewSystem = this.createIconButton((Composite)gpUsage, "view.gif", "View selected Logical System", 3, true);
        bnViewSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ILogicalSystem system = (ILogicalSystem)cbSystems.getData(cbSystems.getText());
                if (!ClientConfigurationDialog.this.navigateInTree(ClientConfigurationDialog.this.m_configTreeViewer, system)) {
                    ClientConfigurationDialog.this.setErrorMessage("Could not find the logical system named \"" + system.getName() + "\".");
                }
            }
        });
        String protocol = template.getProtocol().toString();
        if (protocol.equals(PROTOCOL_HTTP)) {
            cbProtocol.select(0);
        } else if (protocol.equals(PROTOCOL_HTTPS)) {
            cbProtocol.select(1);
        } else {
            cbProtocol.add(PROTOCOL_NOT_SUPPORTED);
            cbProtocol.select(2);
            this.setErrorMessage("Please specify the protocol for server connection!");
        }
        txHost.setText(template.getHost());
        txPort.setText("" + template.getPort());
        String basePath = template.getBasePath();
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        txBasePath.setText(basePath);
        if (template.getProxyHost() != null) {
            txProxyHost.setText(template.getProxyHost());
        }
        txProxyPort.setText("" + template.getProxyPort());
        cbProtocol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientConfigurationDialog.this.handleServerUrlChanged(cbProtocol, txHost, txPort, txBasePath);
            }
        });
        txHost.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClientConfigurationDialog.this.handleServerUrlChanged(cbProtocol, txHost, txPort, txBasePath);
            }
        });
        txPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClientConfigurationDialog.this.handleServerUrlChanged(cbProtocol, txHost, txPort, txBasePath);
            }
        });
        txBasePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClientConfigurationDialog.this.handleServerUrlChanged(cbProtocol, txHost, txPort, txBasePath);
            }
        });
        boolean checked = template.isUsingProxy();
        cxUsingProxy.setSelection(checked);
        txProxyHost.setEditable(checked);
        txProxyPort.setEditable(checked);
        txUserName.setText(template.getSessionContext().getUser());
        txUserName.setEditable(false);
        bnChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                new EditUserDialog(ClientConfigurationDialog.this.getShell(), template).open();
            }
        });
        HashSet<ILogicalSystem> systemsSet = new HashSet<ILogicalSystem>();
        Iterator systems = this.m_clientConfiguration.logicalSystems();
        block0: while (systems.hasNext()) {
            ILogicalSystem system = (ILogicalSystem)systems.next();
            Iterator servers = system.repositoryServers();
            while (servers.hasNext()) {
                IRepositoryServer server = (IRepositoryServer)servers.next();
                if (!server.getUrl().equals(template.getUrl())) continue;
                systemsSet.add(system);
                continue block0;
            }
        }
        Iterator iter = systemsSet.iterator();
        while (iter.hasNext()) {
            ILogicalSystem system = (ILogicalSystem)iter.next();
            cbSystems.add(system.getName());
            cbSystems.setData(system.getName(), (Object)system);
        }
        cbSystems.select(0);
        if (cbSystems.getItemCount() < 1) {
            cbSystems.setText(VALUE_EMPTY);
            bnViewSystem.setEnabled(false);
        }
        return pageArea;
    }

    private void handleServerUrlChanged(Combo cbProtocol, Text txHost, Text txPort, Text txBasePath) {
        this.clearMessageArea();
        this.m_buttonApply.setEnabled(true);
        String protocol = cbProtocol.getText();
        if (protocol.equals(PROTOCOL_NOT_SUPPORTED)) {
            this.setErrorMessage("The protocol for server connection is not yet specified!");
            this.m_buttonApply.setEnabled(false);
            return;
        }
        String host = txHost.getText().trim();
        if (host.equals("")) {
            this.setErrorMessage("Server host could not be empty!");
            this.m_buttonApply.setEnabled(false);
            return;
        }
        String port = txPort.getText().trim();
        if (port.equals("")) {
            this.setErrorMessage("Server port could not be empty!");
            this.m_buttonApply.setEnabled(false);
            return;
        }
        String basePath = txBasePath.getText().trim();
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        if (basePath.equals("")) {
            this.setErrorMessage("Base path could not be empty!");
            this.m_buttonApply.setEnabled(false);
            return;
        }
        String url = protocol + "://" + host + ":" + port + "/" + basePath + "/";
        this.m_txName.setText(url);
    }

    private Control createServerTabSetting(Composite parent, AbstractWorkingCopyConnectionTemplate templateCopy) {
        final IConnectionTemplate template = (IConnectionTemplate)templateCopy.getOriginal();
        Composite pageArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 20;
        gridLayout.marginWidth = 10;
        pageArea.setLayout((Layout)gridLayout);
        Composite fieldsArea = new Composite(pageArea, 0);
        fieldsArea.setLayout((Layout)new GridLayout(2, false));
        fieldsArea.setLayoutData((Object)new GridData(768));
        new Label(fieldsArea, 0).setText("Connection Timeout (ms):");
        final Text txConnectTO = new Text(fieldsArea, 2052);
        txConnectTO.setText("" + template.getSocketConnectTimeout());
        txConnectTO.setLayoutData((Object)new GridData(768));
        new Label(fieldsArea, 0).setText("Read Timeout (ms):");
        Text txReadTO = new Text(fieldsArea, 2052);
        txReadTO.setText("" + template.getSocketReadTimeout());
        txReadTO.setLayoutData((Object)new GridData(768));
        new Label(fieldsArea, 0).setText("Expiration Timeout (ms):");
        final Text txExpireTO = new Text(fieldsArea, 2052);
        txExpireTO.setText("" + template.getSocketExpirationTimeout());
        txExpireTO.setLayoutData((Object)new GridData(768));
        new Label(fieldsArea, 0).setText("Repeat on Timeout:");
        Combo cbRepeatOnTO = this.createStandardFalseTrueCombo(fieldsArea);
        cbRepeatOnTO.setLayoutData((Object)new GridData(768));
        if (template.getRepeatOnTimeout()) {
            cbRepeatOnTO.select(1);
        } else {
            cbRepeatOnTO.select(0);
        }
        new Label(fieldsArea, 0).setText("Repetitions:");
        final Text txRepetitions = new Text(fieldsArea, 2052);
        txRepetitions.setText("" + template.getRequestRepetitions());
        txRepetitions.setLayoutData((Object)new GridData(768));
        new Label(fieldsArea, 0).setText("Send Buffer Size:");
        Text txSendBuffer = new Text(fieldsArea, 2052);
        String sendBufferSize = "" + template.getSendBufferSize();
        if (sendBufferSize.equals("-1")) {
            sendBufferSize = "<default>";
        }
        txSendBuffer.setText(sendBufferSize);
        txSendBuffer.setEditable(false);
        txSendBuffer.setLayoutData((Object)new GridData(768));
        new Label(fieldsArea, 0).setText("Receive Buffer Size:");
        Text txReceiveBuffer = new Text(fieldsArea, 2052);
        String receiveBufferSize = "" + template.getReceiveBufferSize();
        if (receiveBufferSize.equals("-1")) {
            receiveBufferSize = "<default>";
        }
        txReceiveBuffer.setText(receiveBufferSize);
        txReceiveBuffer.setEditable(false);
        txReceiveBuffer.setLayoutData((Object)new GridData(768));
        new Label(fieldsArea, 0).setText("Compress Request/Response:");
        Combo cbCompress = this.createStandardFalseTrueCombo(fieldsArea);
        cbCompress.setLayoutData((Object)new GridData(768));
        if (template.isCompressionEnabled()) {
            cbCompress.select(1);
        } else {
            cbCompress.select(0);
        }
        Label spacer = new Label(fieldsArea, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        spacer.setLayoutData((Object)gridData);
        Composite buttonArea = new Composite(pageArea, 0);
        buttonArea.setLayout((Layout)new GridLayout(1, false));
        buttonArea.setLayoutData((Object)new GridData(1168));
        Button bnRestore = this.createPushButton(buttonArea, "Restore Default", null);
        bnRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                txConnectTO.setText("" + 300000);
                txExpireTO.setText("" + 10000);
                txRepetitions.setText("" + 1);
            }
        });
        return pageArea;
    }

    private Combo createStandardFalseTrueCombo(Composite parent) {
        Combo combo = new Combo(parent, 12);
        combo.setItems(new String[]{"false", "true"});
        return combo;
    }

    private Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return Display.getDefault();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1026, "Close", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1026) {
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private IConfigurationWorkingCopy handleNewPressed() {
        this.clearMessageArea();
        IConfigurationWorkingCopy dummy = null;
        if (this.m_currentSelection instanceof AbstractWorkingCopyClient[] || this.m_currentSelection instanceof AbstractWorkingCopyClient) {
            dummy = ConfigurationWorkingCopyProvider.getInstance().createNewClient();
            this.m_configTreeViewer.refresh();
            this.m_configTreeViewer.setSelection((ISelection)new StructuredSelection((Object)dummy), true);
            this.setMessage("For a new client you have to specify Client Name, Absolute Local Root and Logical System.", 1);
        } else if (this.m_currentSelection instanceof AbstractWorkingCopyLogicalSystem[] || this.m_currentSelection instanceof AbstractWorkingCopyLogicalSystem) {
            dummy = ConfigurationWorkingCopyProvider.getInstance().createNewLogicalSystem();
            this.m_configTreeViewer.refresh();
            this.m_configTreeViewer.setSelection((ISelection)new StructuredSelection((Object)dummy), true);
            this.setMessage("For a new logical system you have to specify Logical System Name and Repository Server.", 1);
        } else if (this.m_currentSelection instanceof IConnectionTemplate[]) {
            this.setMessage("For a new repository server you have to specify Server URL, User Name and Initial Password.", 1);
        }
        return dummy;
    }

    private void handleDeletePressed() {
        if (!(this.m_currentSelection instanceof IConfigurationWorkingCopy)) {
            return;
        }
        this.clearMessageArea();
        IConfigurationWorkingCopy toDelete = (IConfigurationWorkingCopy)this.m_currentSelection;
        IConfigurationWorkingCopy usage = ConfigurationWorkingCopyProvider.getInstance().usedByOtherConfigurationElement(toDelete);
        if (usage != null) {
            if (toDelete instanceof AbstractWorkingCopyLogicalSystem) {
                this.setErrorMessage("Deletion failed: Logical system \"" + toDelete.getId() + "\" is still used by client \"" + usage.getId());
            } else if (toDelete instanceof AbstractWorkingCopyConnectionTemplate) {
                this.setErrorMessage("Deletion failed: Server \"" + toDelete.getId() + "\" is still used by logical system \"" + usage.getId());
            }
            return;
        }
        if (!this.openConfirmDialogDeleteConfigElement(toDelete)) {
            return;
        }
        try {
            ConfigurationWorkingCopyProvider.getInstance().deleteWorkingCopy(toDelete);
            this.m_configTreeViewer.refresh();
            this.m_buttonNew.setEnabled(false);
        }
        catch (ConfigurationEditorException x) {
            this.m_configTreeViewer.setSelection((ISelection)new StructuredSelection((Object)x.getSource()), true);
            this.setErrorMessage(((Throwable)((Object)x)).getMessage());
        }
    }

    private boolean handleClosePressed() {
        this.clearMessageArea();
        int returnCode = 0;
        if (ConfigurationWorkingCopyProvider.getInstance().hasDirtyWorkingCopy()) {
            MessageDialog warnDialog = new MessageDialog(this.getShell(), "Save Changes?", null, "The configuration has still unsaved changes.\n\nWould you like to save them?", 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            returnCode = warnDialog.open();
        }
        try {
            if (returnCode == 0) {
                ConfigurationWorkingCopyProvider.getInstance().saveConfiguration(true);
            } else if (returnCode == 1) {
                ConfigurationWorkingCopyProvider.getInstance().saveConfiguration(false);
            } else {
                return false;
            }
            ConfigurationWorkingCopyProvider.getInstance().reset();
        }
        catch (ConfigurationEditorException x) {
            this.m_configTreeViewer.setSelection((ISelection)new StructuredSelection((Object)x.getSource()), true);
            this.setErrorMessage(((Throwable)((Object)x)).getMessage());
            return false;
        }
        return true;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeBounds();
        this.initializeSashForm();
        this.ensureSelectionAreaWidth();
        IClient activeClient = Configuration.getConfiguration().getActiveClient();
        if (activeClient != null) {
            this.m_configTreeViewer.setSelection((ISelection)new StructuredSelection((Object)ConfigurationWorkingCopyProvider.getInstance().getWorkingCopy(activeClient)), true);
        }
        this.setMessage(this.m_clientConfiguration.getConfigFolder().getAbsolutePath());
        return contents;
    }

    private void initializeSashForm() {
        Point sashWeightPoint;
        int[] sashWeights = DEFAULT_SASH_WEIGHTS;
        String sashWeightString = this.getPreferenceStore().getString(CLIENT_CONFIGURATION_DIALOG_SASH_WEIGHTS);
        if (sashWeightString.length() > 0 && (sashWeightPoint = LayoutHelper.parseCoordinates(sashWeightString)) != null) {
            sashWeights[0] = sashWeightPoint.x;
            sashWeights[1] = sashWeightPoint.y;
        }
        this.m_sashForm.setWeights(sashWeights);
    }

    private void ensureSelectionAreaWidth() {
        Button newButton = this.m_buttonNew.getButton();
        Button deleteButton = this.m_buttonDelete.getButton();
        int requiredWidth = newButton.getBounds().width + deleteButton.getBounds().width;
        int marginWidth = ((GridLayout)this.m_selectionArea.getLayout()).marginWidth;
        int horizontalSpacing = ((GridLayout)this.m_selectionArea.getLayout()).horizontalSpacing;
        int currentWidth = this.m_selectionArea.getBounds().width;
        if ((requiredWidth += 2 * marginWidth + horizontalSpacing) > currentWidth) {
            int[] newSashWeights = new int[]{requiredWidth, this.m_editArea.getBounds().width};
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + (requiredWidth - currentWidth), shellSize.y);
            this.m_sashForm.setWeights(newSashWeights);
        }
    }

    private void setShellSize(int width, int height) {
        Rectangle bounds = this.getDisplay().getBounds();
        this.getShell().setSize(Math.min(width, bounds.width), Math.min(height, bounds.height));
    }

    private int[] calculateNewSashWeights(int widthIncrease) {
        int[] newWeights = new int[]{this.m_selectionArea.getBounds().width, this.m_editArea.getBounds().width + widthIncrease};
        return newWeights;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point locationPoint;
        String locationString = this.getPreferenceStore().getString(CLIENT_CONFIGURATION_DIALOG_LOCATION);
        if (locationString.length() > 0 && (locationPoint = LayoutHelper.parseCoordinates(locationString)) != null) {
            return locationPoint;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        Point sizePoint;
        String sizeString = this.getPreferenceStore().getString(CLIENT_CONFIGURATION_DIALOG_SIZE);
        if (sizeString.length() > 0 && (sizePoint = LayoutHelper.parseCoordinates(sizeString)) != null) {
            return sizePoint;
        }
        return DEFAULT_INITIAL_DIALOG_SIZE;
    }

    public boolean close() {
        if (this.handleClosePressed()) {
            this.persistShellGeometry();
            return super.close();
        }
        return false;
    }

    private void persistShellGeometry() {
        Point shellLocation = this.getShell().getLocation();
        Point shellSize = this.getShell().getSize();
        int[] sashWeights = this.m_sashForm.getWeights();
        String locationString = LayoutHelper.serializeCoords(shellLocation);
        String sizeString = LayoutHelper.serializeCoords(shellSize);
        String sashWeightString = LayoutHelper.serializeCoords(new Point(sashWeights[0], sashWeights[1]));
        this.getPreferenceStore().setValue(CLIENT_CONFIGURATION_DIALOG_LOCATION, locationString);
        this.getPreferenceStore().setValue(CLIENT_CONFIGURATION_DIALOG_SIZE, sizeString);
        this.getPreferenceStore().setValue(CLIENT_CONFIGURATION_DIALOG_SASH_WEIGHTS, sashWeightString);
    }

    private IPreferenceStore getPreferenceStore() {
        return BluebirdPlugin.getDefault().getPreferenceStore();
    }

    private Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gdata = new GridData();
        button.setLayoutData((Object)gdata);
        this.setButtonDimensionHint(button);
        return button;
    }

    private void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gdata = button.getLayoutData();
        if (gdata instanceof GridData) {
            ((GridData)gdata).heightHint = LayoutHelper.getButtonHeigthHint(button);
            ((GridData)gdata).widthHint = LayoutHelper.getButtonWidthHint(button);
            ((GridData)gdata).horizontalAlignment = 4;
        }
    }

    private Button createIconButton(Composite parent, String imageFileName, String tooltip, int gridDataValue, boolean enabled) {
        Button iconButton = new Button(parent, 8);
        iconButton.setImage(ClientConfigurationUtil.getConfigImage(imageFileName));
        iconButton.setToolTipText(tooltip);
        if (!enabled) {
            iconButton.setEnabled(enabled);
        }
        GridData gridData = new GridData(gridDataValue);
        gridData.heightHint = ICON_BUTTON_HEIGHT - 2;
        gridData.widthHint = ICON_BUTTON_HEIGHT;
        iconButton.setLayoutData((Object)gridData);
        return iconButton;
    }

    private void handleNameFiledModified(TypedEvent e) {
        if (!(e.getSource() instanceof Text)) {
            return;
        }
        this.clearMessageArea();
        if (this.m_currentSelection instanceof AbstractWorkingCopyClient) {
            String name = ((Text)e.getSource()).getText().trim();
            if (name.equals("")) {
                this.setErrorMessage("Client name could not be empty.");
                return;
            }
            if (!name.equals(((AbstractWorkingCopyClient)this.m_currentSelection).getId()) && ConfigurationWorkingCopyProvider.getInstance().hasIdClash(name, ConfigurationWorkingCopyProvider.getInstance().getClientWorkingCopies())) {
                this.setErrorMessage("Another client with same name already exists.");
                return;
            }
            ((AbstractWorkingCopyClient)this.m_currentSelection).modifyClientName(name);
            this.handleWorkingCopyModified((IConfigurationWorkingCopy)this.m_currentSelection);
        } else if (this.m_currentSelection instanceof AbstractWorkingCopyLogicalSystem) {
            String name = ((Text)e.getSource()).getText().trim();
            if (name.equals("")) {
                this.setErrorMessage("Name of a logical system could not be empty.");
                return;
            }
            if (!name.equals(((AbstractWorkingCopyLogicalSystem)this.m_currentSelection).getId()) && ConfigurationWorkingCopyProvider.getInstance().hasIdClash(name, ConfigurationWorkingCopyProvider.getInstance().getLogicalSystemWorkingCopies())) {
                this.setErrorMessage("Another logical system with same name already exists.");
                return;
            }
            ((AbstractWorkingCopyLogicalSystem)this.m_currentSelection).modifyLogicalSystemName(name);
            this.handleWorkingCopyModified((IConfigurationWorkingCopy)this.m_currentSelection);
        } else if (this.m_currentSelection instanceof AbstractWorkingCopyConnectionTemplate) {
            String url = ((Text)e.getSource()).getText().trim();
            if (url.equals("")) {
                this.setErrorMessage("Server URL could not be empty.");
            } else if (!url.equals(((AbstractWorkingCopyConnectionTemplate)this.m_currentSelection).getId()) && ClientConfigurationUtil.getConnectionTemplate(url) != null) {
                this.setErrorMessage("Another server with same URL already exists.");
            } else {
                this.handleWorkingCopyModified((IConfigurationWorkingCopy)this.m_currentSelection);
            }
        }
    }

    private void setApplyAndRevertButtonEnabled(boolean enabled) {
        this.m_buttonApply.setEnabled(enabled);
        this.m_buttonRevert.setEnabled(enabled);
    }

    private void clearMessageArea() {
        this.setMessage(null);
        this.setErrorMessage(null);
    }

    private boolean navigateInTree(TreeViewer treeViewer, Object destination) {
        treeViewer.setSelection((ISelection)new StructuredSelection(destination), true);
        if (treeViewer.testFindItem(destination) == null) {
            return false;
        }
        treeViewer.getTree().setFocus();
        return true;
    }

    private void addTreeDoubleClickListener(final TreeViewer treeViewer) {
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object selected = ((IStructuredSelection)selection).getFirstElement();
                    if (treeViewer.getExpandedState(selected)) {
                        treeViewer.collapseToLevel(selected, 1);
                    } else {
                        BusyIndicator.showWhile((Display)ClientConfigurationDialog.this.getDisplay(), (Runnable)new Runnable(this, selected){
                            private final /* synthetic */ Object val$selected;
                            private final /* synthetic */ 43 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$selected = val$selected;
                            }

                            public void run() {
                                43.access$2400(this.this$1).expandToLevel(this.val$selected, 1);
                            }
                        });
                    }
                }
            }

            static /* synthetic */ TreeViewer access$2400(43 x0) {
                return x0.treeViewer;
            }
        });
    }

    private void handleWorkingCopyModified(IConfigurationWorkingCopy copy) {
        this.setApplyAndRevertButtonEnabled(copy.isDirty());
        this.refreshConfigTreeNode(copy);
    }

    private void refreshConfigTreeNode(IConfigurationWorkingCopy copy) {
        this.m_configTreeViewer.refresh((Object)copy, true);
    }

    private boolean handleApplyPressed() {
        this.clearMessageArea();
        int tabIndex = this.m_tabFolder.getSelectionIndex();
        try {
            IConfigurationWorkingCopy newCopy = ((IConfigurationWorkingCopy)this.m_currentSelection).applyChanges();
            this.m_configTreeViewer.refresh();
            this.m_configTreeViewer.setSelection((ISelection)new StructuredSelection((Object)newCopy), true);
            if (tabIndex > 0) {
                this.handleTabSelection(tabIndex);
            }
        }
        catch (ConfigurationEditorException x) {
            this.m_configTreeViewer.setSelection((ISelection)new StructuredSelection((Object)x.getSource()), true);
            this.setErrorMessage(((Throwable)((Object)x)).getMessage());
            return false;
        }
        return true;
    }

    private void handleRevertPressed() {
        this.clearMessageArea();
        IConfigurationWorkingCopy copy = (IConfigurationWorkingCopy)this.m_currentSelection;
        copy.revertChanges();
        this.m_configTreeViewer.refresh((Object)copy, true);
        this.updateEditArea(copy, false, this.m_tabFolder.getSelectionIndex());
        this.setApplyAndRevertButtonEnabled(false);
    }

    private boolean openConfirmDialogConfigDefinitionChanged(IConfigurationWorkingCopy copy) {
        return this.openConfirmDialog("Save Changes?", "The " + this.getConfigElementType(copy) + " \"" + copy.getId() + "\" has unsaved changes. Please save them before continue.");
    }

    private boolean openConfirmDialogDeleteConfigElement(IConfigurationWorkingCopy copy) {
        return this.openConfirmDialog("Delete Configuration Element?", "Are you sure to delete the " + this.getConfigElementType(copy) + " \"" + copy.getId() + "\"?");
    }

    private String getConfigElementType(IConfigurationWorkingCopy copy) {
        if (copy instanceof AbstractWorkingCopyClient) {
            return "client";
        }
        if (copy instanceof AbstractWorkingCopyLogicalSystem) {
            return "logical system";
        }
        if (copy instanceof AbstractWorkingCopyConnectionTemplate) {
            return "server";
        }
        return "configuration element";
    }

    private boolean openConfirmDialog(String title, String message) {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)message);
    }

    private String openChangeRemotePathDialog(String title, String message, String oldRemotePath) {
        InputDialog dialog = new InputDialog(this.getShell(), title, message, oldRemotePath, new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.equals("")) {
                    return "Remote path must not be empty.";
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    private String openChangeLocalPathDialog(String title, String message, String oldLocalPath) {
        if (this.m_directoryDialog == null) {
            this.m_directoryDialog = new DirectoryDialog(this.getShell(), 0);
        }
        this.m_directoryDialog.setText(title);
        this.m_directoryDialog.setMessage(message);
        this.m_directoryDialog.setFilterPath(oldLocalPath);
        return this.m_directoryDialog.open();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Object access$402(ClientConfigurationDialog x0, Object x1) {
        x0.m_currentSelection = x1;
        return x0.m_currentSelection;
    }

    static /* synthetic */ void access$2100(ClientConfigurationDialog x0, IConfigurationWorkingCopy x1) {
        x0.refreshConfigTreeNode(x1);
    }

    private class DropDownSelectionListener
    extends SelectionAdapter {
        private Composite m_parent;
        private Menu m_menu = null;
        private boolean m_visible = false;
        private Text m_text;
        private AbstractWorkingCopyClient m_client;
        private AbstractWorkingCopyLogicalSystem[] m_systems = null;
        private Combo m_combo;
        private AbstractWorkingCopyConnectionTemplate[] m_templates = null;

        public DropDownSelectionListener(Composite parent, AbstractWorkingCopyClient clientToAssign, Text textToChange, AbstractWorkingCopyLogicalSystem[] systemCopies) {
            this.m_parent = parent;
            this.m_client = clientToAssign;
            this.m_text = textToChange;
            this.m_systems = systemCopies;
        }

        public DropDownSelectionListener(Composite parent, Combo comboToChange, AbstractWorkingCopyConnectionTemplate[] templateCopies) {
            this.m_parent = parent;
            this.m_combo = comboToChange;
            this.m_templates = templateCopies;
        }

        public void widgetSelected(SelectionEvent event) {
            this.m_menu = new Menu((Control)this.m_parent.getShell());
            if (this.m_systems != null) {
                this.createLogicalSystemMenus();
            } else if (this.m_templates != null) {
                this.createConnectionTemplateMenus();
            } else {
                return;
            }
            if (event.detail == 4) {
                if (this.m_visible) {
                    this.setMenuVisible(false);
                } else {
                    ToolItem toolItem = (ToolItem)event.widget;
                    ToolBar toolBar = toolItem.getParent();
                    Rectangle toolItemBounds = toolItem.getBounds();
                    Point point = toolBar.toDisplay(new Point(toolItemBounds.x, toolItemBounds.y));
                    this.m_menu.setLocation(point.x, point.y + toolItemBounds.height);
                    this.setMenuVisible(true);
                    this.m_visible = false;
                }
            }
        }

        private void createLogicalSystemMenus() {
            int i = 0;
            while (i < this.m_systems.length) {
                AbstractWorkingCopyLogicalSystem systemCopy = this.m_systems[i];
                String menuLabel = systemCopy.getId();
                MenuItem menuItem = new MenuItem(this.m_menu, 0);
                menuItem.setText(menuLabel);
                menuItem.setData((Object)systemCopy);
                if (menuLabel.equals(this.m_text.getText())) {
                    menuItem.setImage(IMAGE_CHECKED.getImageDescriptor().createImage());
                }
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(this, menuItem, menuLabel){
                    private final /* synthetic */ MenuItem val$menuItem;
                    private final /* synthetic */ String val$menuLabel;
                    private final /* synthetic */ DropDownSelectionListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$menuItem = val$menuItem;
                        this.val$menuLabel = val$menuLabel;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        ClientConfigurationDialog.access$800(DropDownSelectionListener.access$1600(this.this$1));
                        DropDownSelectionListener.access$1700(this.this$1).setData(this.val$menuItem.getData());
                        DropDownSelectionListener.access$1700(this.this$1).setText(this.val$menuLabel);
                        DropDownSelectionListener.access$1800(this.this$1, false);
                    }
                });
                ++i;
            }
            if (this.m_systems.length > 0) {
                new MenuItem(this.m_menu, 2);
            }
            MenuItem newSystem = new MenuItem(this.m_menu, 0);
            newSystem.setText("New...");
            newSystem.setImage(ClientConfigurationUtil.getConfigImage("create_logicalsystem.gif"));
            newSystem.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ DropDownSelectionListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent e) {
                    ClientConfigurationDialog.access$402(DropDownSelectionListener.access$1600(this.this$1), DropDownSelectionListener.access$1900(this.this$1));
                    IConfigurationWorkingCopy newSystem = ClientConfigurationDialog.access$000(DropDownSelectionListener.access$1600(this.this$1));
                    DropDownSelectionListener.access$2000(this.this$1).modifyLogicalSystem(newSystem);
                    ClientConfigurationDialog.access$2100(DropDownSelectionListener.access$1600(this.this$1), DropDownSelectionListener.access$2000(this.this$1));
                    DropDownSelectionListener.access$1800(this.this$1, false);
                }
            });
        }

        private void createConnectionTemplateMenus() {
            int i = 0;
            while (i < this.m_templates.length) {
                AbstractWorkingCopyConnectionTemplate templateCopy = this.m_templates[i];
                String menuLabel = templateCopy.getId();
                MenuItem menuItem = new MenuItem(this.m_menu, 0);
                menuItem.setText(menuLabel);
                menuItem.setData((Object)templateCopy);
                String[] values = this.m_combo.getItems();
                if (values.length > 0) {
                    int j = 0;
                    while (j < values.length) {
                        if (values[j].equals(menuLabel)) {
                            menuItem.setImage(IMAGE_CHECKED.getImageDescriptor().createImage());
                        }
                        ++j;
                    }
                }
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(this, menuItem, menuLabel){
                    private final /* synthetic */ MenuItem val$menuItem;
                    private final /* synthetic */ String val$menuLabel;
                    private final /* synthetic */ DropDownSelectionListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$menuItem = val$menuItem;
                        this.val$menuLabel = val$menuLabel;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        if (this.val$menuItem.getImage() == null) {
                            this.val$menuItem.setImage(ClientConfigurationDialog.access$1500().getImageDescriptor().createImage());
                            int index = DropDownSelectionListener.access$2200(this.this$1).indexOf("<please specify>");
                            if (index != -1) {
                                DropDownSelectionListener.access$2200(this.this$1).remove(index);
                            }
                            DropDownSelectionListener.access$2200(this.this$1).add(this.val$menuLabel, 0);
                            DropDownSelectionListener.access$2200(this.this$1).setData(this.val$menuLabel, this.val$menuItem.getData());
                        } else {
                            this.val$menuItem.setImage(null);
                            DropDownSelectionListener.access$2200(this.this$1).remove(this.val$menuLabel);
                            if (DropDownSelectionListener.access$2200(this.this$1).getItemCount() == 0) {
                                DropDownSelectionListener.access$2200(this.this$1).add("<please specify>");
                            }
                        }
                        DropDownSelectionListener.access$2200(this.this$1).select(0);
                        DropDownSelectionListener.access$1800(this.this$1, false);
                    }
                });
                ++i;
            }
            if (this.m_templates.length > 0) {
                new MenuItem(this.m_menu, 2);
            }
            MenuItem newTemplate = new MenuItem(this.m_menu, 0);
            newTemplate.setText("New...");
            newTemplate.setImage(ClientConfigurationUtil.getConfigImage("create_server.gif"));
            newTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ DropDownSelectionListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent e) {
                    DropDownSelectionListener.access$1800(this.this$1, false);
                }
            });
        }

        private void setMenuVisible(boolean visible) {
            this.m_menu.setVisible(visible);
            this.m_visible = visible;
        }

        static /* synthetic */ ClientConfigurationDialog access$1600(DropDownSelectionListener x0) {
            return x0.ClientConfigurationDialog.this;
        }

        static /* synthetic */ Text access$1700(DropDownSelectionListener x0) {
            return x0.m_text;
        }

        static /* synthetic */ void access$1800(DropDownSelectionListener x0, boolean x1) {
            x0.setMenuVisible(x1);
        }

        static /* synthetic */ AbstractWorkingCopyLogicalSystem[] access$1900(DropDownSelectionListener x0) {
            return x0.m_systems;
        }

        static /* synthetic */ AbstractWorkingCopyClient access$2000(DropDownSelectionListener x0) {
            return x0.m_client;
        }

        static /* synthetic */ Combo access$2200(DropDownSelectionListener x0) {
            return x0.m_combo;
        }
    }

    private class ButtonActionDelete
    extends ButtonAction {
        public ButtonActionDelete(String text, Button button) {
            super(text, button);
        }

        public void run() {
            ClientConfigurationDialog.this.handleDeletePressed();
        }
    }

    private class ButtonActionNew
    extends ButtonAction {
        public ButtonActionNew(String text, Button button) {
            super(text, button);
        }

        public void run() {
            ClientConfigurationDialog.this.handleNewPressed();
        }
    }

    private abstract class ButtonAction
    extends Action {
        protected Button fButton;

        public ButtonAction(String text, Button button) {
            super(text);
            this.fButton = button;
            if (this.fButton != null) {
                this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    private final /* synthetic */ ButtonAction this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void widgetSelected(SelectionEvent evt) {
                        this.this$1.run();
                    }
                });
            }
        }

        public Button getButton() {
            return this.fButton;
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (this.fButton != null) {
                this.fButton.setEnabled(enabled);
            }
        }
    }
}

