/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopy;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyConnectionTemplate;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationEditorException;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IConfigurationWorkingCopy;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;

abstract class AbstractWorkingCopyLogicalSystem
extends AbstractWorkingCopy {
    protected static final String LOGICAL_SYSTEM_NAME = "logical_system_name";
    protected static final String CONNECTION_TEMPLATES = "connection_templates";

    AbstractWorkingCopyLogicalSystem() {
    }

    protected boolean neededNewInstance() {
        return this.m_changes.containsKey(LOGICAL_SYSTEM_NAME);
    }

    public void modifyLogicalSystemName(String newName) {
        this.modify(LOGICAL_SYSTEM_NAME, newName);
    }

    public void modifyConnectionTemplates(List newTemplates) {
        List originalTemplateCopies = this.getOriginalConnectionTemplates();
        boolean changed = false;
        Iterator iter = newTemplates.iterator();
        while (iter.hasNext()) {
            AbstractWorkingCopyConnectionTemplate templateCopy = (AbstractWorkingCopyConnectionTemplate)iter.next();
            if (originalTemplateCopies.contains(templateCopy)) continue;
            changed = true;
            break;
        }
        if (!changed && originalTemplateCopies.size() != newTemplates.size()) {
            changed = true;
        }
        if (changed) {
            this.modify(CONNECTION_TEMPLATES, newTemplates);
        } else if (this.m_changes.containsKey(CONNECTION_TEMPLATES)) {
            this.m_changes.remove(CONNECTION_TEMPLATES);
        }
    }

    protected List getOriginalConnectionTemplates() {
        if (!this.m_lastValues.containsKey(CONNECTION_TEMPLATES)) {
            this.rememberLastValue(CONNECTION_TEMPLATES);
        }
        return (List)this.m_lastValues.get(CONNECTION_TEMPLATES);
    }

    protected ILogicalSystem createLogicalSystem(String name) {
        return Configuration.getConfiguration().createLogicalSystem(name);
    }

    protected void updateConnectionTemplates(ILogicalSystem system) throws ConfigurationException {
        AbstractWorkingCopyConnectionTemplate[] templates = this.getConnectionTemplates();
        if (this.neededNewInstance()) {
            this.addRepositoryServer(system, templates);
        } else if (this.m_changes.containsKey(CONNECTION_TEMPLATES)) {
            Iterator iter = this.getOriginalConnectionTemplates().iterator();
            while (iter.hasNext()) {
                AbstractWorkingCopyConnectionTemplate templateCopy = (AbstractWorkingCopyConnectionTemplate)iter.next();
                system.removeRepositoryServer(templateCopy.getId());
            }
            this.addRepositoryServer(system, templates);
        }
    }

    private void addRepositoryServer(ILogicalSystem system, AbstractWorkingCopyConnectionTemplate[] templates) throws ConfigurationException {
        int i = 0;
        while (i < templates.length) {
            try {
                system.addRepositoryServer(templates[i].getId(), "USER_NAME", "PASSWORD");
            }
            catch (MalformedURLException x) {
                throw new ConfigurationException("Adding repository server \"" + templates[i].getId() + "\" on logical system failed: " + x.getMessage());
            }
            catch (IllegalStateException x) {
                throw new ConfigurationException("Adding repository server \"" + templates[i].getId() + "\" on logical system failed: " + x.getMessage());
            }
            ++i;
        }
    }

    public abstract Object getOriginal();

    public abstract String getId();

    public abstract IConfigurationWorkingCopy applyChanges() throws ConfigurationEditorException;

    protected abstract void rememberLastValue(String var1);

    public abstract AbstractWorkingCopyConnectionTemplate[] getConnectionTemplates();
}

