/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopy;
import com.tssap.dtr.client.eclipse.ui.clientConfig.AbstractWorkingCopyLogicalSystem;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationEditorException;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IConfigurationWorkingCopy;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.ConfigurationException;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import com.tssap.dtr.client.lib.vfs.config.IMountPoint;
import com.tssap.dtr.client.lib.vfs.config.IRepositoryServer;
import java.util.Iterator;

abstract class AbstractWorkingCopyClient
extends AbstractWorkingCopy {
    protected static final String CLIENT_NAME = "client_name";
    protected static final String LOGICAL_SYSTEM = "logical_system";
    protected static final String LOCAL_ROOT = "local_root";
    protected static final String CLIENT_FILTER = "client_filter";
    protected static final String MOUNT_POINTS = "mount_points";

    AbstractWorkingCopyClient() {
    }

    protected boolean neededNewInstance() {
        return this.m_changes.containsKey(LOGICAL_SYSTEM) || this.m_changes.containsKey(LOCAL_ROOT) || this.m_changes.containsKey(CLIENT_NAME);
    }

    public void modifyClientName(String newName) {
        this.modify(CLIENT_NAME, newName);
    }

    public void modifyLogicalSystem(IConfigurationWorkingCopy newSystemCopy) {
        this.modify(LOGICAL_SYSTEM, newSystemCopy);
    }

    public void modifyLocalRoot(String newLocalRoot) {
        this.modify(LOCAL_ROOT, newLocalRoot);
    }

    public void modifyClientFilter(String newClientFilter) {
        this.modify(CLIENT_FILTER, newClientFilter);
    }

    protected IClient createClient(String clientName, String localRoot, ILogicalSystem logicalSystem) throws ConfigurationException {
        try {
            IClient newClient = Configuration.getConfiguration().createClient(clientName, localRoot, logicalSystem);
            if (this.isActive()) {
                Configuration.getConfiguration().setActiveClient(newClient);
            }
            return newClient;
        }
        catch (IllegalArgumentException x) {
            throw new ConfigurationException("Creating client faild: " + x.getMessage());
        }
    }

    protected void updateMountPionts(IClient client) {
        block3: {
            block2: {
                if (!this.m_changes.containsKey(MOUNT_POINTS)) break block2;
                Iterator iter = (Iterator)this.m_changes.get(MOUNT_POINTS);
                while (iter.hasNext()) {
                    IMountPoint mp = (IMountPoint)iter.next();
                    client.createMountPoint(mp.getRepositoryServer(), mp.getRelativeRemoteRoot(), mp.getRelativeLocalRoot());
                }
                break block3;
            }
            if (!this.neededNewInstance()) break block3;
            Iterator iter = client.getLogicalSystem().repositoryServers();
            while (iter.hasNext()) {
                IRepositoryServer server = (IRepositoryServer)iter.next();
                client.createMountPoint(server, "ws", "");
            }
        }
    }

    protected void updateClientFilter(IClient client) throws ConfigurationException {
        if (this.neededNewInstance()) {
            client.setClientFilter(this.getClientFilter());
        }
        if (this.m_changes.containsKey(CLIENT_FILTER)) {
            client.setClientFilter((String)this.m_changes.get(CLIENT_FILTER));
        }
    }

    public abstract Object getOriginal();

    public abstract String getId();

    public abstract IConfigurationWorkingCopy applyChanges() throws ConfigurationEditorException;

    public abstract boolean isActive();

    protected abstract void rememberLastValue(String var1);

    public abstract AbstractWorkingCopyLogicalSystem getLogicalSystem();

    public abstract String getLocalRoot();

    public abstract String getClientFilter();
}

