/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.clientConfig;

import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationEditorException;
import com.tssap.dtr.client.eclipse.ui.clientConfig.ConfigurationWorkingCopyProvider;
import com.tssap.dtr.client.eclipse.ui.clientConfig.IConfigurationWorkingCopy;
import java.util.HashMap;
import java.util.Map;

abstract class AbstractWorkingCopy
implements IConfigurationWorkingCopy {
    protected Map m_changes = new HashMap();
    protected Map m_lastValues = new HashMap();

    AbstractWorkingCopy() {
    }

    public boolean isDirty() {
        return !this.m_changes.isEmpty();
    }

    public void revertChanges() {
        this.clearCacheOfChanges();
    }

    protected void clearCaches() {
        this.m_changes.clear();
        this.m_lastValues.clear();
    }

    protected void clearCacheOfChanges() {
        this.m_changes.clear();
    }

    protected void modify(String key, Object newValue) {
        this.m_changes.put(key, newValue);
        if (!this.m_lastValues.containsKey(key)) {
            this.rememberLastValue(key);
        }
        if (newValue.equals(this.m_lastValues.get(key))) {
            this.m_changes.remove(key);
            this.m_lastValues.remove(key);
        }
    }

    protected Object get(String key) {
        if (this.m_changes.containsKey(key)) {
            return this.m_changes.get(key);
        }
        if (!this.m_lastValues.containsKey(key)) {
            this.rememberLastValue(key);
        }
        return this.m_lastValues.get(key);
    }

    protected IConfigurationWorkingCopy getCopy(Object original) {
        if (original != null) {
            return ConfigurationWorkingCopyProvider.getInstance().getWorkingCopy(original);
        }
        return null;
    }

    public abstract Object getOriginal();

    public abstract String getId();

    public abstract IConfigurationWorkingCopy applyChanges() throws ConfigurationEditorException;

    protected abstract void rememberLastValue(String var1);

    protected abstract boolean neededNewInstance();
}

