/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.calendar;

import com.tssap.dtr.client.eclipse.ui.calendar.DrawHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class SpeedButton
extends Canvas {
    private boolean m_Up = true;
    private String m_Text = "";
    private int m_TextAlign = 49;
    private Image m_Image;
    private int m_ImageAlign = 55;

    public SpeedButton(Composite parent, int style) {
        super(parent, style | 0x80000 | 0x40000 | 0x100000);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                SpeedButton.this.onPaint(event);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SpeedButton.this.redraw();
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                SpeedButton.this.onMouseMove(e);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SpeedButton.this.onMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                SpeedButton.this.onMouseUp(e);
            }
        });
    }

    private void onMouseDown(MouseEvent e) {
        this.m_Up = false;
        this.setCapture(true);
        this.redraw();
    }

    private void onMouseUp(MouseEvent e) {
        if (!this.m_Up && this.getClientArea().contains(e.x, e.y)) {
            Event event = new Event();
            event.time = e.time;
            event.stateMask = e.stateMask;
            this.notifyListeners(13, event);
        }
        this.m_Up = true;
        this.setCapture(false);
        this.redraw();
    }

    private void onMouseMove(MouseEvent e) {
        GC gc = new GC((Drawable)this);
        Rectangle rect = this.getClientArea();
        if (!this.m_Up) {
            if (rect.contains(e.x, e.y)) {
                DrawHelper.drawButtonDeepDown(gc, this.m_Text, this.m_TextAlign, this.m_Image, this.m_ImageAlign, rect);
            } else {
                DrawHelper.drawButtonUp(gc, this.m_Text, this.m_TextAlign, this.m_Image, this.m_ImageAlign, rect, 0, 0);
            }
        }
        gc.dispose();
    }

    private void onPaint(PaintEvent event) {
        Rectangle rect = this.getClientArea();
        GC gc = event.gc;
        if (this.m_Up) {
            DrawHelper.drawButtonUp(gc, this.m_Text, this.m_TextAlign, this.m_Image, this.m_ImageAlign, rect, 0, 0);
        } else {
            DrawHelper.drawButtonDeepDown(gc, this.m_Text, this.m_TextAlign, this.m_Image, this.m_ImageAlign, rect);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public String getText() {
        return this.m_Text;
    }

    public void setText(String text) {
        this.m_Text = text;
        this.redraw();
    }

    public int getTextAlign() {
        return this.m_TextAlign;
    }

    public void setTextAlign(int textAlign) {
        this.m_TextAlign = textAlign;
        this.redraw();
    }

    public Image getImage() {
        return this.m_Image;
    }

    public void setImage(Image image) {
        this.m_Image = image;
        this.redraw();
    }

    public int getImageAlign() {
        return this.m_ImageAlign;
    }

    public void setImageAlign(int imageAlign) {
        this.m_ImageAlign = imageAlign;
        this.redraw();
    }
}

