/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.calendar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectableClock
extends Composite {
    private HourValueHolder fHour;
    private HourValueHolder fMin;
    private HourValueHolder fSecond;
    private List fPropertyListeners = new ArrayList();
    private HashMap fVisualValues = new HashMap();

    public SelectableClock(Composite parent, int style, int initialHour, int initialMinutes, int initialSeconds) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 0;
        this.setLayout((Layout)layout);
        this.fHour = new HourValueHolder(23);
        this.fHour.setValue(initialHour);
        this.fMin = new HourValueHolder(59);
        this.fMin.setValue(initialMinutes);
        this.fSecond = new HourValueHolder(59);
        this.fSecond.setValue(initialSeconds);
        this.fVisualValues.put(this.fHour, this.createHourBar(this, "Hours", this.fHour));
        this.fVisualValues.put(this.fMin, this.createHourBar(this, "Minutes", this.fMin));
        this.fVisualValues.put(this.fSecond, this.createHourBar(this, "Seconds", this.fSecond));
    }

    private StyledText createHourBar(Composite parent, String description, final HourValueHolder value) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Composite clockParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        clockParent.setLayout((Layout)layout);
        clockParent.setLayoutData((Object)new GridData(800));
        Label label = new Label(clockParent, 0);
        label.setText(description);
        label.setFont(JFaceResources.getBannerFont());
        GridData data = new GridData(34);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Composite visualParent = new Composite(clockParent, 2048);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        visualParent.setLayout((Layout)layout);
        visualParent.setLayoutData((Object)new GridData(768));
        final StyledText visualValue = new StyledText(visualParent, 12);
        visualValue.setText(value.toString());
        visualValue.setLayoutData((Object)new GridData(512));
        visualParent.setBackground(visualValue.getBackground());
        Composite buttonParent = new Composite(clockParent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        buttonParent.setLayout((Layout)layout);
        buttonParent.setLayoutData((Object)new GridData(1));
        Button upButton = new Button(buttonParent, 4);
        upButton.setAlignment(128);
        int fontheight = visualValue.getFont().getFontData()[0].getHeight();
        data = new GridData(2);
        data.heightHint = fontheight;
        upButton.setLayoutData((Object)data);
        Button downButton = new Button(buttonParent, 4);
        downButton.setAlignment(1024);
        data = new GridData(8);
        data.heightHint = fontheight;
        downButton.setLayoutData((Object)data);
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                value.increase();
                visualValue.setText(value.toString());
            }
        });
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                value.decrease();
                visualValue.setText(value.toString());
            }
        });
        return visualValue;
    }

    public void addPropertyListener(IPropertyChangeListener listener) {
        if (!this.fPropertyListeners.contains(listener)) {
            this.fPropertyListeners.add(listener);
        }
    }

    public void removePropertyListener(IPropertyChangeListener listener) {
        if (this.fPropertyListeners.contains(listener)) {
            this.fPropertyListeners.remove(listener);
        }
    }

    protected void firePropertyChange() {
        IPropertyChangeListener[] listeners = this.fPropertyListeners.toArray(new IPropertyChangeListener[this.fPropertyListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].propertyChange(new PropertyChangeEvent((Object)this, "date", null, null));
            ++i;
        }
    }

    public int getHour() {
        return this.fHour.getValue();
    }

    public void setHour(int hour) {
        this.fHour.setValue(hour);
        this.updateVisualValue(this.fHour);
    }

    public int getMinutes() {
        return this.fMin.getValue();
    }

    public void setMinutes(int minutes) {
        this.fMin.setValue(minutes);
        this.updateVisualValue(this.fMin);
    }

    public int getSeconds() {
        return this.fSecond.getValue();
    }

    public void setSeconds(int seconds) {
        this.fSecond.setValue(seconds);
        this.updateVisualValue(this.fSecond);
    }

    private void updateVisualValue(HourValueHolder value) {
        StyledText val = (StyledText)this.fVisualValues.get(value);
        val.setText(value.toString());
    }

    class HourValueHolder {
        private int fMaxValue;
        private int fValue;

        public HourValueHolder(int maxValue) {
            this.fMaxValue = maxValue;
            this.fValue = 0;
        }

        public void increase() {
            ++this.fValue;
            if (this.fValue > this.fMaxValue) {
                this.fValue = 0;
            }
            SelectableClock.this.firePropertyChange();
        }

        public void decrease() {
            --this.fValue;
            if (this.fValue < 0) {
                this.fValue = this.fMaxValue;
            }
            SelectableClock.this.firePropertyChange();
        }

        public int getValue() {
            return this.fValue;
        }

        public void setValue(int value) {
            boolean cont = true;
            while (cont) {
                if (value > this.fMaxValue) {
                    value -= this.fMaxValue;
                    continue;
                }
                this.fValue = value;
                cont = false;
            }
            SelectableClock.this.firePropertyChange();
        }

        public String toString() {
            if (this.fValue < 10) {
                return "0" + String.valueOf(this.fValue);
            }
            return String.valueOf(this.fValue);
        }
    }
}

