/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.calendar;

import com.tssap.dtr.client.eclipse.ui.calendar.DrawHelper;
import com.tssap.dtr.client.eclipse.ui.calendar.SpeedButton;
import com.tssap.dtr.client.eclipse.ui.util.ImageSingletone;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class SelectableCalendar
extends Composite {
    private int m_Year = 2002;
    private int m_Month = 7;
    private int m_Day = 10;
    private ImageSingletone fNextYear = new ImageSingletone("calendar/next_year.gif");
    private ImageSingletone fPrevYear = new ImageSingletone("calendar/prev_year.gif");
    private ImageSingletone fNextMonth = new ImageSingletone("calendar/next_month.gif");
    private ImageSingletone fPrevMonth = new ImageSingletone("calendar/prev_month.gif");
    private List fPropertyListeners = new ArrayList();
    private Label m_MonthLabel;
    private TDatePanel m_DatePanel;

    public SelectableCalendar(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        this.setBackground(Display.getCurrent().getSystemColor(2));
        this.setLayout((Layout)gridLayout);
        SpeedButton prevYear = new SpeedButton(this, 0);
        GridData gridData = new GridData(32);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        prevYear.setLayoutData(gridData);
        prevYear.setImage(this.fPrevYear.getImage());
        prevYear.setToolTipText("Previous Year");
        prevYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectableCalendar.this.m_Year--;
                SelectableCalendar.this.updateDate();
            }
        });
        SpeedButton prevMonth = new SpeedButton(this, 0);
        gridData = new GridData(32);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        prevMonth.setLayoutData(gridData);
        prevMonth.setImage(this.fPrevMonth.getImage());
        prevMonth.setToolTipText("Previous Month");
        prevMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectableCalendar.this.m_Month--;
                SelectableCalendar.this.updateDate();
            }
        });
        this.m_MonthLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData(768);
        gridData.heightHint = prevYear.computeSize((int)20, (int)20).y;
        this.m_MonthLabel.setLayoutData((Object)gridData);
        SpeedButton nextMonth = new SpeedButton(this, 0);
        gridData = new GridData(128);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        nextMonth.setLayoutData(gridData);
        nextMonth.setImage(this.fNextMonth.getImage());
        nextMonth.setToolTipText("Next Month");
        nextMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectableCalendar.this.m_Month++;
                SelectableCalendar.this.updateDate();
            }
        });
        SpeedButton nextYear = new SpeedButton(this, 0);
        gridData = new GridData(128);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        nextYear.setLayoutData(gridData);
        nextYear.setImage(this.fNextYear.getImage());
        nextYear.setToolTipText("Next Year");
        nextYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectableCalendar.this.m_Year++;
                SelectableCalendar.this.updateDate();
            }
        });
        this.m_DatePanel = new TDatePanel(this, 0);
        gridData = new GridData(128);
        gridData.horizontalSpan = 5;
        this.m_DatePanel.setLayoutData(gridData);
        this.panelChanged();
    }

    private void normalizeDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.m_Year);
        calendar.set(2, this.m_Month);
        calendar.set(5, this.m_Day);
        this.m_Year = calendar.get(1);
        this.m_Month = calendar.get(2);
        this.m_Day = calendar.get(5);
    }

    private void updateDate() {
        this.normalizeDay();
        this.m_DatePanel.redraw();
        this.panelChanged();
    }

    private String getMonthName(int month) {
        switch (month) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        throw new SWTException("Wrong month number: " + month);
    }

    private void panelChanged() {
        this.m_MonthLabel.setText(this.getMonthName(this.m_Month + 1) + ", " + this.m_Year);
        this.firePropertyChange();
    }

    private void dateSelected(boolean good) {
        Event event = new Event();
        event.doit = good;
        this.notifyListeners(13, event);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void addPropertyListener(IPropertyChangeListener listener) {
        if (!this.fPropertyListeners.contains(listener)) {
            this.fPropertyListeners.add(listener);
        }
    }

    public void removePropertyListener(IPropertyChangeListener listener) {
        if (this.fPropertyListeners.contains(listener)) {
            this.fPropertyListeners.remove(listener);
        }
    }

    protected void firePropertyChange() {
        IPropertyChangeListener[] listeners = this.fPropertyListeners.toArray(new IPropertyChangeListener[this.fPropertyListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].propertyChange(new PropertyChangeEvent((Object)this, "date", null, null));
            ++i;
        }
    }

    public int getDay() {
        return this.m_Day;
    }

    public void setDay(int day) {
        this.m_Day = day;
        this.panelChanged();
        this.redraw();
    }

    public int getMonth() {
        return this.m_Month + 1;
    }

    public void setMonth(int month) {
        this.m_Month = month - 1;
        this.panelChanged();
        this.redraw();
    }

    public int getYear() {
        return this.m_Year;
    }

    public void setYear(int year) {
        this.m_Year = year;
        this.panelChanged();
        this.redraw();
    }

    private class TDatePanel
    extends Canvas {
        private Display m_Display = Display.getCurrent();
        private Calendar m_Calendar = Calendar.getInstance();
        private int m_ColSize;
        private int m_RowSize;

        public TDatePanel(Composite parent, int style) {
            super(parent, style | 0x40000 | 0x100000);
            GC gc = new GC((Drawable)this);
            Point p = gc.stringExtent("Q");
            gc.dispose();
            this.m_ColSize = p.x * 3;
            this.m_RowSize = (int)((double)p.y * 1.2);
            this.addPaintListener(new PaintListener(this){
                private final /* synthetic */ TDatePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void paintControl(PaintEvent event) {
                    TDatePanel.access$000(this.this$1, event);
                }
            });
            this.addControlListener((ControlListener)new ControlAdapter(this){
                private final /* synthetic */ TDatePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void controlResized(ControlEvent e) {
                    this.this$1.redraw();
                    TDatePanel.access$100(this.this$1).firePropertyChange();
                }
            });
            this.addKeyListener((KeyListener)new KeyAdapter(this){
                private final /* synthetic */ TDatePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent e) {
                    TDatePanel.access$200(this.this$1, e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(this){
                private final /* synthetic */ TDatePanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseDown(MouseEvent e) {
                    TDatePanel.access$300(this.this$1, e);
                }
            });
        }

        private void onMouseDown(MouseEvent e) {
            int day = this.getDayFromPoint(e.x, e.y);
            if (day > 0) {
                SelectableCalendar.this.m_Day = day;
                SelectableCalendar.this.dateSelected(true);
            }
            this.redraw();
            SelectableCalendar.this.firePropertyChange();
        }

        private String getDayName(int day) {
            switch (day) {
                case 1: {
                    return "Mon";
                }
                case 2: {
                    return "Tue";
                }
                case 3: {
                    return "Wed";
                }
                case 4: {
                    return "Thu";
                }
                case 5: {
                    return "Fri";
                }
                case 6: {
                    return "Sat";
                }
                case 7: {
                    return "Sun";
                }
            }
            throw new SWTException("Wrong day number: " + day);
        }

        private int calendarDayToNormal(int day) {
            switch (day) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 5;
                }
                case 7: {
                    return 6;
                }
                case 1: {
                    return 7;
                }
            }
            return -1;
        }

        private int getDayFromPoint(int x, int y) {
            int i = 1;
            while (i <= 31) {
                Point p = this.getDayPoint(i);
                Rectangle r = new Rectangle(p.x, p.y, this.m_ColSize, this.m_RowSize);
                if (r.contains(x, y)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private Point getDayPoint(int day) {
            this.m_Calendar.set(1, SelectableCalendar.this.m_Year);
            this.m_Calendar.set(2, SelectableCalendar.this.m_Month);
            this.m_Calendar.set(5, 1);
            int first_day_of_week = this.calendarDayToNormal(this.m_Calendar.get(7)) - 1;
            this.m_Calendar.set(5, day);
            int day_of_week = this.calendarDayToNormal(this.m_Calendar.get(7));
            int x = (day_of_week - 1) * this.m_ColSize;
            int y = (1 + (first_day_of_week + day - 1) / 7) * this.m_RowSize;
            return new Point(x, y);
        }

        private int getMaxDay() {
            this.m_Calendar.set(1, SelectableCalendar.this.m_Year);
            this.m_Calendar.set(2, SelectableCalendar.this.m_Month);
            int day = 28;
            int i = 0;
            while (i < 10) {
                this.m_Calendar.set(5, day);
                if (this.m_Calendar.get(2) != SelectableCalendar.this.m_Month) {
                    return day - 1;
                }
                ++day;
                ++i;
            }
            return -1;
        }

        private void onPaint(PaintEvent event) {
            Rectangle rect = this.getClientArea();
            GC gc0 = event.gc;
            Image image = new Image((Device)this.m_Display, rect.width, rect.height);
            GC gc = new GC((Drawable)image);
            gc.setBackground(this.m_Display.getSystemColor(25));
            gc.fillRectangle(rect);
            int x = 0;
            int y = 0;
            gc.setBackground(this.m_Display.getSystemColor(22));
            int i = 0;
            while (i < 7) {
                if (i == 6) {
                    gc.setForeground(this.m_Display.getSystemColor(3));
                }
                DrawHelper.drawTextImage(gc, this.getDayName(1 + i), 55, null, 0, x, 0, this.m_ColSize, this.m_RowSize);
                x += this.m_ColSize;
                ++i;
            }
            gc.setForeground(this.m_Display.getSystemColor(2));
            gc.drawLine(0, 0, rect.width, 0);
            gc.drawLine(0, (y += this.m_RowSize) - 1, rect.width, y - 1);
            this.m_Calendar.set(1, SelectableCalendar.this.m_Year);
            this.m_Calendar.set(2, SelectableCalendar.this.m_Month);
            int day = 1;
            while (true) {
                this.m_Calendar.set(5, day);
                if (this.m_Calendar.get(2) != SelectableCalendar.this.m_Month) break;
                int day_of_week = this.calendarDayToNormal(this.m_Calendar.get(7));
                Point p = this.getDayPoint(day);
                if (day == SelectableCalendar.this.m_Day) {
                    gc.setForeground(this.m_Display.getSystemColor(27));
                    gc.setBackground(this.m_Display.getSystemColor(26));
                } else {
                    gc.setBackground(this.m_Display.getSystemColor(25));
                    if (day_of_week == 7) {
                        gc.setForeground(this.m_Display.getSystemColor(3));
                    } else {
                        gc.setForeground(this.m_Display.getSystemColor(2));
                    }
                }
                DrawHelper.drawTextImage(gc, "" + day, 55, null, 0, p.x, p.y, this.m_ColSize, this.m_RowSize);
                ++day;
            }
            gc0.drawImage(image, 0, 0);
            gc.dispose();
            image.dispose();
        }

        private void onKeyDown(KeyEvent e) {
            if (e.character == '\u001b') {
                SelectableCalendar.this.dateSelected(false);
                return;
            }
            if (e.character == ' ' || e.character == '\r') {
                SelectableCalendar.this.dateSelected(true);
                return;
            }
            int oldDay = SelectableCalendar.this.m_Day;
            int oldMonth = SelectableCalendar.this.m_Month;
            if (e.keyCode == 0x1000003) {
                SelectableCalendar.this.m_Day--;
            }
            if (e.keyCode == 0x1000004) {
                SelectableCalendar.this.m_Day++;
            }
            if (e.keyCode == 0x1000001) {
                SelectableCalendar.this.m_Day -= 7;
                if (SelectableCalendar.this.m_Day < 1) {
                    SelectableCalendar.this.m_Day = oldDay;
                }
            }
            if (e.keyCode == 0x1000002) {
                SelectableCalendar.this.m_Day += 7;
                if (SelectableCalendar.this.m_Day > this.getMaxDay()) {
                    SelectableCalendar.this.m_Day = oldDay;
                }
            }
            if (e.keyCode == 0x1000005) {
                SelectableCalendar.this.m_Month--;
            }
            if (e.keyCode == 0x1000006) {
                SelectableCalendar.this.m_Month++;
            }
            SelectableCalendar.this.normalizeDay();
            if (SelectableCalendar.this.m_Day != oldDay || SelectableCalendar.this.m_Month != oldMonth) {
                this.redraw();
                if (SelectableCalendar.this.m_Month != oldMonth) {
                    SelectableCalendar.this.panelChanged();
                }
            }
            SelectableCalendar.this.firePropertyChange();
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return new Point(this.m_ColSize * 7, this.m_RowSize * 7);
        }

        static /* synthetic */ void access$000(TDatePanel x0, PaintEvent x1) {
            x0.onPaint(x1);
        }

        static /* synthetic */ SelectableCalendar access$100(TDatePanel x0) {
            return x0.SelectableCalendar.this;
        }

        static /* synthetic */ void access$200(TDatePanel x0, KeyEvent x1) {
            x0.onKeyDown(x1);
        }

        static /* synthetic */ void access$300(TDatePanel x0, MouseEvent x1) {
            x0.onMouseDown(x1);
        }
    }
}

