/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.calendar;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class DrawHelper {
    public static final int EVENT_SWTX_BASE = 1000;
    public static final int EVENT_TABLE_HEADER = 1001;
    public static final int EVENT_TABLE_HEADER_CLICK = 1002;
    public static final int EVENT_TABLE_HEADER_RESIZE = 1003;
    public static final int ALIGN_HORIZONTAL_MASK = 15;
    public static final int ALIGN_HORIZONTAL_NONE = 0;
    public static final int ALIGN_HORIZONTAL_LEFT = 1;
    public static final int ALIGN_HORIZONTAL_LEFT_LEFT = 1;
    public static final int ALIGN_HORIZONTAL_LEFT_RIGHT = 2;
    public static final int ALIGN_HORIZONTAL_LEFT_CENTER = 3;
    public static final int ALIGN_HORIZONTAL_RIGHT = 4;
    public static final int ALIGN_HORIZONTAL_RIGHT_RIGHT = 4;
    public static final int ALIGN_HORIZONTAL_RIGHT_LEFT = 5;
    public static final int ALIGN_HORIZONTAL_RIGHT_CENTER = 6;
    public static final int ALIGN_HORIZONTAL_CENTER = 7;
    public static final int ALIGN_VERTICAL_MASK = 240;
    public static final int ALIGN_VERTICAL_TOP = 16;
    public static final int ALIGN_VERTICAL_BOTTOM = 32;
    public static final int ALIGN_VERTICAL_CENTER = 48;
    private static GC m_LastGCFromExtend;
    private static Map m_StringExtentCache;

    private static synchronized Point getCachedStringExtent(GC gc, String text) {
        Point p;
        if (m_LastGCFromExtend != gc) {
            m_StringExtentCache.clear();
            m_LastGCFromExtend = gc;
        }
        if ((p = (Point)m_StringExtentCache.get(text)) == null) {
            if (text == null) {
                return new Point(0, 0);
            }
            p = gc.stringExtent(text);
            m_StringExtentCache.put(text, p);
        }
        return new Point(p.x, p.y);
    }

    public static int drawTextVerticalAlign(GC gc, String text, int textAlign, int x, int y, int w, int h) {
        if (text == null) {
            text = "";
        }
        Point textSize = DrawHelper.getCachedStringExtent(gc, text);
        boolean addPoint = false;
        while (text.length() > 0 && textSize.x >= w) {
            text = text.substring(0, text.length() - 1);
            textSize = DrawHelper.getCachedStringExtent(gc, text + "...");
            addPoint = true;
        }
        if (addPoint) {
            text = text + "...";
        }
        textSize = DrawHelper.getCachedStringExtent(gc, text);
        if (textSize.x >= w) {
            text = "";
            textSize = DrawHelper.getCachedStringExtent(gc, text);
        }
        if ((textAlign & 0xF0) == 16) {
            gc.drawText(text, x, y);
            gc.fillRectangle(x, y + textSize.y, textSize.x, h - textSize.y);
            return textSize.x;
        }
        if ((textAlign & 0xF0) == 32) {
            gc.drawText(text, x, y + h - textSize.y);
            gc.fillRectangle(x, y, textSize.x, h - textSize.y);
            return textSize.x;
        }
        if ((textAlign & 0xF0) == 48) {
            int yOffset = (h - textSize.y) / 2;
            gc.drawText(text, x, y + yOffset);
            gc.fillRectangle(x, y, textSize.x, yOffset);
            gc.fillRectangle(x, y + yOffset + textSize.y, textSize.x, h - (yOffset + textSize.y));
            return textSize.x;
        }
        throw new SWTException("Wrong vertical mask: " + (textAlign & 0xF0));
    }

    public static void drawTransparentImage(GC gc, Image image, int x, int y) {
        if (image == null) {
            return;
        }
        Point imageSize = new Point(image.getBounds().width, image.getBounds().height);
        Image img = new Image((Device)Display.getCurrent(), imageSize.x, imageSize.y);
        GC gc2 = new GC((Drawable)img);
        gc2.setBackground(gc.getBackground());
        gc2.fillRectangle(0, 0, imageSize.x, imageSize.y);
        gc2.drawImage(image, 0, 0);
        gc.drawImage(img, x, y);
        gc2.dispose();
        img.dispose();
    }

    public static void drawImageVerticalAlign(GC gc, Image image, int imageAlign, int x, int y, int h) {
        if (image == null) {
            return;
        }
        Point imageSize = new Point(image.getBounds().width, image.getBounds().height);
        if ((imageAlign & 0xF0) == 16) {
            DrawHelper.drawTransparentImage(gc, image, x, y);
            gc.fillRectangle(x, y + imageSize.y, imageSize.x, h - imageSize.y);
            return;
        }
        if ((imageAlign & 0xF0) == 32) {
            DrawHelper.drawTransparentImage(gc, image, x, y + h - imageSize.y);
            gc.fillRectangle(x, y, imageSize.x, h - imageSize.y);
            return;
        }
        if ((imageAlign & 0xF0) == 48) {
            int yOffset = (h - imageSize.y) / 2;
            DrawHelper.drawTransparentImage(gc, image, x, y + yOffset);
            gc.fillRectangle(x, y, imageSize.x, yOffset);
            gc.fillRectangle(x, y + yOffset + imageSize.y, imageSize.x, h - (yOffset + imageSize.y));
            return;
        }
        throw new SWTException("Wrong vertical align: " + (imageAlign & 0xF0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void drawTextImage(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h) {
        Point textSize = DrawHelper.getCachedStringExtent(gc, text);
        Point imageSize = image != null ? new Point(image.getBounds().width, image.getBounds().height) : new Point(0, 0);
        try {
            if (image == null && (textAlign & 0xF) == 7) {
                Point p = DrawHelper.getCachedStringExtent(gc, text);
                int offset = (w - p.x) / 2;
                if (offset > 0) {
                    DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x + offset, y, w, h);
                    gc.fillRectangle(x, y, offset, h);
                    gc.fillRectangle(x + offset + p.x, y, w - (offset + p.x), h);
                    return;
                } else {
                    p.x = DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x, y, w, h);
                    gc.fillRectangle(x + p.x, y, w - (x + p.x) + 1, h);
                }
                return;
            }
            if ((text == null || text.length() == 0) && (imageAlign & 0xF) == 7) {
                int offset = (w - imageSize.x) / 2;
                DrawHelper.drawImageVerticalAlign(gc, image, imageAlign, x + offset, y, h);
                gc.fillRectangle(x, y, offset, h);
                gc.fillRectangle(x + offset + imageSize.x, y, w - (offset + imageSize.x), h);
                return;
            }
            if ((textAlign & 0xF) == 1) {
                if ((imageAlign & 0xF) == 0) {
                    textSize.x = DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x, y, w, h);
                    gc.fillRectangle(x + textSize.x, y, w - textSize.x, h);
                    return;
                }
                if ((imageAlign & 0xF) == 1) {
                    textSize.x = DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x + imageSize.x, y, w - imageSize.x, h);
                    DrawHelper.drawImageVerticalAlign(gc, image, imageAlign, x, y, h);
                    gc.fillRectangle(x + textSize.x + imageSize.x, y, w - (textSize.x + imageSize.x), h);
                    return;
                }
                if ((imageAlign & 0xF) == 4) {
                    textSize.x = DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x, y, w - imageSize.x, h);
                    DrawHelper.drawImageVerticalAlign(gc, image, imageAlign, x + w - imageSize.x, y, h);
                    gc.fillRectangle(x + textSize.x, y, w - (textSize.x + imageSize.x), h);
                    return;
                }
                if ((imageAlign & 0xF) == 5) {
                    textSize.x = DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x, y, w - imageSize.x, h);
                    DrawHelper.drawImageVerticalAlign(gc, image, imageAlign, x + textSize.x, y, h);
                    gc.fillRectangle(x + textSize.x + imageSize.x, y, w - (textSize.x + imageSize.x), h);
                    return;
                }
                if ((imageAlign & 0xF) != 6) throw new SWTException("Wrong image align: " + (imageAlign & 0xF));
                textSize.x = DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x, y, w - imageSize.x, h);
                int xOffset = (w - textSize.x - imageSize.x) / 2;
                DrawHelper.drawImageVerticalAlign(gc, image, imageAlign, x + textSize.x + xOffset, y, h);
                gc.fillRectangle(x + textSize.x, y, xOffset, h);
                gc.fillRectangle(x + textSize.x + xOffset + imageSize.x, y, w - (textSize.x + xOffset + imageSize.x), h);
                return;
            }
            if ((textAlign & 0xF) != 4) throw new SWTException("Wrong text align: " + (textAlign & 0xF));
            if ((imageAlign & 0xF) == 0) {
                textSize.x = DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x, -1000, w, h);
                DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x + w - textSize.x, y, w, h);
                gc.fillRectangle(x, y, w - textSize.x, h);
                return;
            }
            if ((imageAlign & 0xF) == 1) {
                textSize.x = DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x, -1000, w - imageSize.x, h);
                DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x + w - textSize.x, y, w - imageSize.x, h);
                DrawHelper.drawImageVerticalAlign(gc, image, imageAlign, x, y, h);
                gc.fillRectangle(x + imageSize.x, y, w - (textSize.x + imageSize.x), h);
                return;
            }
            if ((imageAlign & 0xF) == 2) {
                textSize.x = DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x, -1000, w - imageSize.x, h);
                DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x + w - textSize.x, y, w - imageSize.x, h);
                DrawHelper.drawImageVerticalAlign(gc, image, imageAlign, x + w - (textSize.x + imageSize.x), y, h);
                gc.fillRectangle(x, y, w - (textSize.x + imageSize.x), h);
                return;
            }
            if ((imageAlign & 0xF) == 3) {
                textSize.x = DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x, -1000, w - imageSize.x, h);
                DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x + w - textSize.x, y, w - imageSize.x, h);
                int xOffset = (w - textSize.x - imageSize.x) / 2;
                DrawHelper.drawImageVerticalAlign(gc, image, imageAlign, x + xOffset, y, h);
                gc.fillRectangle(x, y, xOffset, h);
                gc.fillRectangle(x + xOffset + imageSize.x, y, w - (xOffset + imageSize.x + textSize.x), h);
                return;
            }
            if ((imageAlign & 0xF) != 4) throw new SWTException("Wrong image align: " + (imageAlign & 0xF));
            textSize.x = DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x, -1000, w - imageSize.x, h);
            DrawHelper.drawTextVerticalAlign(gc, text, textAlign, x + w - (textSize.x + imageSize.x), y, w - imageSize.x, h);
            DrawHelper.drawImageVerticalAlign(gc, image, imageAlign, x + w - imageSize.x, y, h);
            gc.fillRectangle(x, y, w - (textSize.x + imageSize.x), h);
            return;
        }
        catch (Throwable throwable) {
            Object var14_28 = null;
            throw throwable;
        }
    }

    public static void drawTextImage(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle r) {
        DrawHelper.drawTextImage(gc, text, textAlign, image, imageAlign, r.x, r.y, r.width, r.height);
    }

    public static void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h, Color face, Color shadowHigh, Color shadowNormal, Color shadowDark, int leftMargin, int topMargin) {
        Color prevForeground = gc.getForeground();
        Color prevBackground = gc.getBackground();
        try {
            gc.setBackground(face);
            gc.setForeground(shadowHigh);
            gc.drawLine(x, y, x, y + h - 1);
            gc.drawLine(x, y, x + w - 2, y);
            gc.setForeground(shadowDark);
            gc.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            gc.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            gc.setForeground(shadowNormal);
            gc.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
            gc.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            gc.fillRectangle(x + 1, y + 1, leftMargin, h - 3);
            gc.fillRectangle(x + 1, y + 1, w - 3, topMargin);
            gc.setForeground(prevForeground);
            DrawHelper.drawTextImage(gc, text, textAlign, image, imageAlign, x + 1 + leftMargin, y + 1 + topMargin, w - 3 - leftMargin, h - 3 - topMargin);
            Object var18_17 = null;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            gc.setForeground(prevForeground);
            gc.setBackground(prevBackground);
            throw throwable;
        }
        gc.setForeground(prevForeground);
        gc.setBackground(prevBackground);
    }

    public static void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h, Color face) {
        Display display = Display.getCurrent();
        DrawHelper.drawButtonUp(gc, text, textAlign, image, imageAlign, x, y, w, h, face, display.getSystemColor(20), display.getSystemColor(18), display.getSystemColor(17), 2, 2);
    }

    public static void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle r, int leftMargin, int topMargin) {
        Display display = Display.getCurrent();
        DrawHelper.drawButtonUp(gc, text, textAlign, image, imageAlign, r.x, r.y, r.width, r.height, display.getSystemColor(22), display.getSystemColor(20), display.getSystemColor(18), display.getSystemColor(17), leftMargin, topMargin);
    }

    public static void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h) {
        Display display = Display.getCurrent();
        DrawHelper.drawButtonUp(gc, text, textAlign, image, imageAlign, x, y, w, h, display.getSystemColor(22), display.getSystemColor(20), display.getSystemColor(18), display.getSystemColor(17), 2, 2);
    }

    public static void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle r) {
        Display display = Display.getCurrent();
        DrawHelper.drawButtonUp(gc, text, textAlign, image, imageAlign, r.x, r.y, r.width, r.height);
    }

    public static void drawButtonDown(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h, Color face, Color shadowNormal, int leftMargin, int topMargin) {
        Color prevForeground = gc.getForeground();
        Color prevBackground = gc.getBackground();
        try {
            gc.setBackground(face);
            gc.setForeground(shadowNormal);
            gc.drawRectangle(x, y, w - 1, h - 1);
            gc.fillRectangle(x + 1, y + 1, 1 + leftMargin, h - 2);
            gc.fillRectangle(x + 1, y + 1, w - 2, topMargin + 1);
            gc.setForeground(prevForeground);
            DrawHelper.drawTextImage(gc, text, textAlign, image, imageAlign, x + 2 + leftMargin, y + 2 + topMargin, w - 3 - leftMargin, h - 3 - topMargin);
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            gc.setForeground(prevForeground);
            gc.setBackground(prevBackground);
            throw throwable;
        }
        gc.setForeground(prevForeground);
        gc.setBackground(prevBackground);
    }

    public static void drawButtonDown(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h) {
        Display display = Display.getCurrent();
        DrawHelper.drawButtonDown(gc, text, textAlign, image, imageAlign, x, y, w, h, display.getSystemColor(22), display.getSystemColor(18), 2, 2);
    }

    public static void drawButtonDown(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle r) {
        DrawHelper.drawButtonDown(gc, text, textAlign, image, imageAlign, r.x, r.y, r.width, r.height);
    }

    public static void drawButtonDown(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h, Color face) {
        Display display = Display.getCurrent();
        DrawHelper.drawButtonDown(gc, text, textAlign, image, imageAlign, x, y, w, h, face, display.getSystemColor(18), 2, 2);
    }

    public static void drawButtonDeepDown(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h) {
        Display display = Display.getCurrent();
        gc.setForeground(display.getSystemColor(2));
        gc.drawLine(x, y, x + w - 2, y);
        gc.drawLine(x, y, x, y + h - 2);
        gc.setForeground(display.getSystemColor(1));
        gc.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        gc.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        gc.setForeground(display.getSystemColor(22));
        gc.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        gc.drawLine(x + w - 2, y + h - 2, x + w - 2, y + 1);
        gc.setForeground(display.getSystemColor(21));
        gc.setBackground(display.getSystemColor(22));
        gc.fillRectangle(x + 2, y + 2, w - 4, 1);
        gc.fillRectangle(x + 1, y + 2, 2, h - 4);
        gc.setBackground(display.getSystemColor(22));
        DrawHelper.drawTextImage(gc, text, textAlign, image, imageAlign, x + 2 + 1, y + 2 + 1, w - 4, h - 3 - 1);
    }

    public static void drawButtonDeepDown(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle r) {
        DrawHelper.drawButtonDeepDown(gc, text, textAlign, image, imageAlign, r.x, r.y, r.width, r.height);
    }

    public static void drawFlatButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h, Color face, Color shadowLight, Color shadowNormal, int leftMargin, int topMargin) {
        Color prevForeground = gc.getForeground();
        Color prevBackground = gc.getBackground();
        try {
            gc.setForeground(shadowLight);
            gc.drawLine(x, y, x + w - 1, y);
            gc.drawLine(x, y, x, y + h);
            gc.setForeground(shadowNormal);
            gc.drawLine(x + w, y, x + w, y + h);
            gc.drawLine(x + 1, y + h, x + w, y + h);
            gc.setBackground(face);
            gc.fillRectangle(x + 1, y + 1, leftMargin, h - 1);
            gc.fillRectangle(x + 1, y + 1, w - 1, topMargin);
            gc.setBackground(face);
            gc.setForeground(prevForeground);
            DrawHelper.drawTextImage(gc, text, textAlign, image, imageAlign, x + 1 + leftMargin, y + 1 + topMargin, w - 1 - leftMargin, h - 1 - topMargin);
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            gc.setForeground(prevForeground);
            gc.setBackground(prevBackground);
            throw throwable;
        }
        gc.setForeground(prevForeground);
        gc.setBackground(prevBackground);
    }

    public static void drawShadowImage(GC gc, Image image, int x, int y, int alpha) {
        Display display = Display.getCurrent();
        Point imageSize = new Point(image.getBounds().width, image.getBounds().height);
        ImageData imgData = new ImageData(imageSize.x, imageSize.y, 24, new PaletteData(255, 255, 255));
        imgData.alpha = alpha;
        Image img = new Image((Device)display, imgData);
        GC imgGC = new GC((Drawable)img);
        imgGC.drawImage(image, 0, 0);
        gc.drawImage(img, x, y);
        imgGC.dispose();
        img.dispose();
    }

    static {
        m_StringExtentCache = new HashMap();
    }
}

