/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.calendar;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.calendar.ExtendedInputDialog;
import com.tssap.dtr.client.eclipse.ui.calendar.SelectableCalendar;
import com.tssap.dtr.client.eclipse.ui.calendar.SelectableClock;
import com.tssap.dtr.client.eclipse.ui.calendar.SelectableTimeZone;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CalendarInputDialog
extends ExtendedInputDialog
implements IPropertyChangeListener {
    private SelectableCalendar fCalendar;
    private SelectableTimeZone fZone;
    private SelectableClock fClock;
    private Composite fCalendarParent;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$calendar$CalendarInputDialog == null ? (class$com$tssap$dtr$client$eclipse$ui$calendar$CalendarInputDialog = CalendarInputDialog.class$("com.tssap.dtr.client.eclipse.ui.calendar.CalendarInputDialog")) : class$com$tssap$dtr$client$eclipse$ui$calendar$CalendarInputDialog));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$calendar$CalendarInputDialog;

    public CalendarInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
    }

    protected Control createDialogArea(Composite parent) {
        final Composite dialogParent = (Composite)super.createDialogArea(parent);
        dialogParent.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        dialogParent.setLayout((Layout)layout);
        final Button but = new Button(this.getAdditions(), 4);
        but.setAlignment(1024);
        but.setLayoutData((Object)new GridData(128));
        but.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (but.getAlignment() == 1024) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.getDefault());
                    int year = Calendar.getInstance().get(1);
                    int month = Calendar.getInstance().get(2) + 1;
                    int day = Calendar.getInstance().get(5);
                    int hour = Calendar.getInstance().get(11);
                    int minute = Calendar.getInstance().get(12);
                    int second = Calendar.getInstance().get(13);
                    try {
                        Calendar localCalendar = Calendar.getInstance();
                        Date currentDate = dateFormat.parse(CalendarInputDialog.this.getValue());
                        localCalendar.setTime(currentDate);
                        year = localCalendar.get(1);
                        month = localCalendar.get(2) + 1;
                        day = localCalendar.get(5);
                        hour = localCalendar.get(11);
                        minute = localCalendar.get(12);
                        second = localCalendar.get(13);
                    }
                    catch (ParseException e1) {
                        LogUtil.logException((Location)LOCATION, (Throwable)e1);
                    }
                    but.setAlignment(128);
                    CalendarInputDialog.this.fCalendarParent = new Composite(dialogParent, 0);
                    CalendarInputDialog.this.fCalendarParent.setLayoutData((Object)new GridData(768));
                    GridLayout layout = new GridLayout();
                    layout.numColumns = 2;
                    CalendarInputDialog.this.fCalendarParent.setLayout((Layout)layout);
                    CalendarInputDialog.this.fCalendar = new SelectableCalendar(CalendarInputDialog.this.fCalendarParent, 0);
                    CalendarInputDialog.this.fCalendar.addPropertyListener(CalendarInputDialog.this);
                    CalendarInputDialog.this.fCalendar.setDay(day);
                    CalendarInputDialog.this.fCalendar.setMonth(month);
                    CalendarInputDialog.this.fCalendar.setYear(year);
                    GridData data = new GridData(32);
                    CalendarInputDialog.this.fCalendar.setLayoutData(data);
                    Composite clockParent = new Composite(CalendarInputDialog.this.fCalendarParent, 0);
                    layout = new GridLayout();
                    clockParent.setLayout((Layout)layout);
                    clockParent.setLayoutData((Object)new GridData(1808));
                    CalendarInputDialog.this.fClock = new SelectableClock(clockParent, 0, hour, minute, second);
                    CalendarInputDialog.this.fClock.addPropertyListener(CalendarInputDialog.this);
                    CalendarInputDialog.this.fClock.setLayoutData(new GridData(800));
                    CalendarInputDialog.this.fZone = new SelectableTimeZone(clockParent, 0);
                    CalendarInputDialog.this.fZone.addPropertyListener(CalendarInputDialog.this);
                    CalendarInputDialog.this.fZone.setLayoutData(new GridData(800));
                } else {
                    but.setAlignment(1024);
                    CalendarInputDialog.this.fCalendar.removePropertyListener(CalendarInputDialog.this);
                    CalendarInputDialog.this.fClock.removePropertyListener(CalendarInputDialog.this);
                    CalendarInputDialog.this.fZone.removePropertyListener(CalendarInputDialog.this);
                    CalendarInputDialog.this.fCalendarParent.dispose();
                }
                CalendarInputDialog.this.getShell().layout(true);
                CalendarInputDialog.super.initializeBounds();
            }
        });
        return dialogParent;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fZone == null || this.fCalendar == null || this.fClock == null) {
            return;
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        f.setTimeZone(this.fZone.getSelectedTimeZone());
        Date date = null;
        try {
            date = f.parse(String.valueOf(this.fCalendar.getYear()) + "-" + String.valueOf(this.fCalendar.getMonth()) + "-" + String.valueOf(this.fCalendar.getDay()) + " " + String.valueOf(this.fClock.getHour()) + ":" + String.valueOf(this.fClock.getMinutes()) + ":" + String.valueOf(this.fClock.getSeconds()));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.getDefault());
            dateFormat.setTimeZone(this.fZone.getSelectedTimeZone());
            this.setValue(dateFormat.format(date));
        }
        catch (ParseException e) {
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

