/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.automerge;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.automerge.AutomergeException;
import com.tssap.dtr.client.eclipse.automerge.Collision;
import com.tssap.dtr.client.eclipse.automerge.ICollisionListener;
import com.tssap.dtr.client.eclipse.ui.actions.VfsObjectSelectionAction;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeDialog;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsCollision;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

abstract class SingleSelectionTableAction
extends Action
implements ICollisionListener {
    private AutomergeDialog fDialog;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$automerge$SingleSelectionTableAction == null ? (class$com$tssap$dtr$client$eclipse$ui$automerge$SingleSelectionTableAction = SingleSelectionTableAction.class$("com.tssap.dtr.client.eclipse.ui.automerge.SingleSelectionTableAction")) : class$com$tssap$dtr$client$eclipse$ui$automerge$SingleSelectionTableAction));
    protected Collision fCollisionToResolve;
    protected boolean fMergeFileChanged = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$automerge$SingleSelectionTableAction;

    public SingleSelectionTableAction(AutomergeDialog dialog) {
        this.fDialog = dialog;
    }

    protected Collision getSelectedCollision() {
        ISelection selection = this.getDialog().getCollisionViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (sel.size() > 1) {
                Logbook.getErrorChapter().println("Auto-Merge - More than 1 item is selected");
                return null;
            }
            if (sel.size() > 0) {
                return (Collision)sel.getFirstElement();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        Collision col = this.getSelectedCollision();
        return col != null && !col.isResolved();
    }

    protected void runAction(final VfsObjectSelectionAction action, final IStructuredSelection selection) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Action fakeAction = new Action(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }
                };
                IViewPart part = null;
                IWorkbenchWindow window = BluebirdPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    window = BluebirdPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0];
                }
                IViewReference[] references = window.getActivePage().getViewReferences();
                int i = 0;
                while (i < references.length) {
                    part = references[i].getView(false);
                    if (part != null) break;
                    ++i;
                }
                if (part == null) {
                    part = window.getActivePage().getViewReferences()[0].getView(true);
                }
                action.setActivePart((IAction)fakeAction, (IWorkbenchPart)part);
                action.selectionChanged((IAction)fakeAction, (ISelection)selection);
                action.run((IAction)fakeAction);
            }
        });
    }

    protected AutomergeDialog getDialog() {
        return this.fDialog;
    }

    protected File createTmpFile(String content, String fileExtension) {
        File file = null;
        try {
            String extension = fileExtension == null ? null : "." + fileExtension;
            file = File.createTempFile("_automergeResult", extension);
            file.deleteOnExit();
            FileOutputStream stream = new FileOutputStream(file);
            DataOutputStream dataOutput = new DataOutputStream(stream);
            dataOutput.writeBytes(content);
            dataOutput.close();
        }
        catch (IOException e) {
            Logbook.getErrorChapter().println("IOException occured while processing " + file.getName() + " file: " + e.getMessage());
            LogUtil.logException((Location)LOCATION, (Throwable)e);
        }
        return file;
    }

    protected void handleAutomergeException(AutomergeException exception) {
        this.getDialog().handleAutomergeException(exception);
    }

    public void collisionResolved(IVfsCollision collision) {
        this.fCollisionToResolve.setResolved(true);
        this.fCollisionToResolve = null;
        this.getDialog().getCollisionViewer().refresh();
    }

    public void mergeFileChanged(IVfsCollision collision) {
        this.fMergeFileChanged = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

