/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.automerge;

import com.tssap.dtr.client.eclipse.automerge.AutomergeLogType;
import com.tssap.dtr.client.eclipse.automerge.Collision;
import com.tssap.dtr.client.eclipse.ui.actions.DiffMergeSingleSelectionAction;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeDialog;
import com.tssap.dtr.client.eclipse.ui.automerge.SingleSelectionTableAction;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import com.tssap.dtr.client.lib.vfs.IVfsMergeVersion;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

class ManualMergeAction
extends SingleSelectionTableAction {
    private DiffMergeSingleSelectionAction fDiffMergeAction = new DiffMergeSingleSelectionAction(){

        protected String getConfigProperty(String propertyName, String defaultValue) {
            return defaultValue;
        }
    };

    public ManualMergeAction(AutomergeDialog dialog) {
        super(dialog);
    }

    public String getText() {
        return "Merge Conflict Manually";
    }

    public void run() {
        Collision col = this.getSelectedCollision();
        DiffMergeSingleSelectionAction mergeAction = this.getMergeAction();
        if (col.getOriginalCollision() instanceof IVfsCheckinCollision) {
            IVfsCheckinCollision collision = (IVfsCheckinCollision)col.getOriginalCollision();
            this.fCollisionToResolve = col;
            mergeAction.mergeCheckinCollision(collision, this);
        } else if (col.getOriginalCollision() instanceof IVfsIntegrateCollision) {
            final IVfsIntegrateCollision collision = (IVfsIntegrateCollision)col.getOriginalCollision();
            this.fCollisionToResolve = col;
            final IVfsMergeVersion[] mergeVersion = new IVfsMergeVersion[1];
            BusyIndicator.showWhile((Display)this.getDialog().getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    mergeVersion[0] = collision.getMergeVersion();
                }
            });
            boolean revertMergeversion = mergeVersion[0] == null;
            mergeAction.resolveIntegrateCollision(collision, revertMergeversion, this);
            if (this.fMergeFileChanged) {
                col.setLocalFileContentChanged(true);
            }
        }
        this.getDialog().refreshCollision(col);
        if (col.isResolved()) {
            this.getDialog().log("Merge version was accepted. Conflict marked as resolved.", AutomergeLogType.INFO);
        }
    }

    private DiffMergeSingleSelectionAction getMergeAction() {
        return this.fDiffMergeAction;
    }
}

