/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.automerge;

import com.tssap.dtr.client.eclipse.automerge.AutomergeLogType;
import com.tssap.dtr.client.eclipse.automerge.Collision;
import com.tssap.dtr.client.eclipse.ui.actions.IntegrateCollisionSelectionAction;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeDialog;
import com.tssap.dtr.client.eclipse.ui.automerge.SingleSelectionTableAction;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class IntegrateDiscardActiveVersionAction
extends SingleSelectionTableAction {
    public IntegrateDiscardActiveVersionAction(AutomergeDialog dialog) {
        super(dialog);
    }

    public String getText() {
        return "Discard Active Version";
    }

    public void run() {
        IntegrateCollisionSelectionAction intAction = new IntegrateCollisionSelectionAction(){

            protected String getConfigProperty(String propertyName, String defaultValue) {
                if (propertyName.equalsIgnoreCase("ActionName")) {
                    return "AcceptColliding";
                }
                return defaultValue;
            }
        };
        Collision col = this.getSelectedCollision();
        if (col.getOriginalCollision() instanceof IVfsIntegrateCollision) {
            IVfsIntegrateCollision intCollision = (IVfsIntegrateCollision)col.getOriginalCollision();
            StructuredSelection selection = new StructuredSelection((Object)intCollision);
            this.runAction(intAction, (IStructuredSelection)selection);
            if (intCollision.getInternalState() == IVfsIntegrateCollision.VfsIntegrateCollisionInternalState.DISCARD_ARROW_DRAWN) {
                col.setResolved(true);
                this.getDialog().refreshCollision(col);
                this.getDialog().log("Active Version was discarded. Conflict marked as resolved.", AutomergeLogType.INFO);
            }
        }
    }
}

