/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.automerge;

import com.tssap.dtr.client.eclipse.automerge.Collision;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class CollisionTableViewer
extends CheckboxTableViewer
implements SelectionListener {
    private Color fGrayColor = Display.getCurrent().getSystemColor(33);

    public CollisionTableViewer(Table table) {
        super(table);
        table.addSelectionListener((SelectionListener)this);
    }

    public void refresh() {
        super.refresh();
        Color redColor = Display.getDefault().getSystemColor(3);
        Color normalBackground = Display.getDefault().getSystemColor(25);
        TableItem[] items = this.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            Collision col = (Collision)items[i].getData();
            if (col.getIntersectingDifferences() > 0) {
                items[i].setBackground(redColor);
            } else {
                items[i].setBackground(normalBackground);
            }
            if (col.isResolved() || col.isBinary()) {
                items[i].setGrayed(true);
                items[i].setForeground(this.fGrayColor);
                items[i].setBackground(normalBackground);
            }
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget instanceof Table) {
            TableItem[] items = ((Table)e.widget).getItems();
            int i = 0;
            while (i < items.length) {
                Collision col = (Collision)items[i].getData();
                if (col.isResolved()) {
                    items[i].setChecked(true);
                }
                if (col.isBinary()) {
                    items[i].setChecked(false);
                }
                ++i;
            }
        }
    }

    public void uncheckAll() {
        this.setAllChecked(false);
    }

    public void checkActiveChanges() {
        Object[] childrens = this.getRawChildren(this.getInput());
        this.uncheckAll();
        int i = 0;
        while (i < childrens.length) {
            Collision col = (Collision)childrens[i];
            if (col.getActiveVersionDifferences() > 0) {
                this.setChecked(col, true);
            }
            ++i;
        }
    }

    public void checkCollidingChanges() {
        Object[] childrens = this.getRawChildren(this.getInput());
        this.uncheckAll();
        int i = 0;
        while (i < childrens.length) {
            Collision col = (Collision)childrens[i];
            if (col.getMergeVersionDifferences() > 0) {
                this.setChecked(col, true);
            }
            ++i;
        }
    }

    public void checkIntersectingChanges() {
        Object[] childrens = this.getRawChildren(this.getInput());
        int i = 0;
        while (i < childrens.length) {
            Collision col = (Collision)childrens[i];
            if (col.getIntersectingDifferences() > 0) {
                this.setChecked(col, true);
            }
            ++i;
        }
    }

    public void checkNoIntersectingChanges() {
        Object[] childrens = this.getRawChildren(this.getInput());
        int i = 0;
        while (i < childrens.length) {
            Collision col = (Collision)childrens[i];
            if (col.getIntersectingDifferences() == 0) {
                this.setChecked(col, true);
            }
            ++i;
        }
    }

    public void uncheckActiveChnages() {
        Object[] childrens = this.getRawChildren(this.getInput());
        int i = 0;
        while (i < childrens.length) {
            Collision col = (Collision)childrens[i];
            if (col.getActiveVersionDifferences() > 0) {
                this.setChecked(col, false);
            }
            ++i;
        }
    }

    public void uncheckCollidingChanges() {
        Object[] childrens = this.getRawChildren(this.getInput());
        int i = 0;
        while (i < childrens.length) {
            Collision col = (Collision)childrens[i];
            if (col.getMergeVersionDifferences() > 0) {
                this.setChecked(col, false);
            }
            ++i;
        }
    }

    public void uncheckIntersectingChanges() {
        Object[] childrens = this.getRawChildren(this.getInput());
        int i = 0;
        while (i < childrens.length) {
            Collision col = (Collision)childrens[i];
            if (col.getIntersectingDifferences() > 0) {
                this.setChecked(col, false);
            }
            ++i;
        }
    }

    public void uncheckNoIntersectingChanges() {
        Object[] childrens = this.getRawChildren(this.getInput());
        int i = 0;
        while (i < childrens.length) {
            Collision col = (Collision)childrens[i];
            if (col.getIntersectingDifferences() == 0) {
                this.setChecked(col, false);
            }
            ++i;
        }
    }

    public void toggleSelection() {
        TableItem[] items = this.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            this.setChecked(items[i].getData(), !items[i].getChecked());
            ++i;
        }
    }
}

