/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.automerge;

import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class AutomergeToolBarSelectionListener
extends SelectionAdapter {
    private Menu menu = null;
    private AutomergeDialog fDialog;
    private String fID;
    protected static final String CHECK = "Check";
    protected static final String UNCHECK = "Uncheck";

    public AutomergeToolBarSelectionListener(AutomergeDialog dialog, String menuID) {
        this.fDialog = dialog;
        this.fID = menuID;
    }

    private MenuItem createMenuItem(String text, Image image, int id) {
        MenuItem item = new MenuItem(this.menu, 0);
        if (text != null) {
            item.setText(text);
        }
        if (image != null) {
            item.setImage(image);
        }
        item.setData((Object)new Integer(id));
        item.addSelectionListener((SelectionListener)new MenuItemSelectionListener());
        return item;
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.menu == null) {
            Shell shell = this.fDialog.getShell();
            this.menu = new Menu((Control)shell);
            if (this.fID == CHECK) {
                this.createMenuItem("Select All Conflicts", null, 1031);
                this.createMenuItem("Select only Conflicts with Active Version Changes", null, 1032);
                this.createMenuItem("Select only Conflicts with Conflicting Version Changes", null, 1033);
                this.createMenuItem("Select Conflicts with no Intersecting Changes", null, 1034);
            } else if (this.fID == UNCHECK) {
                this.createMenuItem("Unselect All Conflicts", null, 1035);
                this.createMenuItem("Unselect only Conflicts with Active Version Changes", null, 1036);
                this.createMenuItem("Unselect only Conflicts with Conflicting Version Changes", null, 1037);
                this.createMenuItem("Unselect Conflicts with No Intersecting Changes", null, 1038);
            }
        }
        if (event.detail == 4) {
            if (this.menu.isVisible()) {
                this.setMenuVisible(false);
            } else {
                ToolItem toolItem = (ToolItem)event.widget;
                ToolBar toolBar = toolItem.getParent();
                Rectangle toolItemBounds = toolItem.getBounds();
                Point point = toolBar.toDisplay(new Point(toolItemBounds.x, toolItemBounds.y));
                this.menu.setLocation(point.x, point.y + toolItemBounds.height);
                this.setMenuVisible(true);
            }
        }
    }

    private void setMenuVisible(boolean visible) {
        this.menu.setVisible(visible);
    }

    class MenuItemSelectionListener
    extends SelectionAdapter {
        MenuItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            AutomergeToolBarSelectionListener.this.setMenuVisible(false);
            MenuItem item = (MenuItem)e.getSource();
            AutomergeToolBarSelectionListener.this.fDialog.runAction((Integer)item.getData());
        }
    }
}

