/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.automerge;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.automerge.Collision;
import com.tssap.dtr.client.eclipse.automerge.CollisionState;
import com.tssap.dtr.client.eclipse.ui.DAVDecorator;
import com.tssap.dtr.client.eclipse.ui.util.ImageSingletone;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

class AutomergeTableLabelProvider
implements ITableLabelProvider {
    private Map imageTable;
    private ImageSingletone fPseudo = new ImageSingletone("automerge/pseudo.gif");
    private ImageSingletone fIntersect = new ImageSingletone("automerge/intersecting.gif");
    private ImageSingletone fNonIntersect = new ImageSingletone("automerge/nonintersecting.gif");
    private static final ImageSingletone fResolvedImage = new ImageSingletone("automerge/resolved.gif");
    private static final ImageSingletone fInfoImage = new ImageSingletone("info.gif");
    private static final ImageSingletone fWarningImage = new ImageSingletone("warning.gif");
    private static final ImageSingletone fErrorImage = new ImageSingletone("error.gif");
    private Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$automerge$AutomergeTableLabelProvider == null ? (class$com$tssap$dtr$client$eclipse$ui$automerge$AutomergeTableLabelProvider = AutomergeTableLabelProvider.class$("com.tssap.dtr.client.eclipse.ui.automerge.AutomergeTableLabelProvider")) : class$com$tssap$dtr$client$eclipse$ui$automerge$AutomergeTableLabelProvider));
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$automerge$AutomergeTableLabelProvider;

    AutomergeTableLabelProvider() {
    }

    protected final IWorkbenchAdapter getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        return (IWorkbenchAdapter)((IAdaptable)o).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = AutomergeTableLabelProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
    }

    private Image decorateImage(Image image, File file) {
        IResource eclipseResource = BluebirdPlugin.getResource(file);
        DAVTeamProvider provider = BluebirdPlugin.getDAVTeamProvider(eclipseResource);
        IVfsFile repositoryFile = provider.getFolderItem(eclipseResource).asFile();
        return DAVDecorator.decorateFolderItem(image, (IVfsFolderItem)repositoryFile);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 6 && element instanceof Collision) {
            Collision collision = (Collision)element;
            if (collision.getCollisionState() == CollisionState.RESOLVED) {
                return fResolvedImage.getImage();
            }
            if (collision.getCollisionState() == CollisionState.PARTIALLY_RESOLVED) {
                return fWarningImage.getImage();
            }
            return fInfoImage.getImage();
        }
        if (columnIndex != 1) {
            return null;
        }
        IWorkbenchAdapter adapter = null;
        IResource resource = null;
        if (element instanceof Collision) {
            Image image;
            ImageDescriptor descriptor;
            Collision col = (Collision)element;
            resource = BluebirdPlugin.getResource(col.getMergeFile());
            adapter = this.getAdapter(resource);
            if (adapter == null) {
                try {
                    return this.getDTRResourceImage(col.getMergeFile());
                }
                catch (VfsException e) {
                    this.LOCATION.errorT("Catched: " + e.getMessage());
                    LogUtil.logCaughtException((Location)this.LOCATION, (Throwable)e);
                }
            }
            if ((descriptor = adapter.getImageDescriptor((Object)resource)) == null) {
                return null;
            }
            if (this.imageTable == null) {
                this.imageTable = new Hashtable(40);
            }
            if ((image = (Image)this.imageTable.get(descriptor)) == null) {
                image = descriptor.createImage();
                this.imageTable.put(descriptor, image);
            }
            return this.decorateImage(image, col.getMergeFile());
        }
        return null;
    }

    private Image getDTRResourceImage(File file) throws VfsException {
        IVfsContext context = Configuration.getConfiguration().getActiveClient().getContext();
        IVersionedFileSystemManager manager = VfsManagerProvider.getInstance().getVersionedFileSystemManager(context);
        if (manager == null) {
            return null;
        }
        IVfsFolderItem folderItem = manager.getFolderItem(file.getAbsolutePath());
        if (folderItem == null) {
            return null;
        }
        return DAVDecorator.decorateFolderItem(null, folderItem);
    }

    private String getFileName(File file) {
        String label = "";
        IResource eclipeFile = BluebirdPlugin.getResource(file);
        IWorkbenchAdapter adapter = this.getAdapter(eclipeFile);
        if (adapter == null && file != null) {
            label = file.getName() + " - ( " + file.getAbsolutePath() + " )";
        }
        if (adapter == null) {
            return label;
        }
        label = adapter.getLabel((Object)eclipeFile);
        if (eclipeFile instanceof IFile) {
            label = label + " - ( " + ((IFile)eclipeFile).getFullPath().toOSString() + " )";
        }
        return label;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Collision) {
            Collision col = (Collision)element;
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return this.getFileName(col.getMergeFile());
                }
                case 2: {
                    return String.valueOf(col.getActiveVersionDifferences());
                }
                case 3: {
                    return String.valueOf(col.getMergeVersionDifferences());
                }
                case 4: {
                    return String.valueOf(col.getIntersectingDifferences());
                }
                case 5: {
                    return String.valueOf(col.getPseudoDifferences());
                }
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.imageTable != null) {
            Iterator i = this.imageTable.values().iterator();
            while (i.hasNext()) {
                ((Image)i.next()).dispose();
            }
            this.imageTable = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

