/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.automerge;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class AutomergeSorter
extends ViewerSorter {
    private int fColumn = 1;
    private boolean fAscending = true;

    public void sort(final Viewer viewer, Object[] elements) {
        Arrays.sort(elements, new Comparator(){

            public int compare(Object a, Object b) {
                return AutomergeSorter.this.compare(viewer, a, b);
            }
        });
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        String name2;
        String name1;
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (viewer == null || !(viewer instanceof ContentViewer)) {
            name1 = e1.toString();
            name2 = e2.toString();
        } else {
            IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
            if (prov instanceof ITableLabelProvider) {
                ITableLabelProvider lprov = (ITableLabelProvider)prov;
                name1 = lprov.getColumnText(e1, this.fColumn);
                name2 = lprov.getColumnText(e2, this.fColumn);
            } else {
                name1 = e1.toString();
                name2 = e2.toString();
            }
        }
        if (name1 == null) {
            name1 = "";
        }
        if (name2 == null) {
            name2 = "";
        }
        return this.fAscending ? this.collator.compare(name1, name2) : this.collator.compare(name2, name1);
    }

    public void setColumn(int column) {
        this.fColumn = column;
    }

    public int getColumn() {
        return this.fColumn;
    }

    public void reverseOrder() {
        this.fAscending = !this.fAscending;
    }

    public boolean isAscending() {
        return this.fAscending;
    }
}

