/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.automerge;

import com.tssap.dtr.client.eclipse.automerge.AutomergeException;
import com.tssap.dtr.client.eclipse.automerge.Collision;
import com.tssap.dtr.client.eclipse.ui.actions.compare.DiffEditorVersionsInput;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeDialog;
import com.tssap.dtr.client.eclipse.ui.automerge.SingleSelectionTableAction;
import com.tssap.dtr.client.eclipse.ui.conflict.DAVCompareDialog;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import java.io.File;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.runtime.Path;

class AutomergePreviewAction
extends SingleSelectionTableAction {
    public AutomergePreviewAction(AutomergeDialog dialog) {
        super(dialog);
    }

    public boolean isEnabled() {
        boolean generalSwitch = super.isEnabled();
        Collision col = this.getSelectedCollision();
        if (generalSwitch && col.isBinary()) {
            return false;
        }
        return generalSwitch;
    }

    public String getText() {
        return "Visual Auto-Merge Preview";
    }

    public void run() {
        Collision col = this.getSelectedCollision();
        try {
            String[] stringArray;
            IVfsVersion[] iVfsVersionArray;
            Path filePath = new Path(this.getSelectedCollision().getMergeFilePath());
            File mergedFile = this.createTmpFile(this.getDialog().getInput().getPreviewResult(col, this.getDialog().isForce()), filePath.getFileExtension());
            IVfsVersion ancestorVersion = col.getAncestorVersion();
            if (col.getRepositoryVersion() == null) {
                IVfsVersion[] iVfsVersionArray2 = new IVfsVersion[1];
                iVfsVersionArray = iVfsVersionArray2;
                iVfsVersionArray2[0] = col.getCompareVersion();
            } else {
                IVfsVersion[] iVfsVersionArray3 = new IVfsVersion[2];
                iVfsVersionArray3[0] = col.getCompareVersion();
                iVfsVersionArray = iVfsVersionArray3;
                iVfsVersionArray3[1] = col.getRepositoryVersion();
            }
            IVfsVersion[] versions = iVfsVersionArray;
            if (col.getRepositoryVersion() == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = col.getCompareVersionTitle();
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = col.getCompareVersionTitle();
                stringArray = stringArray3;
                stringArray3[1] = col.getRepositoryVersionTitle();
            }
            String[] titles = stringArray;
            DiffEditorVersionsInput input = new DiffEditorVersionsInput(mergedFile, versions, ancestorVersion, false, titles);
            input.setCustomTitle("Compare Merged Version with:");
            CompareConfiguration config = input.getCompareConfiguration();
            config.setLeftEditable(false);
            config.setRightEditable(false);
            config.setAncestorLabel("Common Ancestor : " + ancestorVersion.getLocationInGraph());
            config.setLeftLabel("Content after performing Auto-Merge");
            input.setTitle(col.getMergeFile().getName() + " - Result after performing Auto-Merge");
            DAVCompareDialog dialog = new DAVCompareDialog(this.getDialog().getShell(), input);
            dialog.open();
        }
        catch (AutomergeException e) {
            this.handleAutomergeException(e);
        }
    }
}

