/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.automerge;

import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.automerge.AutomergeEngine;
import com.tssap.dtr.client.eclipse.automerge.AutomergeException;
import com.tssap.dtr.client.eclipse.automerge.AutomergeLogType;
import com.tssap.dtr.client.eclipse.automerge.Collision;
import com.tssap.dtr.client.eclipse.automerge.CollisionState;
import com.tssap.dtr.client.eclipse.automerge.IAutomergeLogListener;
import com.tssap.dtr.client.eclipse.automerge.MessageHandler;
import com.tssap.dtr.client.eclipse.preference.DtrPreferenceManager;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeAction;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeLogContentProvider;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeLogEngine;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeLogLabelProvider;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergePreviewAction;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeSorter;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeTableContentProvider;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeTableLabelProvider;
import com.tssap.dtr.client.eclipse.ui.automerge.AutomergeToolBarSelectionListener;
import com.tssap.dtr.client.eclipse.ui.automerge.CheckinAcceptActiveVersionAction;
import com.tssap.dtr.client.eclipse.ui.automerge.CheckinAcceptLocalVersionAction;
import com.tssap.dtr.client.eclipse.ui.automerge.CheckinCompareWithActiveVersionAction;
import com.tssap.dtr.client.eclipse.ui.automerge.CollisionTableViewer;
import com.tssap.dtr.client.eclipse.ui.automerge.ConsolePreviewAction;
import com.tssap.dtr.client.eclipse.ui.automerge.IntegrateDiscardActiveVersionAction;
import com.tssap.dtr.client.eclipse.ui.automerge.IntegrateDiscardCollidingVersionAction;
import com.tssap.dtr.client.eclipse.ui.automerge.IntegrateShowDifferenceAction;
import com.tssap.dtr.client.eclipse.ui.automerge.ManualMergeAction;
import com.tssap.dtr.client.eclipse.ui.automerge.MarkAsResolvedAction;
import com.tssap.dtr.client.eclipse.ui.util.DynamicMenuManager;
import com.tssap.dtr.client.eclipse.ui.util.ImageSingletone;
import com.tssap.dtr.client.eclipse.ui.util.LayoutHelper;
import com.tssap.dtr.client.eclipse.ui.util.ResizableTitleDialog;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsCollision;
import com.tssap.dtr.client.lib.vfs.IVfsIntegrateCollision;
import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class AutomergeDialog
extends ResizableTitleDialog
implements IMenuListener,
IAutomergeLogListener {
    private static final String AUTO_MERGE_DIALOG_LOCATION = "com.tssap.dtr.client.eclipse_AutomergeDialogLocation";
    private static final String AUTO_MERGE_DIALOG_SIZE = "com.tssap.dtr.client.eclipse_AutomergeDialogSize";
    private DtrPreferenceManager fManager = BluebirdPlugin.getDefault().getPreferenceManager();
    private AutomergeEngine fInput;
    private AutomergeLogEngine fLogEngine = new AutomergeLogEngine();
    private CollisionTableViewer fViewer;
    private TableViewer fLog;
    private Button fForceAutomerge;
    private Button fMarkAsResolved;
    private ToolItem fPreviewToolItem;
    private ToolItem fAutomergeToolitem;
    private IAction fAutomergeAction;
    private IAction fManualMergeAction;
    private IAction fAutomergePreviewAction;
    private IAction fAutomergeVisualPreviewAction;
    private IAction fMarkAsResolvedAction;
    private IAction fCheckin_AcceptActiveAction;
    private IAction fCheckin_AcceptLocalAction;
    private IAction fCheckin_ComapreWithActiveAction;
    private IAction fIntegrate_DiscardCollidingAction;
    private IAction fIntegrate_DiscardActiveAction;
    private IAction fIntegrate_ShowDifferenceAction;
    private IAction fCopySelectedToClipboardAction;
    private IAction fCopyAllToClipboardAction;
    private IAction fClearConsole;
    protected static final int PREVIEW_NO_RESOLVE_ID = 1025;
    protected static final String PREVIEW_NO_RESOLVE_LABEL = "Do not Resolve Conflicts After Finish (Console)";
    protected static final int PREVIEW_RESOLVE_ID = 1026;
    protected static final String PREVIEW_RESOLVE_LABEL = "Resolve Conflicts After Finish (Console)";
    protected static final String PREVIEW_LABEL = "Preview (Console)";
    protected static final int PREVIEW_ID = 1027;
    protected static final int AUTOMERGE_NO_RESOLVE_ID = 1028;
    protected static final String AUTOMERGE_NO_RESOLVE_LABEL = "Do not Resolve Conflicts After Finish";
    protected static final int AUTOMERGE_RESOLVE_ID = 1029;
    protected static final String AUTOMERGE_RESOLVE_LABEL = "Resolve Conflicts After Finish";
    protected static final int AUTOMERGE_ID = 1030;
    protected static final String AUTOMERGE_LABEL = "Auto-Merge";
    protected static final int CHECK_ALL_ID = 1031;
    protected static final String CHECK_ALL_LABEL = "Select All Conflicts";
    protected static final int CHECK_ACTIVE_CHANGES_ID = 1032;
    protected static final String CHECK_ACTIVE_CHANGES_LABEL = "Select only Conflicts with Active Version Changes";
    protected static final int CHECK_COLLIDING_CHANGES_ID = 1033;
    protected static final String CHECK_COLLIDING_CHANGES_LABEL = "Select only Conflicts with Conflicting Version Changes";
    protected static final int CHECK_NO_INTERSECTING_CHANGES_ID = 1034;
    protected static final String CHECK_NO_INTERSECTING_CHANGES_LABEL = "Select Conflicts with no Intersecting Changes";
    protected static final int UN_CHECK_ALL_ID = 1035;
    protected static final String UN_CHECK_ALL_LABEL = "Unselect All Conflicts";
    protected static final int UN_CHECK_ACTIVE_CHANGES_ID = 1036;
    protected static final String UN_CHECK_ACTIVE_CHANGES_LABEL = "Unselect only Conflicts with Active Version Changes";
    protected static final int UN_CHECK_COLLIDING_CHANGES_ID = 1037;
    protected static final String UN_CHECK_COLLIDING_CHANGES_LABEL = "Unselect only Conflicts with Conflicting Version Changes";
    protected static final int UN_CHECK_NO_INTERSECTING_CHANGES_ID = 1038;
    protected static final String UN_CHECK_NO_INTERSECTING_CHANGES_LABEL = "Unselect Conflicts with No Intersecting Changes";
    protected static final int TOGGLE_SELECTION_ID = 1039;
    protected static final String TOGGLE_SELECTION_LABEL = "Toggle Selection";
    private String CONSOLE_ID = "Console";
    private String TABLE_ID = "Table";
    private static final ImageSingletone fInfoImage = new ImageSingletone("info.gif");
    private static final ImageSingletone fWarningImage = new ImageSingletone("warning.gif");
    private static final ImageSingletone fResolvedImage = new ImageSingletone("automerge/resolved.gif");
    private static final ImageSingletone fCheckImage = new ImageSingletone("automerge/check.gif");
    private static final ImageSingletone fUncheckImage = new ImageSingletone("automerge/uncheck.gif");
    private static final ImageSingletone fToggleImage = new ImageSingletone("automerge/toggle.gif");
    private static final ImageSingletone fAscending = new ImageSingletone("automerge/ascending.gif");
    private static final ImageSingletone fDescending = new ImageSingletone("automerge/descending.gif");

    public AutomergeDialog(Shell parent, String title, Image titleImage) {
        super(parent, title, titleImage);
        this.createTableMenuActions();
        this.createConsoleMenuActions();
    }

    protected Point getInitialSize() {
        Point sizePoint;
        String sizeString = this.getPreferenceStore().getString(AUTO_MERGE_DIALOG_SIZE);
        if (sizeString.length() > 0 && (sizePoint = LayoutHelper.parseCoordinates(sizeString)) != null) {
            return sizePoint;
        }
        return super.getInitialSize();
    }

    protected Point getInitialLocation(Point initialSize) {
        Point locationPoint;
        String locationString = this.getPreferenceStore().getString(AUTO_MERGE_DIALOG_LOCATION);
        if (locationString.length() > 0 && (locationPoint = LayoutHelper.parseCoordinates(locationString)) != null) {
            return locationPoint;
        }
        return super.getInitialLocation(initialSize);
    }

    private void persistShellGeometry() {
        Point shellLocation = this.getShell().getLocation();
        Point shellSize = this.getShell().getSize();
        String locationString = LayoutHelper.serializeCoords(shellLocation);
        String sizeString = LayoutHelper.serializeCoords(shellSize);
        this.getPreferenceStore().setValue(AUTO_MERGE_DIALOG_LOCATION, locationString);
        this.getPreferenceStore().setValue(AUTO_MERGE_DIALOG_SIZE, sizeString);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1027, PREVIEW_LABEL, true);
        this.createButton(parent, 1030, AUTOMERGE_LABEL, false);
        this.createButton(parent, 1, "Exit", false);
    }

    private void createOutput(Composite parent) {
        Label outputLabel = new Label(parent, 0);
        outputLabel.setText("Auto Merge output Console:");
        outputLabel.setLayoutData((Object)new GridData(32));
        Table logTable = new Table(parent, 68354);
        TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(logTable, 0);
        column.setText("");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, 20, false));
        column.setResizable(false);
        TableColumn messagecolumn = new TableColumn(logTable, 0);
        messagecolumn.setText("Message");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2000, 80, true));
        messagecolumn.setResizable(true);
        logTable.setLayout((Layout)layout);
        logTable.setHeaderVisible(false);
        logTable.setLinesVisible(false);
        GridData layoutData = new GridData(1808);
        logTable.setLayoutData((Object)layoutData);
        this.fLog = new TableViewer(logTable);
        this.fLog.setContentProvider((IContentProvider)new AutomergeLogContentProvider());
        this.fLog.setLabelProvider((IBaseLabelProvider)new AutomergeLogLabelProvider());
        this.fLog.setInput((Object)this.fLogEngine);
        DynamicMenuManager logMenuManager = new DynamicMenuManager("Console menu", this.CONSOLE_ID);
        Menu logMenu = logMenuManager.createContextMenu((Control)logTable);
        logMenuManager.addMenuListener(this);
        logMenuManager.setRemoveAllWhenShown(true);
        logTable.setMenu(logMenu);
        messagecolumn.pack();
    }

    private void createCollisionTable(Composite parent) {
        Composite tableParent = new Composite(parent, 0);
        tableParent.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        tableParent.setLayout((Layout)gridLayout);
        Composite toolBarComposite = new Composite(tableParent, 0);
        toolBarComposite.setLayoutData((Object)new GridData(1040));
        toolBarComposite.setLayout((Layout)new GridLayout());
        ToolBar checkBar = new ToolBar(toolBarComposite, 256);
        checkBar.setLayoutData((Object)new GridData(2));
        ToolItem checkItem = new ToolItem(checkBar, 4);
        checkItem.setToolTipText("Select All");
        checkItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 4) {
                    AutomergeDialog.this.buttonPressed(1031);
                }
            }
        });
        checkItem.setImage(fCheckImage.getImage());
        checkItem.addSelectionListener((SelectionListener)new AutomergeToolBarSelectionListener(this, "Check"));
        ToolBar uncheckBar = new ToolBar(toolBarComposite, 256);
        uncheckBar.setLayoutData((Object)new GridData(2));
        ToolItem uncheckItem = new ToolItem(uncheckBar, 4);
        uncheckItem.setToolTipText("Deselect All");
        uncheckItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 4) {
                    AutomergeDialog.this.buttonPressed(1035);
                }
            }
        });
        uncheckItem.setImage(fUncheckImage.getImage());
        uncheckItem.addSelectionListener((SelectionListener)new AutomergeToolBarSelectionListener(this, "Uncheck"));
        Button toggleSelection = new Button(toolBarComposite, 8);
        toggleSelection.setToolTipText(TOGGLE_SELECTION_LABEL);
        toggleSelection.setImage(fToggleImage.getImage());
        toggleSelection.setLayoutData((Object)new GridData(768));
        toggleSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomergeDialog.this.buttonPressed(1039);
            }
        });
        final AutomergeSorter sorter = new AutomergeSorter();
        final Table table = new Table(tableParent, 68132);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fViewer = new CollisionTableViewer(table);
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = table.indexOf((TableColumn)e.widget);
                int oldColumn = sorter.getColumn();
                sorter.setColumn(column);
                sorter.reverseOrder();
                table.getColumn(oldColumn).setImage(null);
                ((TableColumn)e.widget).setImage(sorter.isAscending() ? fAscending.getImage() : fDescending.getImage());
                AutomergeDialog.this.fViewer.refresh();
            }
        };
        TableLayout layout = new TableLayout();
        TableColumn column = new TableColumn(table, 0);
        column.setText("");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, false));
        column.setResizable(false);
        column = new TableColumn(table, 0);
        column.setText("File");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(500, true));
        column.addSelectionListener((SelectionListener)headerListener);
        column.setImage(sorter.isAscending() ? fAscending.getImage() : fDescending.getImage());
        column = new TableColumn(table, 0);
        column.setText("Active Version Changes");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        column.addSelectionListener((SelectionListener)headerListener);
        column = new TableColumn(table, 0);
        column.setText("Conflicting Version Changes");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        column.addSelectionListener((SelectionListener)headerListener);
        column = new TableColumn(table, 0);
        column.setText("Intersecting Changes");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        column.addSelectionListener((SelectionListener)headerListener);
        column = new TableColumn(table, 0);
        column.setText("Pseudo Changes");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        column.addSelectionListener((SelectionListener)headerListener);
        column = new TableColumn(table, 0);
        column.setText("");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        table.setLayout((Layout)layout);
        GridData layoutData = new GridData(1840);
        layoutData.heightHint = 100;
        table.setLayoutData((Object)layoutData);
        AutomergeTableContentProvider contentProvider = new AutomergeTableContentProvider();
        this.fViewer.setContentProvider((IContentProvider)contentProvider);
        this.fViewer.setInput(this.fInput);
        AutomergeTableLabelProvider labelProvider = new AutomergeTableLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fViewer.setSorter(sorter);
        DynamicMenuManager menuManager = new DynamicMenuManager("Table menu", this.TABLE_ID);
        Menu menu = menuManager.createContextMenu((Control)table);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this);
        table.setMenu(menu);
        new ToolTipHandler(this.fViewer.getTable().getShell()).activateHoverHelp((Control)this.fViewer.getTable());
    }

    protected Control createDialogArea(Composite parent) {
        Composite out = (Composite)super.createDialogArea(parent);
        Composite messageParent = new Composite(out, 0);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 2;
        messageParent.setLayout((Layout)gLayout);
        messageParent.setLayoutData((Object)new GridData(802));
        Label img = new Label(messageParent, 0);
        img.setLayoutData((Object)new GridData(32));
        img.setImage(JFaceResources.getImage((String)"dialog_info_image"));
        Label txt = new Label(messageParent, 0);
        txt.setText("To perform Auto-Merge on multiple files together, check the files and click 'Auto-Merge'.\nTo merge or preview individual files manually, use the context menu on the selected item.");
        this.createCollisionTable(out);
        this.createOutput(out);
        TableItem[] items = this.fViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            Collision col = (Collision)items[i].getData();
            if (col.isBinary()) {
                items[i].setChecked(false);
            } else {
                items[i].setChecked(true);
            }
            ++i;
        }
        this.fMarkAsResolved = new Button(out, 32);
        this.fMarkAsResolved.setText("Mark conflict as resolved after Auto-Merge");
        this.fMarkAsResolved.setSelection(this.fManager.isAutomergeMarkAsResolved());
        this.fMarkAsResolved.setLayoutData((Object)new GridData(32));
        this.fForceAutomerge = new Button(out, 32);
        this.fForceAutomerge.setText("Force Auto-Merge intersecting changes (needs manual post-pocessing)");
        this.fForceAutomerge.setSelection(this.fManager.isAutomergeForce());
        this.fForceAutomerge.setLayoutData((Object)new GridData(32));
        return out;
    }

    public void setInput(AutomergeEngine input) {
        this.fInput = input;
        Collision[] collisions = input.getCollisions();
        int i = 0;
        while (i < collisions.length) {
            collisions[i].addLogListener(this);
            ++i;
        }
    }

    public AutomergeEngine getInput() {
        return this.fInput;
    }

    public boolean close() {
        Collision[] collisions = this.fInput.getCollisions();
        int i = 0;
        while (i < collisions.length) {
            collisions[i].removeLogListener(this);
            ++i;
        }
        this.persistShellGeometry();
        this.saveSettings();
        return super.close();
    }

    private void saveSettings() {
        this.fManager.setAutomergeForce(this.fForceAutomerge.getSelection());
        this.fManager.setAutomergeMarkAsResolved(this.fMarkAsResolved.getSelection());
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (manager.getId().equals(this.TABLE_ID)) {
            manager.add(this.fAutomergeAction);
            manager.add(this.fManualMergeAction);
            manager.add(this.fMarkAsResolvedAction);
            manager.add((IContributionItem)new Separator());
            MenuManager previewSubMenu = new MenuManager("Preview");
            previewSubMenu.add(this.fAutomergePreviewAction);
            previewSubMenu.add(this.fAutomergeVisualPreviewAction);
            manager.add((IContributionItem)previewSubMenu);
            manager.add((IContributionItem)new Separator("preview"));
            TableItem[] selectedItems = this.fViewer.getTable().getSelection();
            if (selectedItems != null && selectedItems.length > 0) {
                manager.add((IContributionItem)new Separator());
                Collision col = (Collision)selectedItems[0].getData();
                IVfsCollision originalCollision = col.getOriginalCollision();
                if (originalCollision instanceof IVfsCheckinCollision) {
                    manager.add(this.fCheckin_AcceptActiveAction);
                    manager.add(this.fCheckin_AcceptLocalAction);
                    manager.add(this.fCheckin_ComapreWithActiveAction);
                } else if (originalCollision instanceof IVfsIntegrateCollision) {
                    manager.add(this.fIntegrate_DiscardCollidingAction);
                    manager.add(this.fIntegrate_DiscardActiveAction);
                    manager.add(this.fIntegrate_ShowDifferenceAction);
                }
            }
        } else if (manager.getId().equals(this.CONSOLE_ID)) {
            manager.add(this.fClearConsole);
            manager.add((IContributionItem)new Separator("Clipboard actions"));
            manager.add(this.fCopySelectedToClipboardAction);
            manager.add(this.fCopyAllToClipboardAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    public Viewer getCollisionViewer() {
        return this.fViewer;
    }

    private void createTableMenuActions() {
        this.fAutomergeAction = new AutomergeAction(this);
        this.fAutomergeVisualPreviewAction = new AutomergePreviewAction(this);
        this.fManualMergeAction = new ManualMergeAction(this);
        this.fAutomergePreviewAction = new ConsolePreviewAction(this);
        this.fCheckin_AcceptActiveAction = new CheckinAcceptActiveVersionAction(this);
        this.fCheckin_AcceptLocalAction = new CheckinAcceptLocalVersionAction(this);
        this.fCheckin_ComapreWithActiveAction = new CheckinCompareWithActiveVersionAction(this);
        this.fIntegrate_DiscardCollidingAction = new IntegrateDiscardCollidingVersionAction(this);
        this.fIntegrate_DiscardActiveAction = new IntegrateDiscardActiveVersionAction(this);
        this.fIntegrate_ShowDifferenceAction = new IntegrateShowDifferenceAction(this);
        this.fMarkAsResolvedAction = new MarkAsResolvedAction(this);
    }

    private void createConsoleMenuActions() {
        this.fCopyAllToClipboardAction = new Action(){

            public String getText() {
                return "Copy All Output to Clipboard";
            }

            public void run() {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                StringBuffer buffer = new StringBuffer();
                String EOL = System.getProperty("line.separator");
                AutomergeLogEngine.AutomergeMessage[] logItems = AutomergeDialog.this.fLogEngine.getMessages();
                int i = 0;
                while (i < logItems.length) {
                    buffer.append(logItems[i].fMessage);
                    buffer.append(EOL);
                    ++i;
                }
                Object[] data = new Object[]{buffer.toString()};
                Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
                clipboard.setContents(data, transferTypes);
            }

            public boolean isEnabled() {
                return AutomergeDialog.this.fLog.getTable().getItemCount() != 0;
            }
        };
        this.fCopySelectedToClipboardAction = new Action(){

            public String getText() {
                return "Copy Selected Line(s) to Clipboard";
            }

            public boolean isEnabled() {
                return AutomergeDialog.this.fLog.getTable().getSelectionIndices().length != 0;
            }

            public void run() {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                StringBuffer buffer = new StringBuffer();
                String EOL = System.getProperty("line.separator");
                TableItem[] selectedItems = AutomergeDialog.this.fLog.getTable().getSelection();
                int i = 0;
                while (i < selectedItems.length) {
                    buffer.append(((AutomergeLogEngine.AutomergeMessage)selectedItems[i].getData()).fMessage);
                    buffer.append(EOL);
                    ++i;
                }
                Object[] data = new Object[]{buffer.toString()};
                Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
                clipboard.setContents(data, transferTypes);
            }
        };
        this.fClearConsole = new Action(){

            public void run() {
                AutomergeDialog.this.fLog.getTable().deselectAll();
                AutomergeDialog.this.fLogEngine.clear();
                AutomergeDialog.this.fLog.refresh();
            }

            public boolean isEnabled() {
                return AutomergeDialog.this.fLog.getTable().getItemCount() != 0;
            }

            public String getText() {
                return "Clear Console";
            }
        };
    }

    protected void buttonPressed(int buttonId) {
        this.runAction(buttonId);
        super.buttonPressed(buttonId);
    }

    public void runAction(int actionId) {
        switch (actionId) {
            case 1025: {
                this.runPreview(false, this.fForceAutomerge.getSelection());
                break;
            }
            case 1028: {
                this.runAutomerge(false, this.fForceAutomerge.getSelection());
                this.refreshAllCollisions();
                break;
            }
            case 1029: {
                this.runAutomerge(true, this.fForceAutomerge.getSelection());
                this.refreshAllCollisions();
                break;
            }
            case 1032: {
                this.fViewer.checkActiveChanges();
                break;
            }
            case 1033: {
                this.fViewer.checkCollidingChanges();
                break;
            }
            case 1034: {
                this.fViewer.checkNoIntersectingChanges();
                break;
            }
            case 1031: {
                this.fViewer.setAllChecked(true);
                break;
            }
            case 1036: {
                this.fViewer.uncheckActiveChnages();
                break;
            }
            case 1035: {
                this.fViewer.uncheckAll();
                break;
            }
            case 1037: {
                this.fViewer.uncheckCollidingChanges();
                break;
            }
            case 1038: {
                this.fViewer.uncheckNoIntersectingChanges();
                break;
            }
            case 1030: {
                this.runAutomerge(this.fMarkAsResolved.getSelection(), this.fForceAutomerge.getSelection());
                break;
            }
            case 1027: {
                this.runPreview(this.fMarkAsResolved.getSelection(), this.fForceAutomerge.getSelection());
                break;
            }
            case 1039: {
                this.fViewer.toggleSelection();
            }
        }
    }

    private void runAutomerge(final boolean resolve, final boolean forceIntersecting) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                TableItem[] items = AutomergeDialog.this.fViewer.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    Collision col;
                    if (items[i].getChecked() && !(col = (Collision)items[i].getData()).isResolved()) {
                        try {
                            AutomergeDialog.this.fInput.runAutomerge(col, resolve, forceIntersecting);
                            AutomergeDialog.this.refreshCollision(col);
                        }
                        catch (AutomergeException e) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        });
    }

    private void runPreview(final boolean resolve, final boolean forceIntersecting) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                TableItem[] items = AutomergeDialog.this.fViewer.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getChecked()) {
                        try {
                            Collision col = (Collision)items[i].getData();
                            if (!col.isResolved()) {
                                AutomergeDialog.this.fInput.runAutomergePreview(col, resolve, forceIntersecting);
                            }
                        }
                        catch (AutomergeException automergeException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        });
    }

    protected void handleAutomergeException(AutomergeException ex) {
        MessageDialog.openError((Shell)this.getShell(), (String)"Auto-Merge error", (String)ex.getMessage());
    }

    public void refreshAllCollisions() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                AutomergeDialog.this.fInput.updateAllCollisions();
            }
        });
        this.fViewer.refresh();
        this.checkButtons();
    }

    public void refreshCollision(final Collision col) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                AutomergeDialog.this.fInput.updateCollision(col);
            }
        });
        this.fViewer.refresh();
        this.checkButtons();
    }

    protected void checkButtons() {
        Collision[] collisions = this.fInput.getCollisions();
        int i = 0;
        while (i < collisions.length) {
            if (!collisions[i].isResolved() && !collisions[i].isBinary()) {
                return;
            }
            ++i;
        }
        this.disableButton(this.getButton(1028));
        this.disableButton(this.getButton(1029));
        this.disableButton(this.getButton(1025));
        this.disableButton(this.getButton(1026));
        this.disableToolItem(this.fPreviewToolItem);
        this.disableToolItem(this.fAutomergeToolitem);
    }

    private void disableButton(Button button) {
        if (button != null) {
            button.setEnabled(false);
        }
    }

    private void disableToolItem(ToolItem item) {
        if (item != null) {
            item.setEnabled(false);
        }
    }

    public void log(String message, AutomergeLogType type) {
        this.fLogEngine.addMessage(message, type);
        this.fLog.refresh();
        this.fLog.getTable().deselectAll();
        this.fLog.getTable().select(this.fLog.getTable().getItemCount() - 1);
        this.fLog.getTable().showSelection();
    }

    public void logEnd() {
        this.log(" ", null);
    }

    public void logStart() {
        if (this.fLog.getTable().getItemCount() == 0) {
            return;
        }
        this.log("", null);
        this.log("", null);
    }

    public boolean isForce() {
        if (this.fForceAutomerge.isDisposed()) {
            return this.fManager.isAutomergeForce();
        }
        return this.fForceAutomerge.getSelection();
    }

    public boolean isResolve() {
        if (this.fMarkAsResolved.isDisposed()) {
            return this.fManager.isAutomergeMarkAsResolved();
        }
        return this.fMarkAsResolved.getSelection();
    }

    protected static class ToolTipHandler {
        private Shell tipShell;
        private Widget tipWidget;
        private Point tipPosition;
        private int widgetColumn;
        private Label fIconLabel;
        private StyledText styledText;

        public ToolTipHandler(Shell parent) {
            Display display = parent.getDisplay();
            this.tipShell = new Shell(parent, 16384);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 2;
            gridLayout.marginHeight = 1;
            this.tipShell.setLayout((Layout)gridLayout);
            Color bgColor = new Color((Device)parent.getDisplay(), 240, 240, 255);
            this.tipShell.setBackground(bgColor);
            this.createBoldLabel((Composite)this.tipShell, "Conflict description:", null, bgColor, 2);
            this.fIconLabel = this.createBoldLabel((Composite)this.tipShell, "", null, bgColor, 1);
            this.styledText = new StyledText((Composite)this.tipShell, 0);
            this.styledText.setForeground(display.getSystemColor(28));
            this.styledText.setBackground(bgColor);
            this.styledText.setLayoutData((Object)new GridData(772));
        }

        private Label createBoldLabel(Composite parent, String text, Color fg, Color bg, int span) {
            Label label = new Label(parent, 0);
            label.setFont(JFaceResources.getBannerFont());
            label.setText(text);
            if (fg != null) {
                label.setForeground(fg);
            }
            if (bg != null) {
                label.setBackground(bg);
            }
            GridData data = new GridData(34);
            data.horizontalSpan = span;
            label.setLayoutData((Object)data);
            return label;
        }

        private void appendNormal(String normalText) {
            if (normalText != null) {
                this.styledText.append(normalText);
            }
        }

        public void activateHoverHelp(Control control) {
            control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(this, control){
                private final /* synthetic */ Control val$control;
                private final /* synthetic */ ToolTipHandler this$0;
                {
                    this.this$0 = this$0;
                    this.val$control = val$control;
                }

                public void mouseExit(MouseEvent e) {
                    if (ToolTipHandler.access$600(this.this$0).isVisible()) {
                        ToolTipHandler.access$600(this.this$0).setVisible(false);
                    }
                    ToolTipHandler.access$702(this.this$0, null);
                }

                public void mouseHover(MouseEvent event) {
                    Point pt = new Point(event.x, event.y);
                    Widget widget = event.widget;
                    int currentColumn = -1;
                    if (widget instanceof Table) {
                        Table w = (Table)widget;
                        widget = w.getItem(pt);
                        currentColumn = ToolTipHandler.access$800(this.this$0, w, event.x);
                    }
                    if (!(widget instanceof TableItem)) {
                        widget = null;
                    }
                    if (widget == null) {
                        ToolTipHandler.access$600(this.this$0).setVisible(false);
                        ToolTipHandler.access$702(this.this$0, null);
                        return;
                    }
                    if (widget == ToolTipHandler.access$700(this.this$0) && currentColumn == ToolTipHandler.access$900(this.this$0)) {
                        return;
                    }
                    ToolTipHandler.access$702(this.this$0, widget);
                    ToolTipHandler.access$902(this.this$0, currentColumn);
                    TableItem tableItem = (TableItem)widget;
                    Rectangle bounds = tableItem.getBounds(currentColumn);
                    pt = new Point(bounds.x, bounds.y);
                    ToolTipHandler.access$1002(this.this$0, this.val$control.toDisplay(pt));
                    if (currentColumn == 1) {
                        ToolTipHandler.access$1000((ToolTipHandler)this.this$0).x += 18;
                    }
                    ToolTipHandler.access$1100(this.this$0).setText("");
                    ToolTipHandler.access$1200(this.this$0, (Collision)widget.getData());
                    ToolTipHandler.access$600(this.this$0).pack();
                    ToolTipHandler.access$1300(this.this$0, ToolTipHandler.access$600(this.this$0), ToolTipHandler.access$1000(this.this$0), bounds.width);
                    ToolTipHandler.access$600(this.this$0).setVisible(true);
                }
            });
        }

        private void fillText(Collision collision) {
            String template = "  * {0}\n  * {1}\n  * {2}\n";
            this.appendNormal(MessageFormat.format(template, MessageHandler.getTypeMessage(collision), MessageHandler.getResolveMessage(collision), MessageHandler.getStateMessage(collision)));
            if (collision.getCollisionState() == CollisionState.RESOLVED) {
                this.fIconLabel.setImage(fResolvedImage.getImage());
            } else if (collision.getCollisionState() == CollisionState.PARTIALLY_RESOLVED) {
                this.fIconLabel.setImage(fWarningImage.getImage());
            } else {
                this.fIconLabel.setImage(fInfoImage.getImage());
            }
        }

        private int getColumnIndex(Table table, int x) {
            TableColumn[] columns = table.getColumns();
            int currentPosition = 0;
            int i = 0;
            while (i < columns.length) {
                int width = columns[i].getWidth();
                if (x > currentPosition && x <= currentPosition + width) {
                    return i;
                }
                currentPosition += width;
                ++i;
            }
            return -1;
        }

        private void setHoverLocation(Shell shell, Point position, int itemWidth) {
            Rectangle displayBounds = shell.getDisplay().getBounds();
            Rectangle shellBounds = shell.getBounds();
            shellBounds.x = Math.max(Math.min(position.x, displayBounds.width - shellBounds.width), 0);
            shellBounds.y = Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
            shell.setBounds(shellBounds);
        }

        static /* synthetic */ Shell access$600(ToolTipHandler x0) {
            return x0.tipShell;
        }

        static /* synthetic */ Widget access$702(ToolTipHandler x0, Widget x1) {
            x0.tipWidget = x1;
            return x0.tipWidget;
        }

        static /* synthetic */ int access$800(ToolTipHandler x0, Table x1, int x2) {
            return x0.getColumnIndex(x1, x2);
        }

        static /* synthetic */ Widget access$700(ToolTipHandler x0) {
            return x0.tipWidget;
        }

        static /* synthetic */ int access$900(ToolTipHandler x0) {
            return x0.widgetColumn;
        }

        static /* synthetic */ int access$902(ToolTipHandler x0, int x1) {
            x0.widgetColumn = x1;
            return x0.widgetColumn;
        }

        static /* synthetic */ Point access$1002(ToolTipHandler x0, Point x1) {
            x0.tipPosition = x1;
            return x0.tipPosition;
        }

        static /* synthetic */ Point access$1000(ToolTipHandler x0) {
            return x0.tipPosition;
        }

        static /* synthetic */ StyledText access$1100(ToolTipHandler x0) {
            return x0.styledText;
        }

        static /* synthetic */ void access$1200(ToolTipHandler x0, Collision x1) {
            x0.fillText(x1);
        }

        static /* synthetic */ void access$1300(ToolTipHandler x0, Shell x1, Point x2, int x3) {
            x0.setHoverLocation(x1, x2, x3);
        }
    }
}

