/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions.conflict;

import com.tssap.dtr.client.eclipse.ui.actions.conflict.AbstractConflictAction;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.IVfsCheckinCollision;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class AcceptActiveVersionAction
extends AbstractConflictAction {
    private static final String DIALOG_TITLE_ATTRIBUTE = "dialogTitle";
    private static final String DIALOG_MESSAGE_ATTRIBUTE = "dialogMessage";
    private static final String DEFAULT_DIALOG_TITLE = "Accept Active (Remote) Version(s)";
    private static final String DEFAULT_DIALOG_MESSAGE = "This action will result in the loss of your local changes. \n Are you sure to accept the Active (Remote) version(s) ?";

    protected void proceedAction(final IStructuredSelection selection, IAction action) throws VfsException {
        String dialogTitle = this.getConfigProperty(DIALOG_TITLE_ATTRIBUTE, DEFAULT_DIALOG_TITLE);
        String dialogMessage = this.getConfigProperty(DIALOG_MESSAGE_ATTRIBUTE, DEFAULT_DIALOG_MESSAGE);
        MessageDialog dialog = new MessageDialog(this.getShell(), dialogTitle, null, dialogMessage, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (dialog.open() == 0) {
            final VfsException[] thrownException = new VfsException[1];
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        Iterator collisionIterator = selection.iterator();
                        while (collisionIterator.hasNext()) {
                            Object element = collisionIterator.next();
                            IVfsCheckinCollision checkinCollision = AcceptActiveVersionAction.this.getCheckinCollision(element);
                            IVfsFolderItem item = checkinCollision.getFolderItemForCollidingVersion();
                            checkinCollision.acceptActiveVersion();
                            Logbook.getInfoChapter().println(MessageFormat.format("{0} ({1})- Active (Remote) version is accepted. Conflict resolved successfully", item.getDisplayName(), item.getLocalPath()));
                        }
                    }
                    catch (VfsException e) {
                        thrownException[0] = e;
                    }
                }
            });
            if (thrownException[0] != null) {
                throw thrownException[0];
            }
        }
    }
}

