/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions.compare;

import com.tssap.dtr.client.eclipse.ui.conflict.ConflictUtility;
import com.tssap.dtr.client.eclipse.ui.conflict.DAVTextMergeViewer;
import com.tssap.dtr.client.eclipse.ui.conflict.DiffEditorInput;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DiffEditorVersionsInput
extends CompareEditorInput {
    private DiffEditorInput[] myInputs;
    private Viewer myContentViewer = null;
    private DTRDiffTreeViewer fDiffViewer;

    public DiffEditorVersionsInput(File file, IVfsVersion[] versions, IVfsVersion ancestor, boolean writable, String[] versionTitles) {
        super(new CompareConfiguration());
        this.getCompareConfiguration().setRightEditable(false);
        ArrayList<DiffEditorInput> inputs = new ArrayList<DiffEditorInput>();
        int i = 0;
        while (i < versions.length) {
            if (!versions[i].isOpen()) {
                DiffEditorInput input = new DiffEditorInput(file, new IVfsVersion[]{versions[i]}, ancestor, writable);
                if (versionTitles != null && versionTitles[i] != null) {
                    input.setTitle(versionTitles[i]);
                } else {
                    input.setTitle("Version " + versions[i].getLocationInGraph());
                }
                inputs.add(input);
            }
            ++i;
        }
        this.myInputs = new DiffEditorInput[inputs.size()];
        this.myInputs = inputs.toArray(this.myInputs);
    }

    public Viewer createDiffViewer(Composite parent) {
        this.fDiffViewer = new DTRDiffTreeViewer(parent, this.getCompareConfiguration());
        this.fDiffViewer.setSorter(null);
        return this.fDiffViewer;
    }

    public void setCustomTitle(String title) {
        if (this.fDiffViewer != null) {
            this.fDiffViewer.setTitle(title);
        }
    }

    public Control createContents(Composite parent) {
        Control out = super.createContents(parent);
        this.fDiffViewer.openSelectedItem();
        return out;
    }

    public void tmpOpen() {
        this.fDiffViewer.openSelectedItem();
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        DiffNode diffRoot = new DiffNode(0);
        int i = 0;
        while (i < this.myInputs.length) {
            this.myInputs[i].run(monitor);
            if (this.myInputs[i].getCompareResult() != null) {
                DiffNode diffNode = (DiffNode)this.myInputs[i].getCompareResult();
                MyDiffNode newDiffNode = new MyDiffNode(diffNode.getParent(), diffNode.getKind(), diffNode.getAncestor(), diffNode.getLeft(), diffNode.getRight());
                newDiffNode.setName(this.myInputs[i].getTitle());
                diffRoot.add((IDiffElement)newDiffNode);
            }
            ++i;
        }
        return diffRoot;
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        this.getCompareConfiguration().setRightLabel(input.getName());
        String type = ConflictUtility.guessType(input.getLeft());
        boolean text = "txt".equals(type);
        if (!text) {
            this.myContentViewer = super.findContentViewer(oldViewer, input, parent);
        } else if (this.myContentViewer == null || !(oldViewer instanceof DAVTextMergeViewer)) {
            this.myContentViewer = new DAVTextMergeViewer(parent, 0, this.getCompareConfiguration());
            Control c = this.myContentViewer.getControl();
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (DiffEditorVersionsInput.this.myContentViewer instanceof DAVTextMergeViewer) {
                        ((DAVTextMergeViewer)DiffEditorVersionsInput.this.myContentViewer).disposeResources();
                    }
                }
            });
        }
        return this.myContentViewer;
    }

    class DTRDiffTreeViewer
    extends DiffTreeViewer {
        private String fCustomTitle;

        public DTRDiffTreeViewer(Composite parent, CompareConfiguration configuration) {
            super(parent, configuration);
        }

        public String getTitle() {
            if (this.fCustomTitle == null) {
                return "Compare Local File with:";
            }
            return this.fCustomTitle;
        }

        public void setTitle(String title) {
            this.fCustomTitle = title;
        }

        public void openSelectedItem() {
            this.handleDoubleSelect(null);
            this.handleOpen(null);
        }
    }

    class MyDiffNode
    extends DiffNode {
        private String myName = null;

        public MyDiffNode(IDiffContainer parent, int description, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, description, ancestor, left, right);
        }

        public String getName() {
            return this.myName == null ? super.getName() : this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }
    }
}

