/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions.compare;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.ui.actions.AbstractDiffMergeAction;
import com.tssap.dtr.client.eclipse.ui.actions.compare.DiffEditorVersionsInput;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsVersionHistory;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.io.File;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CompareWithVersionAction
extends AbstractDiffMergeAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$compare$CompareWithVersionAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$compare$CompareWithVersionAction = CompareWithVersionAction.class$("com.tssap.dtr.client.eclipse.ui.actions.compare.CompareWithVersionAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$compare$CompareWithVersionAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$compare$CompareWithVersionAction;

    protected boolean allowedMultipleSelection() {
        return false;
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        IVfsFile file;
        Object item = selection.getFirstElement();
        return item instanceof IVfsFile && (file = (IVfsFile)item).getLocationState() != VfsFolderItemLocationState.SERVER_ONLY && file.getLocationState() != VfsFolderItemLocationState.LOCAL_ONLY && file.getActivityState() != VfsFolderItemActivityState.CHECKED_OUT_FOR_DELETE;
    }

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        IVfsFile file;
        if (selection.getFirstElement() instanceof IVfsFile && (file = (IVfsFile)selection.getFirstElement()).getLocalFile().exists()) {
            try {
                IVfsVersionHistory versionHistory = file.refreshAndGetVersionHistory();
                String title = file.getDisplayName() + " - Comparing local file with version in repository.";
                DiffEditorVersionsInput input = new DiffEditorVersionsInput(new File(file.getLocalFile().getAbsolutePath()), versionHistory.getVersionSet(), null, false, null);
                input.setTitle(title);
                input.getCompareConfiguration().setLeftLabel(file.getLocalFile().getAbsolutePath());
                input.getCompareConfiguration().setLeftEditable(file.getLocalFile().canWrite());
                if (file.getLocalFile().canWrite()) {
                    input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
                }
                CompareUI.openCompareEditor((CompareEditorInput)input);
            }
            catch (VfsException e) {
                this.showErrorMessage("Can't retrieve file informations." + e.getLocalizedMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

