/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions.compare;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.preference.DtrPreferenceManager;
import com.tssap.dtr.client.eclipse.ui.actions.CompareWithActiveVersionAction;
import com.tssap.dtr.client.eclipse.ui.conflict.DiffEditorInput;
import com.tssap.dtr.client.eclipse.ui.conflict.ExternalAction;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsVersion;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.io.File;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CompareWithActiveAction
extends CompareWithActiveVersionAction {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$eclipse$ui$actions$compare$CompareWithActiveAction == null ? (class$com$tssap$dtr$client$eclipse$ui$actions$compare$CompareWithActiveAction = CompareWithActiveAction.class$("com.tssap.dtr.client.eclipse.ui.actions.compare.CompareWithActiveAction")) : class$com$tssap$dtr$client$eclipse$ui$actions$compare$CompareWithActiveAction));
    static /* synthetic */ Class class$com$tssap$dtr$client$eclipse$ui$actions$compare$CompareWithActiveAction;

    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor workerThreadMonitor) {
        IVfsFile file;
        DtrPreferenceManager prefManager = BluebirdPlugin.getDefault().getPreferenceManager();
        if (selection.getFirstElement() instanceof IVfsFile && (file = (IVfsFile)selection.getFirstElement()).getLocalFile().exists()) {
            try {
                IVfsVersion activeVersion = file.getActiveVersion();
                String title = file.getDisplayName() + " - Comparing local file with active version in repository.";
                if (prefManager.isUseExternalDiff()) {
                    File leftFile = ExternalAction.createTmpFile(activeVersion, "_Version_" + activeVersion.getBranchSequenceNumber() + "_");
                    this.runExternalDiff(leftFile, new File(file.getLocalFile().getAbsolutePath()), false);
                } else {
                    DiffEditorInput input = new DiffEditorInput(new File(file.getLocalFile().getAbsolutePath()), new IVfsVersion[]{activeVersion}, null, false);
                    input.setTitle(title);
                    input.getCompareConfiguration().setLeftLabel(file.getLocalFile().getAbsolutePath());
                    input.getCompareConfiguration().setRightLabel("Active (Remote) Version " + activeVersion.getBranchSequenceNumber() + " created in workspace: " + activeVersion.getCreatorWorkspaceName());
                    input.getCompareConfiguration().setRightEditable(activeVersion.isOpen());
                    input.getCompareConfiguration().setLeftEditable(file.getLocalFile().canWrite());
                    if (file.getLocalFile().canWrite()) {
                        input.getCompareConfiguration().setProperty("Accept enabled", (Object)Boolean.TRUE);
                    }
                    CompareUI.openCompareEditor((CompareEditorInput)input);
                }
            }
            catch (VfsException e) {
                this.showErrorMessage("Can't retrieve file informations." + e.getLocalizedMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

