/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.eclipse.ui.actions;

import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryView;
import com.tssap.dtr.client.lib.exceptions.ClientLibraryException;
import com.tssap.dtr.client.lib.util.Logbook;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import com.tssap.dtr.client.lib.vfs.actions.VfsActionManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public final class WorkerThreadProgressMonitor
implements IVfsProgressMonitor {
    private final IWorkbenchPart m_targetPart;
    private Shell m_shell;
    private final KeyListener KEY_LISTENER_ESC = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if (e.character == '\u001b') {
                VfsActionManager.getInstance().interrupt();
                Logbook.getWarnChapter((int)3).println("Interrupting...");
                WorkerThreadProgressMonitor.this.setMessageOnStatusLine("Interrupting...", 2);
            }
        }
    };

    public WorkerThreadProgressMonitor(IWorkbenchPart targetPart) {
        this.m_targetPart = targetPart;
        this.m_shell = targetPart.getSite().getShell();
        if (this.m_shell == null) {
            this.m_shell = Display.getDefault().getActiveShell();
        }
    }

    public void onStart() {
        this.m_shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                WorkerThreadProgressMonitor.this.m_shell.getMenuBar().setEnabled(false);
                Control[] controls = WorkerThreadProgressMonitor.this.m_shell.getChildren();
                int i = 0;
                while (i < controls.length) {
                    controls[i].setEnabled(false);
                    ++i;
                }
                WorkerThreadProgressMonitor.this.m_shell.addKeyListener(WorkerThreadProgressMonitor.this.KEY_LISTENER_ESC);
                WorkerThreadProgressMonitor.this.m_shell.setCursor(new Cursor((Device)WorkerThreadProgressMonitor.this.m_shell.getDisplay(), 1));
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (activePage != null) {
                    activePage.activate(WorkerThreadProgressMonitor.this.m_targetPart);
                }
                WorkerThreadProgressMonitor.this.setMessageOnStatusLine("Press ESC to interrupt", 1);
            }
        });
    }

    public void onProgress(int arg0) {
    }

    public void onFinish(final Throwable throwable) {
        if (Thread.interrupted()) {
            // empty if block
        }
        this.m_shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                WorkerThreadProgressMonitor.this.m_shell.getMenuBar().setEnabled(true);
                Control[] controls = WorkerThreadProgressMonitor.this.m_shell.getChildren();
                int i = 0;
                while (i < controls.length) {
                    controls[i].setEnabled(true);
                    ++i;
                }
                WorkerThreadProgressMonitor.this.m_shell.removeKeyListener(WorkerThreadProgressMonitor.this.KEY_LISTENER_ESC);
                WorkerThreadProgressMonitor.this.m_shell.setCursor(new Cursor((Device)WorkerThreadProgressMonitor.this.m_shell.getDisplay(), 0));
                WorkerThreadProgressMonitor.this.setMessageOnStatusLine(null, 0);
                if (WorkerThreadProgressMonitor.this.m_targetPart instanceof RepositoryView) {
                    ISelection selection;
                    TreeViewer treeViewer = ((RepositoryView)WorkerThreadProgressMonitor.this.m_targetPart).getRepositoryTreeViewer().getTreeViewer();
                    if (treeViewer.testFindItem(((IStructuredSelection)(selection = treeViewer.getSelection())).getFirstElement()) != null) {
                        treeViewer.setSelection(treeViewer.getSelection(), true);
                    }
                    WorkerThreadProgressMonitor.this.m_targetPart.setFocus();
                }
                if (throwable != null) {
                    ClientLibraryException clientLibraryException;
                    String msg = throwable.getMessage();
                    if (throwable instanceof ClientLibraryException && (clientLibraryException = (ClientLibraryException)throwable).getCause() != null) {
                        msg = msg + " [" + clientLibraryException.getCause().getMessage() + "]";
                    }
                    Logbook.getErrorChapter().println(msg);
                    WorkerThreadProgressMonitor.this.setMessageOnStatusLine(msg, 3);
                }
            }
        });
    }

    public void onFinish(final Throwable throwable, final boolean alreadyLoggedInActionLog) {
        if (Thread.interrupted()) {
            // empty if block
        }
        this.m_shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                WorkerThreadProgressMonitor.this.m_shell.getMenuBar().setEnabled(true);
                Control[] controls = WorkerThreadProgressMonitor.this.m_shell.getChildren();
                int i = 0;
                while (i < controls.length) {
                    controls[i].setEnabled(true);
                    ++i;
                }
                WorkerThreadProgressMonitor.this.m_shell.removeKeyListener(WorkerThreadProgressMonitor.this.KEY_LISTENER_ESC);
                WorkerThreadProgressMonitor.this.m_shell.setCursor(new Cursor((Device)WorkerThreadProgressMonitor.this.m_shell.getDisplay(), 0));
                WorkerThreadProgressMonitor.this.setMessageOnStatusLine(null, 0);
                if (WorkerThreadProgressMonitor.this.m_targetPart instanceof RepositoryView) {
                    ISelection selection;
                    TreeViewer treeViewer = ((RepositoryView)WorkerThreadProgressMonitor.this.m_targetPart).getRepositoryTreeViewer().getTreeViewer();
                    if (treeViewer.testFindItem(((IStructuredSelection)(selection = treeViewer.getSelection())).getFirstElement()) != null) {
                        treeViewer.setSelection(treeViewer.getSelection(), true);
                    }
                    WorkerThreadProgressMonitor.this.m_targetPart.setFocus();
                }
                if (throwable != null) {
                    ClientLibraryException clientLibraryException;
                    String msg = throwable.getMessage();
                    if (throwable instanceof ClientLibraryException && (clientLibraryException = (ClientLibraryException)throwable).getCause() != null) {
                        msg = msg + " [" + clientLibraryException.getCause().getMessage() + "]";
                    }
                    if (!alreadyLoggedInActionLog) {
                        Logbook.getErrorChapter().println(msg);
                    }
                    WorkerThreadProgressMonitor.this.setMessageOnStatusLine(msg, 3);
                }
            }
        });
    }

    private void setMessageOnStatusLine(String message, int messageType) {
        if (this.m_targetPart.getSite() instanceof IViewSite) {
            IStatusLineManager statusLine = ((IViewSite)this.m_targetPart.getSite()).getActionBars().getStatusLineManager();
            if (statusLine == null) {
                return;
            }
            statusLine.setErrorMessage(null);
            statusLine.setMessage(null, null);
            switch (messageType) {
                case 3: {
                    statusLine.setErrorMessage(Dialog.getImage((String)"dialog_message_error_image"), message);
                    break;
                }
                case 1: {
                    statusLine.setMessage(Dialog.getImage((String)"dialog_messasge_info_image"), message);
                    break;
                }
                case 2: {
                    statusLine.setMessage(Dialog.getImage((String)"dialog_messasge_warning_image"), message);
                    break;
                }
                default: {
                    statusLine.setMessage(message);
                }
            }
        }
    }
}

